/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.policies.ConstantSpeculativeExecutionPolicy;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.ExponentialReconnectionPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import com.datastax.driver.core.policies.SpeculativeExecutionPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import com.datastax.driver.core.policies.WhiteListPolicy;
import com.facebook.presto.cassandra.CassandraClientConfig;
import com.facebook.presto.cassandra.CassandraConnector;
import com.facebook.presto.cassandra.CassandraConnectorId;
import com.facebook.presto.cassandra.CassandraMetadata;
import com.facebook.presto.cassandra.CassandraPageSinkProvider;
import com.facebook.presto.cassandra.CassandraPartitionManager;
import com.facebook.presto.cassandra.CassandraRecordSetProvider;
import com.facebook.presto.cassandra.CassandraSession;
import com.facebook.presto.cassandra.CassandraSessionProperties;
import com.facebook.presto.cassandra.CassandraSplitManager;
import com.facebook.presto.cassandra.CassandraTokenSplitManager;
import com.facebook.presto.cassandra.ExtraColumnMetadata;
import com.facebook.presto.cassandra.NativeCassandraSession;
import com.facebook.presto.cassandra.ReopeningCluster;
import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import io.airlift.configuration.ConfigBinder;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecBinder;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.inject.Singleton;

public class CassandraClientModule
implements Module {
    private final String connectorId;

    public CassandraClientModule(String connectorId) {
        this.connectorId = connectorId;
    }

    public void configure(Binder binder) {
        binder.bind(CassandraConnectorId.class).toInstance((Object)new CassandraConnectorId(this.connectorId));
        binder.bind(CassandraConnector.class).in(Scopes.SINGLETON);
        binder.bind(CassandraMetadata.class).in(Scopes.SINGLETON);
        binder.bind(CassandraSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(CassandraTokenSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(CassandraRecordSetProvider.class).in(Scopes.SINGLETON);
        binder.bind(CassandraPageSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(CassandraPartitionManager.class).in(Scopes.SINGLETON);
        binder.bind(CassandraSessionProperties.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(CassandraClientConfig.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindListJsonCodec(ExtraColumnMetadata.class);
    }

    @Singleton
    @Provides
    public static CassandraSession createCassandraSession(CassandraConnectorId connectorId, CassandraClientConfig config, JsonCodec<List<ExtraColumnMetadata>> extraColumnMetadataCodec) {
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(extraColumnMetadataCodec, "extraColumnMetadataCodec is null");
        Cluster.Builder clusterBuilder = Cluster.builder().withProtocolVersion(config.getProtocolVersion());
        List<String> contactPoints = Objects.requireNonNull(config.getContactPoints(), "contactPoints is null");
        Preconditions.checkArgument((!contactPoints.isEmpty() ? 1 : 0) != 0, (Object)"empty contactPoints");
        clusterBuilder.withPort(config.getNativeProtocolPort());
        clusterBuilder.withReconnectionPolicy((ReconnectionPolicy)new ExponentialReconnectionPolicy(500L, 10000L));
        clusterBuilder.withRetryPolicy(config.getRetryPolicy().getPolicy());
        RoundRobinPolicy loadPolicy = new RoundRobinPolicy();
        if (config.isUseDCAware()) {
            Objects.requireNonNull(config.getDcAwareLocalDC(), "DCAwarePolicy localDC is null");
            DCAwareRoundRobinPolicy.Builder builder = DCAwareRoundRobinPolicy.builder().withLocalDc(config.getDcAwareLocalDC());
            if (config.getDcAwareUsedHostsPerRemoteDc() > 0) {
                builder.withUsedHostsPerRemoteDc(config.getDcAwareUsedHostsPerRemoteDc().intValue());
                if (config.isDcAwareAllowRemoteDCsForLocal()) {
                    builder.allowRemoteDCsForLocalConsistencyLevel();
                }
            }
            loadPolicy = builder.build();
        }
        if (config.isUseTokenAware()) {
            loadPolicy = new TokenAwarePolicy((LoadBalancingPolicy)loadPolicy, config.isTokenAwareShuffleReplicas());
        }
        if (config.isUseWhiteList()) {
            Preconditions.checkArgument((!config.getWhiteListAddresses().isEmpty() ? 1 : 0) != 0, (Object)"empty WhiteListAddresses");
            ArrayList<InetSocketAddress> whiteList = new ArrayList<InetSocketAddress>();
            for (String point : config.getWhiteListAddresses()) {
                whiteList.add(new InetSocketAddress(point, config.getNativeProtocolPort()));
            }
            loadPolicy = new WhiteListPolicy((LoadBalancingPolicy)loadPolicy, whiteList);
        }
        clusterBuilder.withLoadBalancingPolicy((LoadBalancingPolicy)loadPolicy);
        SocketOptions socketOptions = new SocketOptions();
        socketOptions.setReadTimeoutMillis(Math.toIntExact(config.getClientReadTimeout().toMillis()));
        socketOptions.setConnectTimeoutMillis(Math.toIntExact(config.getClientConnectTimeout().toMillis()));
        if (config.getClientSoLinger() != null) {
            socketOptions.setSoLinger(config.getClientSoLinger().intValue());
        }
        clusterBuilder.withSocketOptions(socketOptions);
        if (config.getUsername() != null && config.getPassword() != null) {
            clusterBuilder.withCredentials(config.getUsername(), config.getPassword());
        }
        QueryOptions options = new QueryOptions();
        options.setFetchSize(config.getFetchSize());
        options.setConsistencyLevel(config.getConsistencyLevel());
        clusterBuilder.withQueryOptions(options);
        if (config.getSpeculativeExecutionLimit() > 1) {
            clusterBuilder.withSpeculativeExecutionPolicy((SpeculativeExecutionPolicy)new ConstantSpeculativeExecutionPolicy(config.getSpeculativeExecutionDelay().toMillis(), config.getSpeculativeExecutionLimit()));
        }
        return new NativeCassandraSession(connectorId.toString(), extraColumnMetadataCodec, (Cluster)new ReopeningCluster(() -> {
            contactPoints.forEach(arg_0 -> ((Cluster.Builder)clusterBuilder).addContactPoint(arg_0));
            return clusterBuilder.build();
        }), config.getNoHostAvailableRetryTimeout());
    }
}

