/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.datastax.driver.core.ProtocolVersion;
import com.facebook.presto.cassandra.CassandraClientConfig;
import com.facebook.presto.cassandra.CassandraInsertTableHandle;
import com.facebook.presto.cassandra.CassandraOutputTableHandle;
import com.facebook.presto.cassandra.CassandraPageSink;
import com.facebook.presto.cassandra.CassandraSession;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PageSinkContext;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.inject.Inject;

public class CassandraPageSinkProvider
implements ConnectorPageSinkProvider {
    private final CassandraSession cassandraSession;
    private final ProtocolVersion protocolVersion;

    @Inject
    public CassandraPageSinkProvider(CassandraSession cassandraSession, CassandraClientConfig cassandraClientConfig) {
        this.cassandraSession = Objects.requireNonNull(cassandraSession, "cassandraSession is null");
        this.protocolVersion = Objects.requireNonNull(cassandraClientConfig, "cassandraClientConfig is null").getProtocolVersion();
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle tableHandle, PageSinkContext pageSinkContext) {
        Preconditions.checkArgument((!pageSinkContext.isCommitRequired() ? 1 : 0) != 0, (Object)"Cassandra connector does not support page sink commit");
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof CassandraOutputTableHandle), (Object)"tableHandle is not an instance of CassandraOutputTableHandle");
        CassandraOutputTableHandle handle = (CassandraOutputTableHandle)tableHandle;
        return new CassandraPageSink(this.cassandraSession, this.protocolVersion, handle.getSchemaName(), handle.getTableName(), handle.getColumnNames(), handle.getColumnTypes(), true);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle tableHandle, PageSinkContext pageSinkContext) {
        Preconditions.checkArgument((!pageSinkContext.isCommitRequired() ? 1 : 0) != 0, (Object)"Cassandra connector does not support page sink commit");
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof CassandraInsertTableHandle), (Object)"tableHandle is not an instance of ConnectorInsertTableHandle");
        CassandraInsertTableHandle handle = (CassandraInsertTableHandle)tableHandle;
        return new CassandraPageSink(this.cassandraSession, this.protocolVersion, handle.getSchemaName(), handle.getTableName(), handle.getColumnNames(), handle.getColumnTypes(), false);
    }
}

