/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.cassandra.CassandraTableHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Objects;

public class CassandraSplit
implements ConnectorSplit {
    private final String connectorId;
    private final String partitionId;
    private final List<HostAddress> addresses;
    private final String schema;
    private final String table;
    private final String splitCondition;

    @JsonCreator
    public CassandraSplit(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="schema") String schema, @JsonProperty(value="table") String table, @JsonProperty(value="partitionId") String partitionId, @JsonProperty(value="splitCondition") String splitCondition, @JsonProperty(value="addresses") List<HostAddress> addresses) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(table, "table is null");
        Objects.requireNonNull(partitionId, "partitionName is null");
        Objects.requireNonNull(addresses, "addresses is null");
        this.connectorId = connectorId;
        this.schema = schema;
        this.table = table;
        this.partitionId = partitionId;
        this.addresses = ImmutableList.copyOf(addresses);
        this.splitCondition = splitCondition;
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public String getSplitCondition() {
        return this.splitCondition;
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    @JsonProperty
    public String getPartitionId() {
        return this.partitionId;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public List<HostAddress> getPreferredNodes(List<HostAddress> sortedCandidates) {
        return this.addresses;
    }

    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return NodeSelectionStrategy.NO_PREFERENCE;
    }

    public Object getInfo() {
        return ImmutableMap.builder().put((Object)"hosts", this.addresses).put((Object)"schema", (Object)this.schema).put((Object)"table", (Object)this.table).put((Object)"partitionId", (Object)this.partitionId).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.table).addValue((Object)this.partitionId).toString();
    }

    public String getWhereClause() {
        if (this.partitionId.equals("<UNPARTITIONED>")) {
            if (this.splitCondition != null) {
                return " WHERE " + this.splitCondition;
            }
            return "";
        }
        if (this.splitCondition != null) {
            return " WHERE " + this.partitionId + " AND " + this.splitCondition;
        }
        return " WHERE " + this.partitionId;
    }

    public CassandraTableHandle getCassandraTableHandle() {
        return new CassandraTableHandle(this.connectorId, this.schema, this.table);
    }
}

