/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra.util;

import com.facebook.airlift.security.pem.PemReader;
import com.facebook.presto.cassandra.CassandraErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;

public class SslContextProvider {
    private final Optional<File> keystorePath;
    private final Optional<String> keystorePassword;
    private final Optional<File> truststorePath;
    private final Optional<String> truststorePassword;

    public SslContextProvider(Optional<File> keystorePath, Optional<String> keystorePassword, Optional<File> truststorePath, Optional<String> truststorePassword) {
        this.keystorePath = keystorePath;
        this.keystorePassword = keystorePassword;
        this.truststorePath = truststorePath;
        this.truststorePassword = truststorePassword;
    }

    public Optional<SSLContext> buildSslContext() {
        if (!this.keystorePath.isPresent() && !this.truststorePath.isPresent()) {
            return Optional.empty();
        }
        try {
            KeyStore keystore = null;
            KeyManager[] keyManagers = null;
            if (this.keystorePath.isPresent()) {
                char[] keyManagerPassword;
                try {
                    keystore = PemReader.loadKeyStore((File)this.keystorePath.get(), (File)this.keystorePath.get(), this.keystorePassword);
                    keyManagerPassword = new char[]{};
                }
                catch (IOException | GeneralSecurityException ignored) {
                    keyManagerPassword = this.keystorePassword.map(String::toCharArray).orElse(null);
                    keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                    try (FileInputStream in = new FileInputStream(this.keystorePath.get());){
                        keystore.load(in, keyManagerPassword);
                    }
                }
                this.validateCertificates(keystore);
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keystore, keyManagerPassword);
                keyManagers = keyManagerFactory.getKeyManagers();
            }
            KeyStore truststore = keystore;
            if (this.truststorePath.isPresent()) {
                truststore = this.loadTrustStore(this.truststorePath.get(), this.truststorePassword);
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(truststore);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new RuntimeException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            X509TrustManager trustManager = (X509TrustManager)trustManagers[0];
            SSLContext result = SSLContext.getInstance("SSL");
            result.init(keyManagers, new TrustManager[]{trustManager}, null);
            return Optional.of(result);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new PrestoException((ErrorCodeSupplier)CassandraErrorCode.CASSANDRA_SSL_INITIALIZATION_FAILURE, (Throwable)e);
        }
    }

    public KeyStore loadTrustStore(File trustStorePath, Optional<String> trustStorePassword) throws IOException, GeneralSecurityException {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try {
            List certificateChain = PemReader.readCertificateChain((File)trustStorePath);
            if (!certificateChain.isEmpty()) {
                trustStore.load(null, null);
                for (X509Certificate certificate : certificateChain) {
                    X500Principal principal = certificate.getSubjectX500Principal();
                    trustStore.setCertificateEntry(principal.getName(), certificate);
                }
                return trustStore;
            }
        }
        catch (IOException | GeneralSecurityException certificateChain) {
            // empty catch block
        }
        try (FileInputStream inputStream = new FileInputStream(trustStorePath);){
            trustStore.load(inputStream, trustStorePassword.map(String::toCharArray).orElse(null));
        }
        return trustStore;
    }

    public void validateCertificates(KeyStore keyStore) throws GeneralSecurityException {
        for (String alias : Collections.list(keyStore.aliases())) {
            Certificate certificate;
            if (!keyStore.isKeyEntry(alias) || !((certificate = keyStore.getCertificate(alias)) instanceof X509Certificate)) continue;
            try {
                ((X509Certificate)certificate).checkValidity();
            }
            catch (CertificateExpiredException e) {
                throw new CertificateExpiredException("KeyStore certificate is expired: " + e.getMessage());
            }
            catch (CertificateNotYetValidException e) {
                throw new CertificateNotYetValidException("KeyStore certificate is not yet valid: " + e.getMessage());
            }
        }
    }
}

