/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ProtocolVersion;
import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.airlift.configuration.ConfigSecuritySensitive;
import com.facebook.airlift.configuration.DefunctConfig;
import com.facebook.presto.cassandra.RetryPolicyType;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import io.airlift.units.MaxDuration;
import io.airlift.units.MinDuration;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@DefunctConfig(value={"cassandra.thrift-port", "cassandra.partitioner", "cassandra.thrift-connection-factory-class", "cassandra.transport-factory-options", "cassandra.no-host-available-retry-count", "cassandra.max-schema-refresh-threads", "cassandra.schema-cache-ttl", "cassandra.schema-refresh-interval"})
public class CassandraClientConfig {
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private ConsistencyLevel consistencyLevel = ConsistencyLevel.ONE;
    private int fetchSize = 5000;
    private List<String> contactPoints = ImmutableList.of();
    private int nativeProtocolPort = 9042;
    private int partitionSizeForBatchSelect = 100;
    private int splitSize = 1024;
    private Long splitsPerNode;
    private boolean allowDropTable;
    private String username;
    private String password;
    private Duration clientReadTimeout = new Duration(12000.0, TimeUnit.MILLISECONDS);
    private Duration clientConnectTimeout = new Duration(5000.0, TimeUnit.MILLISECONDS);
    private Integer clientSoLinger;
    private RetryPolicyType retryPolicy = RetryPolicyType.DEFAULT;
    private boolean useDCAware;
    private String dcAwareLocalDC;
    private int dcAwareUsedHostsPerRemoteDc;
    private boolean dcAwareAllowRemoteDCsForLocal;
    private boolean useTokenAware;
    private boolean tokenAwareShuffleReplicas;
    private boolean useWhiteList;
    private List<String> whiteListAddresses = ImmutableList.of();
    private Duration noHostAvailableRetryTimeout = new Duration(1.0, TimeUnit.MINUTES);
    private int speculativeExecutionLimit = 1;
    private Duration speculativeExecutionDelay = new Duration(500.0, TimeUnit.MILLISECONDS);
    private ProtocolVersion protocolVersion = ProtocolVersion.V3;
    private boolean tlsEnabled;
    private File truststorePath;
    private String truststorePassword;
    private File keystorePath;
    private String keystorePassword;

    @NotNull
    @Size(min=1)
    public @NotNull @Size(min=1) List<String> getContactPoints() {
        return this.contactPoints;
    }

    @Config(value="cassandra.contact-points")
    public CassandraClientConfig setContactPoints(String commaSeparatedList) {
        this.contactPoints = SPLITTER.splitToList((CharSequence)commaSeparatedList);
        return this;
    }

    public CassandraClientConfig setContactPoints(String ... contactPoints) {
        this.contactPoints = Arrays.asList(contactPoints);
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getNativeProtocolPort() {
        return this.nativeProtocolPort;
    }

    @Config(value="cassandra.native-protocol-port")
    public CassandraClientConfig setNativeProtocolPort(int nativeProtocolPort) {
        this.nativeProtocolPort = nativeProtocolPort;
        return this;
    }

    @NotNull
    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    @Config(value="cassandra.consistency-level")
    public CassandraClientConfig setConsistencyLevel(ConsistencyLevel level) {
        this.consistencyLevel = level;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getFetchSize() {
        return this.fetchSize;
    }

    @Config(value="cassandra.fetch-size")
    public CassandraClientConfig setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getPartitionSizeForBatchSelect() {
        return this.partitionSizeForBatchSelect;
    }

    @Config(value="cassandra.partition-size-for-batch-select")
    public CassandraClientConfig setPartitionSizeForBatchSelect(int partitionSizeForBatchSelect) {
        this.partitionSizeForBatchSelect = partitionSizeForBatchSelect;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getSplitSize() {
        return this.splitSize;
    }

    @Config(value="cassandra.split-size")
    public CassandraClientConfig setSplitSize(int splitSize) {
        this.splitSize = splitSize;
        return this;
    }

    public Optional<Long> getSplitsPerNode() {
        return Optional.ofNullable(this.splitsPerNode);
    }

    @Config(value="cassandra.splits-per-node")
    public CassandraClientConfig setSplitsPerNode(Long splitsPerNode) {
        this.splitsPerNode = splitsPerNode;
        return this;
    }

    public boolean getAllowDropTable() {
        return this.allowDropTable;
    }

    @Config(value="cassandra.allow-drop-table")
    @ConfigDescription(value="Allow hive connector to drop table")
    public CassandraClientConfig setAllowDropTable(boolean allowDropTable) {
        this.allowDropTable = allowDropTable;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    @Config(value="cassandra.username")
    public CassandraClientConfig setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    @Config(value="cassandra.password")
    @ConfigSecuritySensitive
    public CassandraClientConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    @MinDuration(value="1ms")
    @MaxDuration(value="1h")
    public Duration getClientReadTimeout() {
        return this.clientReadTimeout;
    }

    @Config(value="cassandra.client.read-timeout")
    public CassandraClientConfig setClientReadTimeout(Duration clientReadTimeout) {
        this.clientReadTimeout = clientReadTimeout;
        return this;
    }

    @MinDuration(value="1ms")
    @MaxDuration(value="1h")
    public Duration getClientConnectTimeout() {
        return this.clientConnectTimeout;
    }

    @Config(value="cassandra.client.connect-timeout")
    public CassandraClientConfig setClientConnectTimeout(Duration clientConnectTimeout) {
        this.clientConnectTimeout = clientConnectTimeout;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) Integer getClientSoLinger() {
        return this.clientSoLinger;
    }

    @Config(value="cassandra.client.so-linger")
    public CassandraClientConfig setClientSoLinger(Integer clientSoLinger) {
        this.clientSoLinger = clientSoLinger;
        return this;
    }

    @NotNull
    public RetryPolicyType getRetryPolicy() {
        return this.retryPolicy;
    }

    @Config(value="cassandra.retry-policy")
    public CassandraClientConfig setRetryPolicy(RetryPolicyType retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public boolean isUseDCAware() {
        return this.useDCAware;
    }

    @Config(value="cassandra.load-policy.use-dc-aware")
    public CassandraClientConfig setUseDCAware(boolean useDCAware) {
        this.useDCAware = useDCAware;
        return this;
    }

    public String getDcAwareLocalDC() {
        return this.dcAwareLocalDC;
    }

    @Config(value="cassandra.load-policy.dc-aware.local-dc")
    public CassandraClientConfig setDcAwareLocalDC(String dcAwareLocalDC) {
        this.dcAwareLocalDC = dcAwareLocalDC;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) Integer getDcAwareUsedHostsPerRemoteDc() {
        return this.dcAwareUsedHostsPerRemoteDc;
    }

    @Config(value="cassandra.load-policy.dc-aware.used-hosts-per-remote-dc")
    public CassandraClientConfig setDcAwareUsedHostsPerRemoteDc(Integer dcAwareUsedHostsPerRemoteDc) {
        this.dcAwareUsedHostsPerRemoteDc = dcAwareUsedHostsPerRemoteDc;
        return this;
    }

    public boolean isDcAwareAllowRemoteDCsForLocal() {
        return this.dcAwareAllowRemoteDCsForLocal;
    }

    @Config(value="cassandra.load-policy.dc-aware.allow-remote-dc-for-local")
    public CassandraClientConfig setDcAwareAllowRemoteDCsForLocal(boolean dcAwareAllowRemoteDCsForLocal) {
        this.dcAwareAllowRemoteDCsForLocal = dcAwareAllowRemoteDCsForLocal;
        return this;
    }

    public boolean isUseTokenAware() {
        return this.useTokenAware;
    }

    @Config(value="cassandra.load-policy.use-token-aware")
    public CassandraClientConfig setUseTokenAware(boolean useTokenAware) {
        this.useTokenAware = useTokenAware;
        return this;
    }

    public boolean isTokenAwareShuffleReplicas() {
        return this.tokenAwareShuffleReplicas;
    }

    @Config(value="cassandra.load-policy.token-aware.shuffle-replicas")
    public CassandraClientConfig setTokenAwareShuffleReplicas(boolean tokenAwareShuffleReplicas) {
        this.tokenAwareShuffleReplicas = tokenAwareShuffleReplicas;
        return this;
    }

    public boolean isUseWhiteList() {
        return this.useWhiteList;
    }

    @Config(value="cassandra.load-policy.use-white-list")
    public CassandraClientConfig setUseWhiteList(boolean useWhiteList) {
        this.useWhiteList = useWhiteList;
        return this;
    }

    public List<String> getWhiteListAddresses() {
        return this.whiteListAddresses;
    }

    @Config(value="cassandra.load-policy.white-list.addresses")
    public CassandraClientConfig setWhiteListAddresses(String commaSeparatedList) {
        this.whiteListAddresses = SPLITTER.splitToList((CharSequence)commaSeparatedList);
        return this;
    }

    @NotNull
    public Duration getNoHostAvailableRetryTimeout() {
        return this.noHostAvailableRetryTimeout;
    }

    @Config(value="cassandra.no-host-available-retry-timeout")
    public CassandraClientConfig setNoHostAvailableRetryTimeout(Duration noHostAvailableRetryTimeout) {
        this.noHostAvailableRetryTimeout = noHostAvailableRetryTimeout;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getSpeculativeExecutionLimit() {
        return this.speculativeExecutionLimit;
    }

    @Config(value="cassandra.speculative-execution.limit")
    public CassandraClientConfig setSpeculativeExecutionLimit(int speculativeExecutionLimit) {
        this.speculativeExecutionLimit = speculativeExecutionLimit;
        return this;
    }

    @MinDuration(value="1ms")
    public Duration getSpeculativeExecutionDelay() {
        return this.speculativeExecutionDelay;
    }

    @Config(value="cassandra.speculative-execution.delay")
    public CassandraClientConfig setSpeculativeExecutionDelay(Duration speculativeExecutionDelay) {
        this.speculativeExecutionDelay = speculativeExecutionDelay;
        return this;
    }

    @NotNull
    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    @Config(value="cassandra.protocol-version")
    public CassandraClientConfig setProtocolVersion(ProtocolVersion version) {
        this.protocolVersion = version;
        return this;
    }

    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    @Config(value="cassandra.tls.enabled")
    public CassandraClientConfig setTlsEnabled(boolean tlsEnabled) {
        this.tlsEnabled = tlsEnabled;
        return this;
    }

    public Optional<File> getKeystorePath() {
        return Optional.ofNullable(this.keystorePath);
    }

    @Config(value="cassandra.tls.keystore-path")
    public CassandraClientConfig setKeystorePath(File keystorePath) {
        this.keystorePath = keystorePath;
        return this;
    }

    public Optional<String> getKeystorePassword() {
        return Optional.ofNullable(this.keystorePassword);
    }

    @Config(value="cassandra.tls.keystore-password")
    @ConfigSecuritySensitive
    public CassandraClientConfig setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
        return this;
    }

    public Optional<File> getTruststorePath() {
        return Optional.ofNullable(this.truststorePath);
    }

    @Config(value="cassandra.tls.truststore-path")
    public CassandraClientConfig setTruststorePath(File truststorePath) {
        this.truststorePath = truststorePath;
        return this;
    }

    public Optional<String> getTruststorePassword() {
        return Optional.ofNullable(this.truststorePassword);
    }

    @Config(value="cassandra.tls.truststore-password")
    @ConfigSecuritySensitive
    public CassandraClientConfig setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
        return this;
    }
}

