/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.datastax.driver.core.VersionNumber;
import com.facebook.presto.cassandra.CassandraColumnHandle;
import com.facebook.presto.cassandra.util.CassandraCqlUtils;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.spi.ColumnHandle;
import com.google.common.base.Joiner;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CassandraClusteringPredicatesExtractor {
    private final List<CassandraColumnHandle> clusteringColumns;
    private final ClusteringPushDownResult clusteringPushDownResult;
    private final TupleDomain<ColumnHandle> predicates;

    public CassandraClusteringPredicatesExtractor(List<CassandraColumnHandle> clusteringColumns, TupleDomain<ColumnHandle> predicates, VersionNumber cassandraVersion) {
        this.clusteringColumns = ImmutableList.copyOf(clusteringColumns);
        this.predicates = Objects.requireNonNull(predicates, "predicates is null");
        this.clusteringPushDownResult = CassandraClusteringPredicatesExtractor.getClusteringKeysSet(clusteringColumns, predicates, Objects.requireNonNull(cassandraVersion, "cassandraVersion is null"));
    }

    public String getClusteringKeyPredicates() {
        return this.clusteringPushDownResult.getDomainQuery();
    }

    public TupleDomain<ColumnHandle> getUnenforcedConstraints() {
        Map<ColumnHandle, Domain> pushedDown = this.clusteringPushDownResult.getDomains();
        HashMap notPushedDown = new HashMap((Map)this.predicates.getDomains().get());
        if (!notPushedDown.isEmpty() && !pushedDown.isEmpty()) {
            notPushedDown.entrySet().removeAll(pushedDown.entrySet());
        }
        return TupleDomain.withColumnDomains(notPushedDown);
    }

    private static ClusteringPushDownResult getClusteringKeysSet(List<CassandraColumnHandle> clusteringColumns, TupleDomain<ColumnHandle> predicates, VersionNumber cassandraVersion) {
        ImmutableMap.Builder domainsBuilder = ImmutableMap.builder();
        ImmutableList.Builder clusteringColumnSql = ImmutableList.builder();
        int currentClusteringColumn = 0;
        for (CassandraColumnHandle columnHandle : clusteringColumns) {
            Domain domain = (Domain)((Map)predicates.getDomains().get()).get(columnHandle);
            if (domain == null || domain.isNullAllowed()) break;
            String predicateString = null;
            predicateString = (String)domain.getValues().getValuesProcessor().transform(ranges -> {
                ArrayList<String> singleValues = new ArrayList<String>();
                ArrayList<String> rangeConjuncts = new ArrayList<String>();
                String predicate = null;
                block10: for (Range range : ranges.getOrderedRanges()) {
                    if (range.isAll()) {
                        return null;
                    }
                    if (range.isSingleValue()) {
                        singleValues.add(CassandraCqlUtils.cqlValue(CassandraCqlUtils.toCQLCompatibleString(range.getSingleValue()), columnHandle.getCassandraType()));
                        continue;
                    }
                    if (!range.getLow().isLowerUnbounded()) {
                        switch (range.getLow().getBound()) {
                            case ABOVE: {
                                rangeConjuncts.add(CassandraCqlUtils.validColumnName(columnHandle.getName()) + " > " + CassandraCqlUtils.cqlValue(CassandraCqlUtils.toCQLCompatibleString(range.getLow().getValue()), columnHandle.getCassandraType()));
                                break;
                            }
                            case EXACTLY: {
                                rangeConjuncts.add(CassandraCqlUtils.validColumnName(columnHandle.getName()) + " >= " + CassandraCqlUtils.cqlValue(CassandraCqlUtils.toCQLCompatibleString(range.getLow().getValue()), columnHandle.getCassandraType()));
                                break;
                            }
                            case BELOW: {
                                throw new VerifyException("Low Marker should never use BELOW bound");
                            }
                            default: {
                                throw new AssertionError((Object)("Unhandled bound: " + range.getLow().getBound()));
                            }
                        }
                    }
                    if (range.getHigh().isUpperUnbounded()) continue;
                    switch (range.getHigh().getBound()) {
                        case ABOVE: {
                            throw new VerifyException("High Marker should never use ABOVE bound");
                        }
                        case EXACTLY: {
                            rangeConjuncts.add(CassandraCqlUtils.validColumnName(columnHandle.getName()) + " <= " + CassandraCqlUtils.cqlValue(CassandraCqlUtils.toCQLCompatibleString(range.getHigh().getValue()), columnHandle.getCassandraType()));
                            continue block10;
                        }
                        case BELOW: {
                            rangeConjuncts.add(CassandraCqlUtils.validColumnName(columnHandle.getName()) + " < " + CassandraCqlUtils.cqlValue(CassandraCqlUtils.toCQLCompatibleString(range.getHigh().getValue()), columnHandle.getCassandraType()));
                            continue block10;
                        }
                    }
                    throw new AssertionError((Object)("Unhandled bound: " + range.getHigh().getBound()));
                }
                if (!singleValues.isEmpty() && !rangeConjuncts.isEmpty()) {
                    return null;
                }
                if (!singleValues.isEmpty()) {
                    predicate = singleValues.size() == 1 ? CassandraCqlUtils.validColumnName(columnHandle.getName()) + " = " + singleValues.get(0) : CassandraCqlUtils.validColumnName(columnHandle.getName()) + " IN (" + Joiner.on((String)",").join(singleValues) + ")";
                } else if (!rangeConjuncts.isEmpty()) {
                    predicate = Joiner.on((String)" AND ").join(rangeConjuncts);
                }
                return predicate;
            }, discreteValues -> {
                if (discreteValues.isWhiteList()) {
                    ImmutableList.Builder discreteValuesList = ImmutableList.builder();
                    for (Object discreteValue : discreteValues.getValues()) {
                        discreteValuesList.add((Object)CassandraCqlUtils.cqlValue(CassandraCqlUtils.toCQLCompatibleString(discreteValue), columnHandle.getCassandraType()));
                    }
                    String predicate = CassandraCqlUtils.validColumnName(columnHandle.getName()) + " IN (" + Joiner.on((String)",").join((Iterable)discreteValuesList.build()) + ")";
                    return predicate;
                }
                return null;
            }, allOrNone -> null);
            if (predicateString == null || predicateString.contains(" IN (") && cassandraVersion.compareTo(VersionNumber.parse((String)"2.2.0")) < 0 && currentClusteringColumn != clusteringColumns.size() - 1) break;
            clusteringColumnSql.add((Object)predicateString);
            domainsBuilder.put((Object)columnHandle, (Object)domain);
            if (predicateString.contains(">") || predicateString.contains("<")) break;
            ++currentClusteringColumn;
        }
        ImmutableList clusteringColumnPredicates = clusteringColumnSql.build();
        return new ClusteringPushDownResult((Map<ColumnHandle, Domain>)domainsBuilder.build(), Joiner.on((String)" AND ").join((Iterable)clusteringColumnPredicates));
    }

    private static class ClusteringPushDownResult {
        private final Map<ColumnHandle, Domain> domains;
        private final String domainQuery;

        public ClusteringPushDownResult(Map<ColumnHandle, Domain> domains, String domainQuery) {
            this.domains = (Map)Objects.requireNonNull(ImmutableMap.copyOf(domains));
            this.domainQuery = Objects.requireNonNull(domainQuery);
        }

        public Map<ColumnHandle, Domain> getDomains() {
            return this.domains;
        }

        public String getDomainQuery() {
            return this.domainQuery;
        }
    }
}

