/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.cassandra.CassandraClientConfig;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

public final class CassandraSessionProperties {
    private static final String SPLITS_PER_NODE = "splits_per_node";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public CassandraSessionProperties(CassandraClientConfig cassandraClientConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.longProperty((String)SPLITS_PER_NODE, (String)"Number of splits per node. By default, the values from the system.size_estimates table are used. Only override when connecting to Cassandra versions < 2.1.5.", (Long)cassandraClientConfig.getSplitsPerNode().orElse(null), (boolean)false));
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static Optional<Long> getSplitsPerNode(ConnectorSession session) {
        return Optional.ofNullable(session.getProperty(SPLITS_PER_NODE, Long.class));
    }
}

