/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ClusterNameMismatchException;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.UnsupportedProtocolVersionException;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractReconnectionHandler
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractReconnectionHandler.class);
    private final ScheduledExecutorService executor;
    private final ReconnectionPolicy.ReconnectionSchedule schedule;
    private final AtomicReference<ScheduledFuture<?>> currentAttempt;
    private volatile boolean readyForNext;
    private volatile ScheduledFuture<?> localFuture;

    public AbstractReconnectionHandler(ScheduledExecutorService executor, ReconnectionPolicy.ReconnectionSchedule schedule, AtomicReference<ScheduledFuture<?>> currentAttempt) {
        this.executor = executor;
        this.schedule = schedule;
        this.currentAttempt = currentAttempt;
    }

    protected abstract Connection tryReconnect() throws ConnectionException, InterruptedException, UnsupportedProtocolVersionException, ClusterNameMismatchException;

    protected abstract void onReconnection(Connection var1);

    protected boolean onConnectionException(ConnectionException e, long nextDelayMs) {
        return true;
    }

    protected boolean onUnknownException(Exception e, long nextDelayMs) {
        return true;
    }

    protected boolean onAuthenticationException(AuthenticationException e, long nextDelayMs) {
        return false;
    }

    protected boolean onUnsupportedProtocolVersionException(UnsupportedProtocolVersionException e, long nextDelayMs) {
        return false;
    }

    protected boolean onClusterNameMismatchException(ClusterNameMismatchException e, long nextDelayMs) {
        return false;
    }

    public void start() {
        long firstDelay = this.schedule.nextDelayMs();
        logger.debug("First reconnection scheduled in {}ms", (Object)firstDelay);
        try {
            ScheduledFuture<?> previous;
            this.localFuture = this.executor.schedule(this, firstDelay, TimeUnit.MILLISECONDS);
            while (!this.currentAttempt.compareAndSet(previous = this.currentAttempt.get(), this.localFuture)) {
            }
            if (previous != null) {
                previous.cancel(false);
            }
            this.readyForNext = true;
        }
        catch (RejectedExecutionException e) {
            logger.debug("Aborting reconnection handling since the cluster is shutting down");
        }
    }

    @Override
    public void run() {
        if (this.localFuture.isCancelled()) {
            return;
        }
        while (!this.readyForNext) {
            Uninterruptibles.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        try {
            this.onReconnection(this.tryReconnect());
            this.currentAttempt.compareAndSet(this.localFuture, null);
        }
        catch (ConnectionException e) {
            long nextDelay = this.schedule.nextDelayMs();
            if (this.onConnectionException(e, nextDelay)) {
                this.reschedule(nextDelay);
            } else {
                this.currentAttempt.compareAndSet(this.localFuture, null);
            }
        }
        catch (AuthenticationException e) {
            logger.error(e.getMessage());
            long nextDelay = this.schedule.nextDelayMs();
            if (this.onAuthenticationException(e, nextDelay)) {
                this.reschedule(nextDelay);
            } else {
                logger.error("Retry against {} have been suspended. It won't be retried unless the node is restarted.", (Object)e.getHost());
                this.currentAttempt.compareAndSet(this.localFuture, null);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.reschedule(this.schedule.nextDelayMs());
        }
        catch (UnsupportedProtocolVersionException e) {
            logger.error(e.getMessage());
            long nextDelay = this.schedule.nextDelayMs();
            if (this.onUnsupportedProtocolVersionException(e, nextDelay)) {
                this.reschedule(nextDelay);
            } else {
                logger.error("Retry against {} have been suspended. It won't be retried unless the node is restarted.", (Object)e.address);
                this.currentAttempt.compareAndSet(this.localFuture, null);
            }
        }
        catch (ClusterNameMismatchException e) {
            logger.error(e.getMessage());
            long nextDelay = this.schedule.nextDelayMs();
            if (this.onClusterNameMismatchException(e, nextDelay)) {
                this.reschedule(nextDelay);
            } else {
                logger.error("Retry against {} have been suspended. It won't be retried unless the node is restarted.", (Object)e.address);
                this.currentAttempt.compareAndSet(this.localFuture, null);
            }
        }
        catch (Exception e) {
            long nextDelay = this.schedule.nextDelayMs();
            if (this.onUnknownException(e, nextDelay)) {
                this.reschedule(nextDelay);
            }
            this.currentAttempt.compareAndSet(this.localFuture, null);
        }
    }

    private void reschedule(long nextDelay) {
        this.readyForNext = false;
        ScheduledFuture<?> newFuture = this.executor.schedule(this, nextDelay, TimeUnit.MILLISECONDS);
        assert (this.localFuture != null);
        if (!this.currentAttempt.compareAndSet(this.localFuture, newFuture)) {
            newFuture.cancel(false);
        }
        this.localFuture = newFuture;
        this.readyForNext = true;
    }
}

