/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.AssignementTestable;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.exceptions.InvalidRequestException;

public interface Term {
    public void collectMarkerSpecification(VariableSpecifications var1);

    public Terminal bind(QueryOptions var1) throws InvalidRequestException;

    public ByteBuffer bindAndGet(QueryOptions var1) throws InvalidRequestException;

    public boolean containsBindMarker();

    public static abstract class NonTerminal
    implements Term {
        @Override
        public ByteBuffer bindAndGet(QueryOptions options) throws InvalidRequestException {
            Terminal t = this.bind(options);
            return t == null ? null : t.get(options);
        }
    }

    public static abstract class MultiItemTerminal
    extends Terminal {
        public abstract List<ByteBuffer> getElements();
    }

    public static abstract class Terminal
    implements Term {
        @Override
        public void collectMarkerSpecification(VariableSpecifications boundNames) {
        }

        @Override
        public Terminal bind(QueryOptions options) {
            return this;
        }

        @Override
        public boolean containsBindMarker() {
            return false;
        }

        public abstract ByteBuffer get(QueryOptions var1);

        @Override
        public ByteBuffer bindAndGet(QueryOptions options) throws InvalidRequestException {
            return this.get(options);
        }
    }

    public static interface MultiColumnRaw
    extends Raw {
        public Term prepare(String var1, List<? extends ColumnSpecification> var2) throws InvalidRequestException;
    }

    public static interface Raw
    extends AssignementTestable {
        public Term prepare(String var1, ColumnSpecification var2) throws InvalidRequestException;
    }
}

