/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.composites;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.db.composites.AbstractCType;
import org.apache.cassandra.db.composites.CBuilder;
import org.apache.cassandra.db.composites.CType;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.Composites;
import org.apache.cassandra.db.composites.SimpleComposite;
import org.apache.cassandra.db.composites.SimpleDenseCellName;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.utils.ByteBufferUtil;

public class SimpleCType
extends AbstractCType {
    protected final AbstractType<?> type;

    public SimpleCType(AbstractType<?> type) {
        super(type.isByteOrderComparable());
        this.type = type;
    }

    @Override
    public boolean isCompound() {
        return false;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public int compare(Composite c1, Composite c2) {
        if (this.isByteOrderComparable) {
            ByteBuffer b1 = c1.toByteBuffer();
            ByteBuffer b2 = c2.toByteBuffer();
            if (!b1.hasRemaining() || !b2.hasRemaining()) {
                return b1.hasRemaining() ? 1 : (b2.hasRemaining() ? -1 : 0);
            }
            return ByteBufferUtil.compareUnsigned(b1, b2);
        }
        boolean c1isEmpty = c1.isEmpty();
        boolean c2isEmpty = c2.isEmpty();
        if (c1isEmpty || c2isEmpty) {
            return !c1isEmpty ? 1 : (!c2isEmpty ? -1 : 0);
        }
        return this.type.compare(c1.get(0), c2.get(0));
    }

    @Override
    public AbstractType<?> subtype(int i) {
        if (i != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.type;
    }

    @Override
    public Composite fromByteBuffer(ByteBuffer bytes) {
        return !bytes.hasRemaining() ? Composites.EMPTY : new SimpleComposite(bytes);
    }

    @Override
    public CBuilder builder() {
        return new SimpleCBuilder(this);
    }

    @Override
    public CType setSubtype(int position, AbstractType<?> newType) {
        if (position != 0) {
            throw new IndexOutOfBoundsException();
        }
        return new SimpleCType(newType);
    }

    @Override
    public AbstractType<?> asAbstractType() {
        return this.type;
    }

    public static class SimpleCBuilder
    implements CBuilder {
        private final CType type;
        private ByteBuffer value;

        public SimpleCBuilder(CType type) {
            this.type = type;
        }

        @Override
        public int remainingCount() {
            return this.value == null ? 1 : 0;
        }

        @Override
        public CBuilder add(ByteBuffer value) {
            if (this.value != null) {
                throw new IllegalStateException();
            }
            this.value = value;
            return this;
        }

        @Override
        public CBuilder add(Object value) {
            return this.add(this.type.subtype(0).decompose(value));
        }

        @Override
        public Composite build() {
            if (this.value == null || !this.value.hasRemaining()) {
                return Composites.EMPTY;
            }
            if (this.type instanceof CellNameType && ((CellNameType)this.type).isDense()) {
                return new SimpleDenseCellName(this.value);
            }
            return new SimpleComposite(this.value);
        }

        @Override
        public Composite buildWith(ByteBuffer value) {
            if (this.value != null) {
                throw new IllegalStateException();
            }
            if (value == null || !value.hasRemaining()) {
                return Composites.EMPTY;
            }
            if (this.type instanceof CellNameType && ((CellNameType)this.type).isDense()) {
                return new SimpleDenseCellName(value);
            }
            return new SimpleComposite(value);
        }

        @Override
        public Composite buildWith(List<ByteBuffer> values) {
            if (values.size() > 1) {
                throw new IllegalStateException();
            }
            if (values.isEmpty()) {
                return Composites.EMPTY;
            }
            return this.buildWith(values.get(0));
        }
    }
}

