/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.filter.ExtendedFilter;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;

public abstract class SecondaryIndexSearcher {
    protected final SecondaryIndexManager indexManager;
    protected final Set<ByteBuffer> columns;
    protected final ColumnFamilyStore baseCfs;

    public SecondaryIndexSearcher(SecondaryIndexManager indexManager, Set<ByteBuffer> columns) {
        this.indexManager = indexManager;
        this.columns = columns;
        this.baseCfs = indexManager.baseCfs;
    }

    public SecondaryIndex highestSelectivityIndex(List<IndexExpression> clause) {
        IndexExpression expr = this.highestSelectivityPredicate(clause);
        return expr == null ? null : this.indexManager.getIndexForColumn(expr.column);
    }

    public abstract List<Row> search(ExtendedFilter var1);

    public boolean canHandleIndexClause(List<IndexExpression> clause) {
        for (IndexExpression expression : clause) {
            SecondaryIndex index;
            if (!this.columns.contains(expression.column) || !expression.operator.allowsIndexQuery() || (index = this.indexManager.getIndexForColumn(expression.column)) == null || index.getIndexCfs() == null) continue;
            return true;
        }
        return false;
    }

    protected IndexExpression highestSelectivityPredicate(List<IndexExpression> clause) {
        IndexExpression best = null;
        int bestMeanCount = Integer.MAX_VALUE;
        HashMap<SecondaryIndex, Integer> candidates = new HashMap<SecondaryIndex, Integer>();
        for (IndexExpression expression : clause) {
            SecondaryIndex index;
            if (!this.columns.contains(expression.column) || (index = this.indexManager.getIndexForColumn(expression.column)) == null || index.getIndexCfs() == null || !expression.operator.allowsIndexQuery()) continue;
            int columns = index.getIndexCfs().getMeanColumns();
            candidates.put(index, columns);
            if (columns >= bestMeanCount) continue;
            best = expression;
            bestMeanCount = columns;
        }
        if (best == null) {
            Tracing.trace("No applicable indexes found");
        } else {
            Tracing.trace("Candidate index mean cardinalities are {}. Scanning with {}.", FBUtilities.toString(candidates), this.indexManager.getIndexForColumn(best.column).getIndexName());
        }
        return best;
    }
}

