/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import org.apache.cassandra.concurrent.SEPExecutor;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.metrics.ThreadPoolMetricNameFactory;

public class SEPMetrics {
    public final Gauge<Integer> activeTasks;
    public final Gauge<Integer> totalBlocked;
    public final Gauge<Long> currentBlocked;
    public final Gauge<Long> completedTasks;
    public final Gauge<Long> pendingTasks;
    private MetricNameFactory factory;

    public SEPMetrics(final SEPExecutor executor, String path, String poolName) {
        this.factory = new ThreadPoolMetricNameFactory("ThreadPools", path, poolName);
        this.activeTasks = Metrics.newGauge((MetricName)this.factory.createMetricName("ActiveTasks"), (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return executor.getActiveCount();
            }
        });
        this.pendingTasks = Metrics.newGauge((MetricName)this.factory.createMetricName("PendingTasks"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return executor.getPendingTasks();
            }
        });
        this.totalBlocked = Metrics.newGauge((MetricName)this.factory.createMetricName("TotalBlockedTasks"), (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return executor.getTotalBlockedTasks();
            }
        });
        this.currentBlocked = Metrics.newGauge((MetricName)this.factory.createMetricName("CurrentlyBlockedTasks"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return executor.getCurrentlyBlockedTasks();
            }
        });
        this.completedTasks = Metrics.newGauge((MetricName)this.factory.createMetricName("CompletedTasks"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return executor.getCompletedTasks();
            }
        });
    }

    public void release() {
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("ActiveTasks"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("PendingTasks"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("CompletedTasks"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("TotalBlockedTasks"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("CurrentlyBlockedTasks"));
    }
}

