/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.datastax.driver.core.ConsistencyLevel;
import com.facebook.presto.cassandra.RetryPolicyType;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import io.airlift.units.MaxDuration;
import io.airlift.units.MinDuration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class CassandraClientConfig {
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private Duration schemaCacheTtl = new Duration(1.0, TimeUnit.HOURS);
    private Duration schemaRefreshInterval = new Duration(2.0, TimeUnit.MINUTES);
    private int maxSchemaRefreshThreads = 10;
    private int limitForPartitionKeySelect = 200;
    private int fetchSizeForPartitionKeySelect = 20000;
    private ConsistencyLevel consistencyLevel = ConsistencyLevel.ONE;
    private int fetchSize = 5000;
    private List<String> contactPoints = ImmutableList.of();
    private int nativeProtocolPort = 9042;
    private int partitionSizeForBatchSelect = 100;
    private int splitSize = 1024;
    private String partitioner = "Murmur3Partitioner";
    private int thriftPort = 9160;
    private String thriftConnectionFactoryClassName = "org.apache.cassandra.thrift.TFramedTransportFactory";
    private Map<String, String> transportFactoryOptions = new HashMap<String, String>();
    private boolean allowDropTable;
    private String username;
    private String password;
    private Duration clientReadTimeout = new Duration(12000.0, TimeUnit.MILLISECONDS);
    private Duration clientConnectTimeout = new Duration(5000.0, TimeUnit.MILLISECONDS);
    private Integer clientSoLinger;
    private RetryPolicyType retryPolicy = RetryPolicyType.DEFAULT;

    @Min(value=0L)
    public int getLimitForPartitionKeySelect() {
        return this.limitForPartitionKeySelect;
    }

    @Config(value="cassandra.limit-for-partition-key-select")
    public CassandraClientConfig setLimitForPartitionKeySelect(int limitForPartitionKeySelect) {
        this.limitForPartitionKeySelect = limitForPartitionKeySelect;
        return this;
    }

    @Min(value=1L)
    public int getMaxSchemaRefreshThreads() {
        return this.maxSchemaRefreshThreads;
    }

    @Config(value="cassandra.max-schema-refresh-threads")
    public CassandraClientConfig setMaxSchemaRefreshThreads(int maxSchemaRefreshThreads) {
        this.maxSchemaRefreshThreads = maxSchemaRefreshThreads;
        return this;
    }

    @NotNull
    public Duration getSchemaCacheTtl() {
        return this.schemaCacheTtl;
    }

    @Config(value="cassandra.schema-cache-ttl")
    public CassandraClientConfig setSchemaCacheTtl(Duration schemaCacheTtl) {
        this.schemaCacheTtl = schemaCacheTtl;
        return this;
    }

    @NotNull
    public Duration getSchemaRefreshInterval() {
        return this.schemaRefreshInterval;
    }

    @Config(value="cassandra.schema-refresh-interval")
    public CassandraClientConfig setSchemaRefreshInterval(Duration schemaRefreshInterval) {
        this.schemaRefreshInterval = schemaRefreshInterval;
        return this;
    }

    @NotNull
    @Size(min=1)
    public List<String> getContactPoints() {
        return this.contactPoints;
    }

    @Config(value="cassandra.contact-points")
    public CassandraClientConfig setContactPoints(String commaSeparatedList) {
        this.contactPoints = SPLITTER.splitToList((CharSequence)commaSeparatedList);
        return this;
    }

    public CassandraClientConfig setContactPoints(String ... contactPoints) {
        this.contactPoints = Arrays.asList(contactPoints);
        return this;
    }

    @Min(value=1L)
    public int getNativeProtocolPort() {
        return this.nativeProtocolPort;
    }

    @Config(value="cassandra.native-protocol-port")
    public CassandraClientConfig setNativeProtocolPort(int nativeProtocolPort) {
        this.nativeProtocolPort = nativeProtocolPort;
        return this;
    }

    @NotNull
    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    @Config(value="cassandra.consistency-level")
    public CassandraClientConfig setConsistencyLevel(ConsistencyLevel level) {
        this.consistencyLevel = level;
        return this;
    }

    @Min(value=1L)
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Config(value="cassandra.fetch-size")
    public CassandraClientConfig setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    @Min(value=1L)
    public int getFetchSizeForPartitionKeySelect() {
        return this.fetchSizeForPartitionKeySelect;
    }

    @Config(value="cassandra.fetch-size-for-partition-key-select")
    public CassandraClientConfig setFetchSizeForPartitionKeySelect(int fetchSizeForPartitionKeySelect) {
        this.fetchSizeForPartitionKeySelect = fetchSizeForPartitionKeySelect;
        return this;
    }

    @Min(value=1L)
    public int getPartitionSizeForBatchSelect() {
        return this.partitionSizeForBatchSelect;
    }

    @Config(value="cassandra.partition-size-for-batch-select")
    public CassandraClientConfig setPartitionSizeForBatchSelect(int partitionSizeForBatchSelect) {
        this.partitionSizeForBatchSelect = partitionSizeForBatchSelect;
        return this;
    }

    public int getThriftPort() {
        return this.thriftPort;
    }

    @Config(value="cassandra.thrift-port")
    public CassandraClientConfig setThriftPort(int thriftPort) {
        this.thriftPort = thriftPort;
        return this;
    }

    @Min(value=1L)
    public int getSplitSize() {
        return this.splitSize;
    }

    @Config(value="cassandra.split-size")
    public CassandraClientConfig setSplitSize(int splitSize) {
        this.splitSize = splitSize;
        return this;
    }

    public String getPartitioner() {
        return this.partitioner;
    }

    @Config(value="cassandra.partitioner")
    public CassandraClientConfig setPartitioner(String partitioner) {
        this.partitioner = partitioner;
        return this;
    }

    public String getThriftConnectionFactoryClassName() {
        return this.thriftConnectionFactoryClassName;
    }

    @Config(value="cassandra.thrift-connection-factory-class")
    public CassandraClientConfig setThriftConnectionFactoryClassName(String thriftConnectionFactoryClassName) {
        this.thriftConnectionFactoryClassName = thriftConnectionFactoryClassName;
        return this;
    }

    public Map<String, String> getTransportFactoryOptions() {
        return this.transportFactoryOptions;
    }

    @Config(value="cassandra.transport-factory-options")
    public CassandraClientConfig setTransportFactoryOptions(String transportFactoryOptions) {
        Preconditions.checkNotNull((Object)transportFactoryOptions, (Object)"transportFactoryOptions is null");
        this.transportFactoryOptions = Splitter.on((char)',').omitEmptyStrings().trimResults().withKeyValueSeparator("=").split((CharSequence)transportFactoryOptions);
        return this;
    }

    public boolean getAllowDropTable() {
        return this.allowDropTable;
    }

    @Config(value="cassandra.allow-drop-table")
    @ConfigDescription(value="Allow hive connector to drop table")
    public CassandraClientConfig setAllowDropTable(boolean allowDropTable) {
        this.allowDropTable = allowDropTable;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    @Config(value="cassandra.username")
    public CassandraClientConfig setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    @Config(value="cassandra.password")
    public CassandraClientConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    @MinDuration(value="1ms")
    @MaxDuration(value="1h")
    public Duration getClientReadTimeout() {
        return this.clientReadTimeout;
    }

    @Config(value="cassandra.client.read-timeout")
    public CassandraClientConfig setClientReadTimeout(Duration clientReadTimeout) {
        this.clientReadTimeout = clientReadTimeout;
        return this;
    }

    @MinDuration(value="1ms")
    @MaxDuration(value="1h")
    public Duration getClientConnectTimeout() {
        return this.clientConnectTimeout;
    }

    @Config(value="cassandra.client.connect-timeout")
    public CassandraClientConfig setClientConnectTimeout(Duration clientConnectTimeout) {
        this.clientConnectTimeout = clientConnectTimeout;
        return this;
    }

    @Min(value=0L)
    public Integer getClientSoLinger() {
        return this.clientSoLinger;
    }

    @Config(value="cassandra.client.so-linger")
    public CassandraClientConfig setClientSoLinger(Integer clientSoLinger) {
        this.clientSoLinger = clientSoLinger;
        return this;
    }

    @NotNull
    public RetryPolicyType getRetryPolicy() {
        return this.retryPolicy;
    }

    @Config(value="cassandra.retry-policy")
    public CassandraClientConfig setRetryPolicy(RetryPolicyType retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }
}

