/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.cassandra.CassandraOutputTableHandle;
import com.facebook.presto.cassandra.CassandraRecordSink;
import com.facebook.presto.cassandra.CassandraSession;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorRecordSinkProvider;
import com.facebook.presto.spi.RecordSink;
import com.google.common.base.Preconditions;
import javax.inject.Inject;

public class CassandraConnectorRecordSinkProvider
implements ConnectorRecordSinkProvider {
    private final CassandraSession cassandraSession;

    @Inject
    public CassandraConnectorRecordSinkProvider(CassandraSession cassandraSession) {
        this.cassandraSession = (CassandraSession)Preconditions.checkNotNull((Object)cassandraSession, (Object)"cassandraSession is null");
    }

    public RecordSink getRecordSink(ConnectorOutputTableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof CassandraOutputTableHandle), (Object)"tableHandle is not an instance of CassandraOutputTableHandle");
        CassandraOutputTableHandle handle = (CassandraOutputTableHandle)tableHandle;
        return new CassandraRecordSink(handle, this.cassandraSession);
    }

    public RecordSink getRecordSink(ConnectorInsertTableHandle tableHandle) {
        throw new UnsupportedOperationException();
    }
}

