/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.cassandra.CachingCassandraSchemaProvider;
import com.facebook.presto.cassandra.CassandraClientConfig;
import com.facebook.presto.cassandra.CassandraColumnHandle;
import com.facebook.presto.cassandra.CassandraConnectorId;
import com.facebook.presto.cassandra.CassandraOutputTableHandle;
import com.facebook.presto.cassandra.CassandraSession;
import com.facebook.presto.cassandra.CassandraTable;
import com.facebook.presto.cassandra.CassandraTableHandle;
import com.facebook.presto.cassandra.CassandraType;
import com.facebook.presto.cassandra.ExtraColumnMetadata;
import com.facebook.presto.cassandra.util.CassandraCqlUtils;
import com.facebook.presto.cassandra.util.Types;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.NotFoundException;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import io.airlift.json.JsonCodec;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CassandraMetadata
implements ConnectorMetadata {
    private final String connectorId;
    private final CachingCassandraSchemaProvider schemaProvider;
    private final CassandraSession cassandraSession;
    private final boolean allowDropTable;
    private final JsonCodec<List<ExtraColumnMetadata>> extraColumnMetadataCodec;

    @Inject
    public CassandraMetadata(CassandraConnectorId connectorId, CachingCassandraSchemaProvider schemaProvider, CassandraSession cassandraSession, JsonCodec<List<ExtraColumnMetadata>> extraColumnMetadataCodec, CassandraClientConfig config) {
        this.connectorId = ((CassandraConnectorId)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null")).toString();
        this.schemaProvider = (CachingCassandraSchemaProvider)Preconditions.checkNotNull((Object)schemaProvider, (Object)"schemaProvider is null");
        this.cassandraSession = (CassandraSession)Preconditions.checkNotNull((Object)cassandraSession, (Object)"cassandraSession is null");
        this.allowDropTable = ((CassandraClientConfig)Preconditions.checkNotNull((Object)config, (Object)"config is null")).getAllowDropTable();
        this.extraColumnMetadataCodec = (JsonCodec)Preconditions.checkNotNull(extraColumnMetadataCodec, (Object)"extraColumnMetadataCodec is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.schemaProvider.getAllSchemas();
    }

    public CassandraTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
        try {
            CassandraTableHandle tableHandle = this.schemaProvider.getTableHandle(tableName);
            this.schemaProvider.getTable(tableHandle);
            return tableHandle;
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    private static SchemaTableName getTableName(ConnectorTableHandle tableHandle) {
        return Types.checkType(tableHandle, CassandraTableHandle.class, "tableHandle").getSchemaTableName();
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorTableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        SchemaTableName tableName = CassandraMetadata.getTableName(tableHandle);
        return this.getTableMetadata(tableName);
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName tableName) {
        CassandraTableHandle tableHandle = this.schemaProvider.getTableHandle(tableName);
        ImmutableList columns = ImmutableList.copyOf((Iterable)Iterables.transform(this.getColumnHandles(tableHandle).values(), CassandraColumnHandle.columnMetadataGetter()));
        return new ConnectorTableMetadata(tableName, (List)columns);
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String schemaName : this.listSchemas(session, schemaNameOrNull)) {
            try {
                for (String tableName : this.schemaProvider.getAllTables(schemaName)) {
                    tableNames.add((Object)new SchemaTableName(schemaName, tableName.toLowerCase(Locale.ENGLISH)));
                }
            }
            catch (SchemaNotFoundException e) {
            }
        }
        return tableNames.build();
    }

    private List<String> listSchemas(ConnectorSession session, String schemaNameOrNull) {
        if (schemaNameOrNull == null) {
            return this.listSchemaNames(session);
        }
        return ImmutableList.of((Object)schemaNameOrNull);
    }

    public ConnectorColumnHandle getSampleWeightColumnHandle(ConnectorTableHandle tableHandle) {
        return this.getColumnHandles(tableHandle, true).get("presto_sample_weight");
    }

    public Map<String, ConnectorColumnHandle> getColumnHandles(ConnectorTableHandle tableHandle) {
        return this.getColumnHandles(tableHandle, false);
    }

    private Map<String, ConnectorColumnHandle> getColumnHandles(ConnectorTableHandle tableHandle, boolean includeSampleWeight) {
        CassandraTable table = this.schemaProvider.getTable((CassandraTableHandle)tableHandle);
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (CassandraColumnHandle columnHandle : table.getColumns()) {
            if (!includeSampleWeight && columnHandle.getName().equals("presto_sample_weight")) continue;
            columnHandles.put((Object)CassandraCqlUtils.cqlNameToSqlName(columnHandle.getName()).toLowerCase(Locale.ENGLISH), (Object)columnHandle);
        }
        return columnHandles.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            try {
                columns.put((Object)tableName, (Object)this.getTableMetadata(tableName).getColumns());
            }
            catch (NotFoundException e) {}
        }
        return columns.build();
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getSchemaName() == null) {
            return this.listTables(session, prefix.getSchemaName());
        }
        return ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName()));
    }

    public ColumnMetadata getColumnMetadata(ConnectorTableHandle tableHandle, ConnectorColumnHandle columnHandle) {
        Types.checkType(tableHandle, CassandraTableHandle.class, "tableHandle");
        return Types.checkType(columnHandle, CassandraColumnHandle.class, "columnHandle").getColumnMetadata();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).toString();
    }

    public boolean canCreateSampledTables(ConnectorSession session) {
        return true;
    }

    public ConnectorTableHandle createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        throw new UnsupportedOperationException();
    }

    public void dropTable(ConnectorTableHandle tableHandle) {
        Preconditions.checkArgument((boolean)(tableHandle instanceof CassandraTableHandle), (Object)"tableHandle is not an instance of CassandraTableHandle");
        if (!this.allowDropTable) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, "DROP TABLE is disabled in this Hive catalog");
        }
        CassandraTableHandle cassandraTableHandle = (CassandraTableHandle)tableHandle;
        String schemaName = cassandraTableHandle.getSchemaName();
        String tableName = cassandraTableHandle.getTableName();
        StringBuilder queryBuilder = new StringBuilder(String.format("DROP TABLE \"%s\".\"%s\"", schemaName, tableName));
        this.cassandraSession.executeQuery(schemaName, queryBuilder.toString());
        this.schemaProvider.flushTable(cassandraTableHandle.getSchemaTableName());
    }

    public void renameTable(ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        throw new UnsupportedOperationException();
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableMetadata.getOwner()) ? 1 : 0) != 0, (Object)"Table owner is null or empty");
        ImmutableList.Builder columnNames = ImmutableList.builder();
        ImmutableList.Builder columnTypes = ImmutableList.builder();
        ImmutableList.Builder columnExtra = ImmutableList.builder();
        columnExtra.add((Object)new ExtraColumnMetadata("id", true));
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            columnNames.add((Object)column.getName());
            columnTypes.add((Object)column.getType());
            columnExtra.add((Object)new ExtraColumnMetadata(column.getName(), column.isHidden()));
        }
        SchemaTableName table = tableMetadata.getTable();
        String schemaName = this.schemaProvider.getCaseSensitiveSchemaName(table.getSchemaName());
        String tableName = table.getTableName();
        ImmutableList columns = columnNames.build();
        ImmutableList types = columnTypes.build();
        StringBuilder queryBuilder = new StringBuilder(String.format("CREATE TABLE \"%s\".\"%s\"(id uuid primary key", schemaName, tableName));
        if (tableMetadata.isSampled()) {
            queryBuilder.append(", ").append("presto_sample_weight").append(" ").append(CassandraType.BIGINT.name().toLowerCase(Locale.ENGLISH));
            columnExtra.add((Object)new ExtraColumnMetadata("presto_sample_weight", true));
        }
        for (int i = 0; i < columns.size(); ++i) {
            String name = (String)columns.get(i);
            Type type = (Type)types.get(i);
            queryBuilder.append(", ").append(name).append(" ").append(CassandraType.toCassandraType(type).name().toLowerCase(Locale.ENGLISH));
        }
        queryBuilder.append(") ");
        String columnMetadata = this.extraColumnMetadataCodec.toJson((Object)columnExtra.build());
        queryBuilder.append("WITH comment='").append("Presto Metadata:").append(" ").append(columnMetadata).append("'");
        this.cassandraSession.executeQuery(schemaName, queryBuilder.toString());
        return new CassandraOutputTableHandle(this.connectorId, schemaName, tableName, (List<String>)columnNames.build(), (List<Type>)columnTypes.build(), tableMetadata.isSampled(), tableMetadata.getOwner());
    }

    public void commitCreateTable(ConnectorOutputTableHandle tableHandle, Collection<String> fragments) {
        CassandraOutputTableHandle outputTableHandle = Types.checkType(tableHandle, CassandraOutputTableHandle.class, "tableHandle");
        this.schemaProvider.flushTable(new SchemaTableName(outputTableHandle.getSchemaName(), outputTableHandle.getTableName()));
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        throw new UnsupportedOperationException();
    }

    public void commitInsert(ConnectorInsertTableHandle insertHandle, Collection<String> fragments) {
        throw new UnsupportedOperationException();
    }

    public void createView(ConnectorSession session, SchemaTableName viewName, String viewData, boolean replace) {
        throw new UnsupportedOperationException();
    }

    public void dropView(ConnectorSession session, SchemaTableName viewName) {
        throw new UnsupportedOperationException();
    }

    public List<SchemaTableName> listViews(ConnectorSession session, String schemaNameOrNull) {
        return Collections.emptyList();
    }

    public Map<SchemaTableName, String> getViews(ConnectorSession session, SchemaTablePrefix prefix) {
        return Collections.emptyMap();
    }
}

