/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.type.Type;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class CassandraOutputTableHandle
implements ConnectorOutputTableHandle {
    private final String connectorId;
    private final String schemaName;
    private final String tableName;
    private final List<String> columnNames;
    private final List<Type> columnTypes;
    private final boolean sampled;
    private final String tableOwner;

    @JsonCreator
    public CassandraOutputTableHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="columnNames") List<String> columnNames, @JsonProperty(value="columnTypes") List<Type> columnTypes, @JsonProperty(value="sampled") boolean sampled, @JsonProperty(value="tableOwner") String tableOwner) {
        this.sampled = sampled;
        this.connectorId = (String)Preconditions.checkNotNull((Object)connectorId, (Object)"clientId is null");
        this.schemaName = (String)Preconditions.checkNotNull((Object)schemaName, (Object)"schemaName is null");
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
        this.tableOwner = (String)Preconditions.checkNotNull((Object)tableOwner, (Object)"tableOwner is null");
        Preconditions.checkNotNull(columnNames, (Object)"columnNames is null");
        Preconditions.checkNotNull(columnTypes, (Object)"columnTypes is null");
        Preconditions.checkArgument((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"columnNames and columnTypes sizes don't match");
        this.columnNames = ImmutableList.copyOf(columnNames);
        this.columnTypes = ImmutableList.copyOf(columnTypes);
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @JsonProperty
    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    @JsonProperty
    public boolean isSampled() {
        return this.sampled;
    }

    @JsonProperty
    public String getTableOwner() {
        return this.tableOwner;
    }

    public String toString() {
        return "cassandra:" + this.schemaName + "." + this.tableName;
    }
}

