/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorPartition;
import com.facebook.presto.spi.TupleDomain;
import java.nio.ByteBuffer;

public class CassandraPartition
implements ConnectorPartition {
    static final String UNPARTITIONED_ID = "<UNPARTITIONED>";
    public static final CassandraPartition UNPARTITIONED = new CassandraPartition();
    private final String partitionId;
    private final byte[] key;
    private final TupleDomain<ConnectorColumnHandle> tupleDomain;
    private final boolean indexedColumnPredicatePushdown;

    private CassandraPartition() {
        this.partitionId = UNPARTITIONED_ID;
        this.tupleDomain = TupleDomain.all();
        this.key = null;
        this.indexedColumnPredicatePushdown = false;
    }

    public CassandraPartition(byte[] key, String partitionId, TupleDomain<ConnectorColumnHandle> tupleDomain, boolean indexedColumnPredicatePushdown) {
        this.key = key;
        this.partitionId = partitionId;
        this.tupleDomain = tupleDomain;
        this.indexedColumnPredicatePushdown = indexedColumnPredicatePushdown;
    }

    public boolean isUnpartitioned() {
        return this.partitionId.equals(UNPARTITIONED_ID);
    }

    public boolean isIndexedColumnPredicatePushdown() {
        return this.indexedColumnPredicatePushdown;
    }

    public TupleDomain<ConnectorColumnHandle> getTupleDomain() {
        return this.tupleDomain;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public String toString() {
        return this.partitionId;
    }

    public ByteBuffer getKeyAsByteBuffer() {
        return ByteBuffer.wrap(this.key);
    }

    public byte[] getKey() {
        return this.key;
    }
}

