/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.facebook.presto.cassandra.CassandraSession;
import com.facebook.presto.cassandra.CassandraType;
import com.facebook.presto.cassandra.FullCassandraType;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.type.Type;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.List;

public class CassandraRecordCursor
implements RecordCursor {
    private final List<FullCassandraType> fullCassandraTypes;
    private final ResultSet rs;
    private Row currentRow;
    private long atLeastCount;
    private long count;

    public CassandraRecordCursor(CassandraSession cassandraSession, String schema, List<FullCassandraType> fullCassandraTypes, String cql) {
        this.fullCassandraTypes = fullCassandraTypes;
        this.rs = cassandraSession.executeQuery(schema, cql);
        this.currentRow = null;
        this.atLeastCount = this.rs.getAvailableWithoutFetching();
    }

    public boolean advanceNextPosition() {
        if (!this.rs.isExhausted()) {
            this.currentRow = this.rs.one();
            ++this.count;
            this.atLeastCount = this.count + (long)this.rs.getAvailableWithoutFetching();
            return true;
        }
        return false;
    }

    public void close() {
    }

    public boolean getBoolean(int i) {
        return this.currentRow.getBool(i);
    }

    public long getCompletedBytes() {
        return this.count;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public double getDouble(int i) {
        switch (this.getCassandraType(i)) {
            case DOUBLE: {
                return this.currentRow.getDouble(i);
            }
            case FLOAT: {
                return this.currentRow.getFloat(i);
            }
            case DECIMAL: {
                return this.currentRow.getDecimal(i).doubleValue();
            }
        }
        throw new IllegalStateException("Cannot retrieve double for " + this.getCassandraType(i));
    }

    public long getLong(int i) {
        switch (this.getCassandraType(i)) {
            case INT: {
                return this.currentRow.getInt(i);
            }
            case BIGINT: 
            case COUNTER: {
                return this.currentRow.getLong(i);
            }
            case TIMESTAMP: {
                return this.currentRow.getDate(i).getTime();
            }
        }
        throw new IllegalStateException("Cannot retrieve long for " + this.getCassandraType(i));
    }

    private CassandraType getCassandraType(int i) {
        return this.fullCassandraTypes.get(i).getCassandraType();
    }

    public Slice getSlice(int i) {
        return Slices.utf8Slice((String)CassandraType.getColumnValue(this.currentRow, i, this.fullCassandraTypes.get(i)).toString());
    }

    public long getTotalBytes() {
        return this.atLeastCount;
    }

    public Type getType(int i) {
        return this.getCassandraType(i).getNativeType();
    }

    public boolean isNull(int i) {
        return this.currentRow.isNull(i);
    }
}

