/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.cassandra.CassandraColumnHandle;
import com.facebook.presto.cassandra.CassandraRecordCursor;
import com.facebook.presto.cassandra.CassandraSession;
import com.facebook.presto.cassandra.FullCassandraType;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;

public class CassandraRecordSet
implements RecordSet {
    private final CassandraSession cassandraSession;
    private final String schema;
    private final String cql;
    private final List<FullCassandraType> cassandraTypes;
    private final List<Type> columnTypes;

    public CassandraRecordSet(CassandraSession cassandraSession, String schema, String cql, List<CassandraColumnHandle> cassandraColumns) {
        this.cassandraSession = (CassandraSession)Preconditions.checkNotNull((Object)cassandraSession, (Object)"cassandraSession is null");
        this.schema = (String)Preconditions.checkNotNull((Object)schema, (Object)"schema is null");
        this.cql = (String)Preconditions.checkNotNull((Object)cql, (Object)"cql is null");
        Preconditions.checkNotNull(cassandraColumns, (Object)"cassandraColumns is null");
        this.cassandraTypes = Lists.transform(cassandraColumns, CassandraColumnHandle.cassandraFullTypeGetter());
        this.columnTypes = Lists.transform(cassandraColumns, CassandraColumnHandle.nativeTypeGetter());
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new CassandraRecordCursor(this.cassandraSession, this.schema, this.cassandraTypes, this.cql);
    }
}

