/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.facebook.presto.cassandra.CassandraColumnHandle;
import com.facebook.presto.cassandra.CassandraPartition;
import com.facebook.presto.cassandra.CassandraTable;
import com.facebook.presto.cassandra.CassandraTableHandle;
import com.facebook.presto.cassandra.CassandraType;
import com.facebook.presto.cassandra.ExtraColumnMetadata;
import com.facebook.presto.cassandra.util.CassandraCqlUtils;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.TupleDomain;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.json.JsonCodec;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

public class CassandraSession {
    static final String PRESTO_COMMENT_METADATA = "Presto Metadata:";
    protected final String connectorId;
    private final int fetchSizeForPartitionKeySelect;
    private final int limitForPartitionKeySelect;
    private final JsonCodec<List<ExtraColumnMetadata>> extraColumnMetadataCodec;
    private LoadingCache<String, Session> sessionBySchema;

    public CassandraSession(String connectorId, final Cluster.Builder clusterBuilder, int fetchSizeForPartitionKeySelect, int limitForPartitionKeySelect, JsonCodec<List<ExtraColumnMetadata>> extraColumnMetadataCodec) {
        this.connectorId = connectorId;
        this.fetchSizeForPartitionKeySelect = fetchSizeForPartitionKeySelect;
        this.limitForPartitionKeySelect = limitForPartitionKeySelect;
        this.extraColumnMetadataCodec = extraColumnMetadataCodec;
        this.sessionBySchema = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Session>(){

            public Session load(String key) throws Exception {
                return clusterBuilder.build().connect();
            }
        });
    }

    public Set<Host> getReplicas(final String schemaName, final ByteBuffer partitionKey) {
        return this.executeWithSession(schemaName, new SessionCallable<Set<Host>>(){

            @Override
            public Set<Host> executeWithSession(Session session) {
                return session.getCluster().getMetadata().getReplicas(schemaName, partitionKey);
            }
        });
    }

    private Session getSession(String schemaName) {
        try {
            return (Session)this.sessionBySchema.get((Object)schemaName);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    public ResultSet executeQuery(String schemaName, final String cql) {
        return this.executeWithSession(schemaName, new SessionCallable<ResultSet>(){

            @Override
            public ResultSet executeWithSession(Session session) {
                return session.execute(cql);
            }
        });
    }

    public ResultSet execute(String schemaName, final String cql, final Object ... values) {
        return this.executeWithSession(schemaName, new SessionCallable<ResultSet>(){

            @Override
            public ResultSet executeWithSession(Session session) {
                return session.execute(cql, values);
            }
        });
    }

    public Collection<Host> getAllHosts() {
        return this.executeWithSession("", new SessionCallable<Collection<Host>>(){

            @Override
            public Collection<Host> executeWithSession(Session session) {
                return session.getCluster().getMetadata().getAllHosts();
            }
        });
    }

    public List<String> getAllSchemas() {
        ImmutableList.Builder builder = ImmutableList.builder();
        List<KeyspaceMetadata> keyspaces = this.executeWithSession("", new SessionCallable<List<KeyspaceMetadata>>(){

            @Override
            public List<KeyspaceMetadata> executeWithSession(Session session) {
                return session.getCluster().getMetadata().getKeyspaces();
            }
        });
        for (KeyspaceMetadata meta : keyspaces) {
            builder.add((Object)meta.getName());
        }
        return builder.build();
    }

    public List<String> getAllTables(String schema) throws SchemaNotFoundException {
        KeyspaceMetadata meta = this.getCheckedKeyspaceMetadata(schema);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TableMetadata tableMeta : meta.getTables()) {
            builder.add((Object)tableMeta.getName());
        }
        return builder.build();
    }

    private KeyspaceMetadata getCheckedKeyspaceMetadata(final String schema) throws SchemaNotFoundException {
        KeyspaceMetadata keyspaceMetadata = this.executeWithSession(schema, new SessionCallable<KeyspaceMetadata>(){

            @Override
            public KeyspaceMetadata executeWithSession(Session session) {
                return session.getCluster().getMetadata().getKeyspace(schema);
            }
        });
        if (keyspaceMetadata == null) {
            throw new SchemaNotFoundException(schema);
        }
        return keyspaceMetadata;
    }

    public void getSchema(String schema) throws SchemaNotFoundException {
        this.getCheckedKeyspaceMetadata(schema);
    }

    public CassandraTable getTable(SchemaTableName tableName) throws TableNotFoundException {
        CassandraColumnHandle columnHandle;
        boolean hidden;
        TableMetadata tableMeta = this.getTableMetadata(tableName);
        List columnNames = new ArrayList<String>();
        for (ColumnMetadata columnMetadata : tableMeta.getColumns()) {
            columnNames.add(columnMetadata.getName());
        }
        String comment = tableMeta.getOptions().getComment();
        ImmutableSet hiddenColumns = ImmutableSet.of();
        if (comment != null && comment.startsWith(PRESTO_COMMENT_METADATA)) {
            String columnOrderingString = comment.substring(PRESTO_COMMENT_METADATA.length());
            List extras = (List)this.extraColumnMetadataCodec.fromJson(columnOrderingString);
            ArrayList explicitColumnOrder = new ArrayList(ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)extras, ExtraColumnMetadata.nameGetter())));
            hiddenColumns = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)extras, ExtraColumnMetadata.hiddenPredicate()), ExtraColumnMetadata.nameGetter()));
            Iterables.addAll(explicitColumnOrder, (Iterable)Iterables.filter(columnNames, (Predicate)Predicates.not((Predicate)Predicates.in(explicitColumnOrder))));
            columnNames = Ordering.explicit(explicitColumnOrder).sortedCopy(columnNames);
        }
        ImmutableList.Builder columnHandles = ImmutableList.builder();
        HashSet<String> primaryKeySet = new HashSet<String>();
        for (ColumnMetadata columnMeta : tableMeta.getPartitionKey()) {
            primaryKeySet.add(columnMeta.getName());
            hidden = hiddenColumns.contains(columnMeta.getName());
            columnHandle = this.buildColumnHandle(columnMeta, true, false, columnNames.indexOf(columnMeta.getName()), hidden);
            columnHandles.add((Object)columnHandle);
        }
        for (ColumnMetadata columnMeta : tableMeta.getClusteringColumns()) {
            primaryKeySet.add(columnMeta.getName());
            hidden = hiddenColumns.contains(columnMeta.getName());
            columnHandle = this.buildColumnHandle(columnMeta, false, true, columnNames.indexOf(columnMeta.getName()), hidden);
            columnHandles.add((Object)columnHandle);
        }
        for (ColumnMetadata columnMeta : tableMeta.getColumns()) {
            if (primaryKeySet.contains(columnMeta.getName())) continue;
            hidden = hiddenColumns.contains(columnMeta.getName());
            columnHandle = this.buildColumnHandle(columnMeta, false, false, columnNames.indexOf(columnMeta.getName()), hidden);
            columnHandles.add((Object)columnHandle);
        }
        List sortedColumnHandles = Ordering.natural().onResultOf((Function)new Function<CassandraColumnHandle, Integer>(){

            @Nullable
            public Integer apply(CassandraColumnHandle columnHandle) {
                return columnHandle.getOrdinalPosition();
            }
        }).sortedCopy((Iterable)columnHandles.build());
        CassandraTableHandle tableHandle = new CassandraTableHandle(this.connectorId, tableMeta.getKeyspace().getName(), tableMeta.getName());
        return new CassandraTable(tableHandle, sortedColumnHandles);
    }

    private TableMetadata getTableMetadata(SchemaTableName schemaTableName) {
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        KeyspaceMetadata keyspaceMetadata = this.getCheckedKeyspaceMetadata(schemaName);
        TableMetadata tableMetadata = keyspaceMetadata.getTable(tableName);
        if (tableMetadata != null) {
            return tableMetadata;
        }
        for (TableMetadata table : keyspaceMetadata.getTables()) {
            if (!table.getName().equalsIgnoreCase(tableName)) continue;
            return table;
        }
        throw new TableNotFoundException(schemaTableName);
    }

    private CassandraColumnHandle buildColumnHandle(ColumnMetadata columnMeta, boolean partitionKey, boolean clusteringKey, int ordinalPosition, boolean hidden) {
        CassandraType cassandraType = CassandraType.getCassandraType(columnMeta.getType().getName());
        ImmutableList typeArguments = null;
        if (cassandraType != null && cassandraType.getTypeArgumentSize() > 0) {
            List typeArgs = columnMeta.getType().getTypeArguments();
            switch (cassandraType.getTypeArgumentSize()) {
                case 1: {
                    typeArguments = ImmutableList.of((Object)CassandraType.getCassandraType(((DataType)typeArgs.get(0)).getName()));
                    break;
                }
                case 2: {
                    typeArguments = ImmutableList.of((Object)CassandraType.getCassandraType(((DataType)typeArgs.get(0)).getName()), (Object)CassandraType.getCassandraType(((DataType)typeArgs.get(1)).getName()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid type arguments: " + typeArgs);
                }
            }
        }
        boolean indexed = columnMeta.getIndex() != null;
        return new CassandraColumnHandle(this.connectorId, columnMeta.getName(), ordinalPosition, cassandraType, (List<CassandraType>)typeArguments, partitionKey, clusteringKey, indexed, hidden);
    }

    public List<CassandraPartition> getPartitions(CassandraTable table, List<Comparable<?>> filterPrefix) {
        Iterable<Row> rows = this.queryPartitionKeys(table, filterPrefix);
        if (rows == null) {
            return ImmutableList.of((Object)CassandraPartition.UNPARTITIONED);
        }
        List<CassandraColumnHandle> partitionKeyColumns = table.getPartitionKeyColumns();
        ByteBuffer buffer = ByteBuffer.allocate(1000);
        HashMap map = new HashMap();
        HashSet<String> uniquePartitionIds = new HashSet<String>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean isComposite = partitionKeyColumns.size() > 1;
        ImmutableList.Builder partitions = ImmutableList.builder();
        for (Row row : rows) {
            buffer.clear();
            map.clear();
            stringBuilder.setLength(0);
            for (int i = 0; i < partitionKeyColumns.size(); ++i) {
                ByteBuffer component = row.getBytesUnsafe(i);
                if (isComposite) {
                    short len = (short)component.limit();
                    buffer.putShort(len);
                    buffer.put(component);
                    buffer.put((byte)0);
                } else {
                    buffer.put(component);
                }
                CassandraColumnHandle columnHandle = partitionKeyColumns.get(i);
                Comparable<?> keyPart = CassandraType.getColumnValueForPartitionKey(row, i, columnHandle.getCassandraType(), columnHandle.getTypeArguments());
                map.put(columnHandle, keyPart);
                if (i > 0) {
                    stringBuilder.append(" AND ");
                }
                stringBuilder.append(CassandraCqlUtils.validColumnName(columnHandle.getName()));
                stringBuilder.append(" = ");
                stringBuilder.append(CassandraType.getColumnValueForCql(row, i, columnHandle.getCassandraType()));
            }
            buffer.flip();
            byte[] key = new byte[buffer.limit()];
            buffer.get(key);
            TupleDomain tupleDomain = TupleDomain.withFixedValues(map);
            String partitionId = stringBuilder.toString();
            if (!uniquePartitionIds.add(partitionId)) continue;
            partitions.add((Object)new CassandraPartition(key, partitionId, (TupleDomain<ConnectorColumnHandle>)tupleDomain, false));
        }
        return partitions.build();
    }

    protected Iterable<Row> queryPartitionKeys(CassandraTable table, List<Comparable<?>> filterPrefix) {
        ResultSetFuture countFuture;
        boolean fullPartitionKey;
        CassandraTableHandle tableHandle = table.getTableHandle();
        String schemaName = tableHandle.getSchemaName();
        List<CassandraColumnHandle> partitionKeyColumns = table.getPartitionKeyColumns();
        boolean bl = fullPartitionKey = filterPrefix.size() == partitionKeyColumns.size();
        if (!fullPartitionKey) {
            final Select countAll = CassandraCqlUtils.selectCountAllFrom(tableHandle).limit(this.limitForPartitionKeySelect);
            countFuture = this.executeWithSession(schemaName, new SessionCallable<ResultSetFuture>(){

                @Override
                public ResultSetFuture executeWithSession(Session session) {
                    return session.executeAsync((Statement)countAll);
                }
            });
        } else {
            countFuture = null;
        }
        int limit = fullPartitionKey ? 1 : this.limitForPartitionKeySelect;
        final Select partitionKeys = CassandraCqlUtils.selectDistinctFrom(tableHandle, partitionKeyColumns);
        partitionKeys.limit(limit);
        partitionKeys.setFetchSize(this.fetchSizeForPartitionKeySelect);
        if (!fullPartitionKey) {
            CassandraSession.addWhereClause(partitionKeys.where(), partitionKeyColumns, new ArrayList());
            ResultSetFuture partitionKeyFuture = this.executeWithSession(schemaName, new SessionCallable<ResultSetFuture>(){

                @Override
                public ResultSetFuture executeWithSession(Session session) {
                    return session.executeAsync((Statement)partitionKeys);
                }
            });
            long count = countFuture.getUninterruptibly().one().getLong(0);
            if (count == (long)this.limitForPartitionKeySelect) {
                partitionKeyFuture.cancel(true);
                return null;
            }
            return partitionKeyFuture.getUninterruptibly();
        }
        CassandraSession.addWhereClause(partitionKeys.where(), partitionKeyColumns, filterPrefix);
        ResultSetFuture partitionKeyFuture = this.executeWithSession(schemaName, new SessionCallable<ResultSetFuture>(){

            @Override
            public ResultSetFuture executeWithSession(Session session) {
                return session.executeAsync((Statement)partitionKeys);
            }
        });
        return partitionKeyFuture.getUninterruptibly();
    }

    public <T> T executeWithSession(String schemaName, SessionCallable<T> sessionCallable) {
        NoHostAvailableException lastException = null;
        for (int i = 0; i < 2; ++i) {
            Session session = this.getSession(schemaName);
            try {
                return sessionCallable.executeWithSession(session);
            }
            catch (NoHostAvailableException e) {
                lastException = e;
                this.sessionBySchema.asMap().remove(schemaName, session);
                continue;
            }
        }
        throw lastException;
    }

    private static void addWhereClause(Select.Where where, List<CassandraColumnHandle> partitionKeyColumns, List<Comparable<?>> filterPrefix) {
        for (int i = 0; i < filterPrefix.size(); ++i) {
            CassandraColumnHandle column = partitionKeyColumns.get(i);
            Object value = column.getCassandraType().getJavaValue(filterPrefix.get(i));
            Clause clause = QueryBuilder.eq((String)CassandraCqlUtils.validColumnName(column.getName()), (Object)value);
            where.and(clause);
        }
    }

    private static interface SessionCallable<T> {
        public T executeWithSession(Session var1);
    }
}

