/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.cassandra.CassandraColumnHandle;
import com.facebook.presto.cassandra.CassandraTableHandle;
import com.facebook.presto.cassandra.util.CassandraCqlUtils;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;

public class CassandraTable {
    private final CassandraTableHandle tableHandle;
    private final List<CassandraColumnHandle> columns;

    public CassandraTable(CassandraTableHandle tableHandle, List<CassandraColumnHandle> columns) {
        this.tableHandle = tableHandle;
        this.columns = ImmutableList.copyOf(columns);
    }

    public List<CassandraColumnHandle> getColumns() {
        return this.columns;
    }

    public CassandraTableHandle getTableHandle() {
        return this.tableHandle;
    }

    public List<CassandraColumnHandle> getPartitionKeyColumns() {
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.columns, CassandraColumnHandle.partitionKeyPredicate()));
    }

    public String getTokenExpression() {
        StringBuilder sb = new StringBuilder();
        for (CassandraColumnHandle column : this.getPartitionKeyColumns()) {
            if (sb.length() == 0) {
                sb.append("token(");
            } else {
                sb.append(",");
            }
            sb.append(CassandraCqlUtils.validColumnName(column.getName()));
        }
        sb.append(")");
        return sb.toString();
    }

    public int hashCode() {
        return this.tableHandle.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CassandraTable)) {
            return false;
        }
        CassandraTable that = (CassandraTable)obj;
        return this.tableHandle.equals(that.tableHandle);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableHandle", (Object)this.tableHandle).toString();
    }
}

