/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.cassandra.CassandraThriftConnectionFactory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfSplit;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;

public class CassandraThriftClient {
    private final CassandraThriftConnectionFactory connectionFactory;

    public CassandraThriftClient(CassandraThriftConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public List<TokenRange> getRangeMap(String keyspace) {
        Cassandra.Client client = this.connectionFactory.create();
        try {
            List list = client.describe_ring(keyspace);
            return list;
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
        finally {
            CassandraThriftClient.closeQuietly(client);
        }
    }

    public List<CfSplit> getSubSplits(String keyspace, String columnFamily, TokenRange range, int splitSize) {
        Cassandra.Client client = this.connectionFactory.create();
        try {
            client.set_keyspace(keyspace);
            try {
                List list = client.describe_splits_ex(columnFamily, range.start_token, range.end_token, splitSize);
                return list;
            }
            catch (TApplicationException e) {
                block9: {
                    if (e.getType() != 1) break block9;
                    List splitPoints = client.describe_splits(columnFamily, range.start_token, range.end_token, splitSize);
                    List<CfSplit> list = CassandraThriftClient.tokenListToSplits(splitPoints, splitSize);
                    CassandraThriftClient.closeQuietly(client);
                    return list;
                }
                try {
                    throw e;
                }
                catch (TException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
        finally {
            CassandraThriftClient.closeQuietly(client);
        }
    }

    private static List<CfSplit> tokenListToSplits(List<String> splitTokens, int splitSize) {
        ArrayList splits = Lists.newArrayListWithExpectedSize((int)(splitTokens.size() - 1));
        for (int index = 0; index < splitTokens.size() - 1; ++index) {
            splits.add(new CfSplit(splitTokens.get(index), splitTokens.get(index + 1), (long)splitSize));
        }
        return splits;
    }

    public static void closeQuietly(Cassandra.Client client) {
        try {
            TProtocol inputProtocol = client.getInputProtocol();
            if (inputProtocol == null) {
                return;
            }
            TTransport transport = inputProtocol.getTransport();
            if (transport == null) {
                return;
            }
            transport.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

