/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.cassandra.CassandraClientConfig;
import com.facebook.presto.cassandra.CassandraThriftClient;
import com.facebook.presto.cassandra.CassandraThriftConnectionFactory;
import com.facebook.presto.cassandra.ForCassandra;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.thrift.CfSplit;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.cassandra.utils.FBUtilities;

public class CassandraTokenSplitManager {
    private final CassandraThriftClient cassandraThriftClient;
    private final ExecutorService executor;
    private final int splitSize;
    private final IPartitioner<?> partitioner;

    @Inject
    public CassandraTokenSplitManager(CassandraThriftConnectionFactory connectionFactory, @ForCassandra ExecutorService executor, CassandraClientConfig config) {
        this.cassandraThriftClient = new CassandraThriftClient((CassandraThriftConnectionFactory)Preconditions.checkNotNull((Object)connectionFactory, (Object)"connectionFactory is null"));
        this.executor = (ExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
        this.splitSize = config.getSplitSize();
        try {
            this.partitioner = FBUtilities.newPartitioner((String)config.getPartitioner());
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public List<TokenSplit> getSplits(String keyspace, String columnFamily) throws IOException {
        List<TokenRange> masterRangeNodes = this.cassandraThriftClient.getRangeMap(keyspace);
        ArrayList<TokenSplit> splits = new ArrayList<TokenSplit>();
        ArrayList<Future<List<TokenSplit>>> splitFutures = new ArrayList<Future<List<TokenSplit>>>();
        for (TokenRange tokenRange : masterRangeNodes) {
            splitFutures.add(this.executor.submit(new SplitCallable(tokenRange, keyspace, columnFamily, this.splitSize, this.cassandraThriftClient, this.partitioner)));
        }
        for (Future future : splitFutures) {
            try {
                splits.addAll((Collection)future.get());
            }
            catch (Exception e) {
                throw new IOException("Could not get input splits", e);
            }
        }
        Preconditions.checkState((!splits.isEmpty() ? 1 : 0) != 0, (Object)"No splits created");
        Collections.shuffle(splits, ThreadLocalRandom.current());
        return splits;
    }

    public static class TokenSplit {
        private String startToken;
        private String endToken;
        private List<String> hosts;

        public TokenSplit(String startToken, String endToken, List<String> hosts) {
            this.startToken = (String)Preconditions.checkNotNull((Object)startToken, (Object)"startToken is null");
            this.endToken = (String)Preconditions.checkNotNull((Object)endToken, (Object)"endToken is null");
            this.hosts = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(hosts, (Object)"hosts is null")));
        }

        public String getStartToken() {
            return this.startToken;
        }

        public String getEndToken() {
            return this.endToken;
        }

        public List<String> getHosts() {
            return this.hosts;
        }
    }

    private class SplitCallable<T extends Token<?>>
    implements Callable<List<TokenSplit>> {
        private final TokenRange range;
        private final String keyspace;
        private final String columnFamily;
        private final int splitSize;
        private final CassandraThriftClient client;
        private final IPartitioner<T> partitioner;

        public SplitCallable(TokenRange range, String keyspace, String columnFamily, int splitSize, CassandraThriftClient client, IPartitioner<T> partitioner) {
            Preconditions.checkArgument((range.rpc_endpoints.size() == range.endpoints.size() ? 1 : 0) != 0, (Object)"rpc_endpoints size must match endpoints size");
            this.range = range;
            this.keyspace = keyspace;
            this.columnFamily = columnFamily;
            this.splitSize = splitSize;
            this.client = client;
            this.partitioner = partitioner;
        }

        @Override
        public List<TokenSplit> call() throws Exception {
            ArrayList<TokenSplit> splits = new ArrayList<TokenSplit>();
            List<CfSplit> subSplits = this.client.getSubSplits(this.keyspace, this.columnFamily, this.range, this.splitSize);
            List endpoints = this.range.endpoints;
            Token.TokenFactory factory = this.partitioner.getTokenFactory();
            for (CfSplit subSplit : subSplits) {
                Token right;
                Token left = factory.fromString(subSplit.getStart_token());
                Range range = new Range((RingPosition)left, (RingPosition)(right = factory.fromString(subSplit.getEnd_token())), this.partitioner);
                List ranges = range.isWrapAround() ? range.unwrap() : ImmutableList.of((Object)range);
                for (Range subRange : ranges) {
                    TokenSplit split = new TokenSplit(factory.toString((Token)subRange.left), factory.toString((Token)subRange.right), endpoints);
                    splits.add(split);
                }
            }
            return splits;
        }
    }
}

