/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.utils.Bytes;
import com.facebook.presto.cassandra.FullCassandraType;
import com.facebook.presto.cassandra.util.CassandraCqlUtils;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public enum CassandraType implements FullCassandraType
{
    ASCII((Type)VarcharType.VARCHAR, String.class),
    BIGINT((Type)BigintType.BIGINT, Long.class),
    BLOB((Type)VarcharType.VARCHAR, ByteBuffer.class),
    CUSTOM((Type)VarcharType.VARCHAR, ByteBuffer.class),
    BOOLEAN((Type)BooleanType.BOOLEAN, Boolean.class),
    COUNTER((Type)BigintType.BIGINT, Long.class),
    DECIMAL((Type)DoubleType.DOUBLE, BigDecimal.class),
    DOUBLE((Type)DoubleType.DOUBLE, Double.class),
    FLOAT((Type)DoubleType.DOUBLE, Float.class),
    INET((Type)VarcharType.VARCHAR, InetAddress.class),
    INT((Type)BigintType.BIGINT, Integer.class),
    TEXT((Type)VarcharType.VARCHAR, String.class),
    TIMESTAMP((Type)TimestampType.TIMESTAMP, Date.class),
    UUID((Type)VarcharType.VARCHAR, UUID.class),
    TIMEUUID((Type)VarcharType.VARCHAR, UUID.class),
    VARCHAR((Type)VarcharType.VARCHAR, String.class),
    VARINT((Type)VarcharType.VARCHAR, BigInteger.class),
    LIST((Type)VarcharType.VARCHAR, null),
    MAP((Type)VarcharType.VARCHAR, null),
    SET((Type)VarcharType.VARCHAR, null);

    private final Type nativeType;
    private final Class<?> javaType;

    private CassandraType(Type nativeType, Class<?> javaType) {
        this.nativeType = (Type)Preconditions.checkNotNull((Object)nativeType, (Object)"nativeType is null");
        this.javaType = javaType;
    }

    public Type getNativeType() {
        return this.nativeType;
    }

    public int getTypeArgumentSize() {
        switch (this) {
            case LIST: 
            case SET: {
                return 1;
            }
            case MAP: {
                return 2;
            }
        }
        return 0;
    }

    public static CassandraType getSupportedCassandraType(DataType.Name name) {
        CassandraType cassandraType = CassandraType.getCassandraType(name);
        Preconditions.checkArgument((cassandraType != null ? 1 : 0) != 0, (Object)("Unknown Cassandra type: " + name));
        return cassandraType;
    }

    public static CassandraType getCassandraType(DataType.Name name) {
        switch (name) {
            case ASCII: {
                return ASCII;
            }
            case BIGINT: {
                return BIGINT;
            }
            case BLOB: {
                return BLOB;
            }
            case BOOLEAN: {
                return BOOLEAN;
            }
            case COUNTER: {
                return COUNTER;
            }
            case CUSTOM: {
                return CUSTOM;
            }
            case DECIMAL: {
                return DECIMAL;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case FLOAT: {
                return FLOAT;
            }
            case INET: {
                return INET;
            }
            case INT: {
                return INT;
            }
            case LIST: {
                return LIST;
            }
            case MAP: {
                return MAP;
            }
            case SET: {
                return SET;
            }
            case TEXT: {
                return TEXT;
            }
            case TIMESTAMP: {
                return TIMESTAMP;
            }
            case TIMEUUID: {
                return TIMEUUID;
            }
            case UUID: {
                return UUID;
            }
            case VARCHAR: {
                return VARCHAR;
            }
            case VARINT: {
                return VARINT;
            }
        }
        return null;
    }

    public static CassandraType getSupportedCassandraType(String cassandraTypeName) {
        CassandraType cassandraType = CassandraType.getCassandraType(cassandraTypeName);
        Preconditions.checkArgument((cassandraType != null ? 1 : 0) != 0, (Object)("Unknown Cassandra type: " + cassandraTypeName));
        return cassandraType;
    }

    public static CassandraType getCassandraType(String cassandraTypeName) {
        DataType.Name name = DataType.Name.valueOf((String)cassandraTypeName);
        if (name != null) {
            return CassandraType.getCassandraType(name);
        }
        return null;
    }

    public static Comparable<?> getColumnValue(Row row, int i, FullCassandraType fullCassandraType) {
        return CassandraType.getColumnValue(row, i, fullCassandraType.getCassandraType(), fullCassandraType.getTypeArguments());
    }

    public static Comparable<?> getColumnValue(Row row, int i, CassandraType cassandraType, List<CassandraType> typeArguments) {
        if (row.isNull(i)) {
            return null;
        }
        switch (cassandraType) {
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                return row.getString(i);
            }
            case INT: {
                return (long)row.getInt(i);
            }
            case BIGINT: 
            case COUNTER: {
                return row.getLong(i);
            }
            case BOOLEAN: {
                return row.getBool(i);
            }
            case DOUBLE: {
                return row.getDouble(i);
            }
            case FLOAT: {
                return (double)row.getFloat(i);
            }
            case DECIMAL: {
                return row.getDecimal(i).doubleValue();
            }
            case UUID: 
            case TIMEUUID: {
                return row.getUUID(i).toString();
            }
            case TIMESTAMP: {
                return row.getDate(i).getTime();
            }
            case INET: {
                return InetAddresses.toAddrString((InetAddress)row.getInet(i));
            }
            case VARINT: {
                return row.getVarint(i).toString();
            }
            case BLOB: 
            case CUSTOM: {
                return Bytes.toHexString((ByteBuffer)row.getBytesUnsafe(i));
            }
            case SET: {
                CassandraType.checkTypeArguments(cassandraType, 1, typeArguments);
                return CassandraType.buildSetValue(row, i, typeArguments.get(0));
            }
            case LIST: {
                CassandraType.checkTypeArguments(cassandraType, 1, typeArguments);
                return CassandraType.buildListValue(row, i, typeArguments.get(0));
            }
            case MAP: {
                CassandraType.checkTypeArguments(cassandraType, 2, typeArguments);
                return CassandraType.buildMapValue(row, i, typeArguments.get(0), typeArguments.get(1));
            }
        }
        throw new IllegalStateException("Handling of type " + cassandraType + " is not implemented");
    }

    public static Comparable<?> getColumnValueForPartitionKey(Row row, int i, CassandraType cassandraType, List<CassandraType> typeArguments) {
        if (row.isNull(i)) {
            return null;
        }
        if (cassandraType == ASCII || cassandraType == TEXT || cassandraType == VARCHAR) {
            return Slices.utf8Slice((String)row.getString(i));
        }
        return CassandraType.getColumnValue(row, i, cassandraType, typeArguments);
    }

    private static String buildSetValue(Row row, int i, CassandraType elemType) {
        return CassandraType.buildArrayValue(row.getSet(i, elemType.javaType), elemType);
    }

    private static String buildListValue(Row row, int i, CassandraType elemType) {
        return CassandraType.buildArrayValue(row.getList(i, elemType.javaType), elemType);
    }

    private static String buildMapValue(Row row, int i, CassandraType keyType, CassandraType valueType) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Map.Entry entry : row.getMap(i, keyType.javaType, valueType.javaType).entrySet()) {
            if (sb.length() > 1) {
                sb.append(",");
            }
            sb.append(CassandraType.objectToString(entry.getKey(), keyType));
            sb.append(":");
            sb.append(CassandraType.objectToString(entry.getValue(), valueType));
        }
        sb.append("}");
        return sb.toString();
    }

    @VisibleForTesting
    static String buildArrayValue(Collection<?> collection, CassandraType elemType) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Object value : collection) {
            if (sb.length() > 1) {
                sb.append(",");
            }
            sb.append(CassandraType.objectToString(value, elemType));
        }
        sb.append("]");
        return sb.toString();
    }

    private static void checkTypeArguments(CassandraType type, int expectedSize, List<CassandraType> typeArguments) {
        if (typeArguments == null || typeArguments.size() != expectedSize) {
            throw new IllegalArgumentException("Wrong number of type arguments " + typeArguments + " for " + type);
        }
    }

    public static String getColumnValueForCql(Row row, int i, CassandraType cassandraType) {
        if (row.isNull(i)) {
            return null;
        }
        switch (cassandraType) {
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                return CassandraCqlUtils.quoteStringLiteral(row.getString(i));
            }
            case INT: {
                return Integer.toString(row.getInt(i));
            }
            case BIGINT: 
            case COUNTER: {
                return Long.toString(row.getLong(i));
            }
            case BOOLEAN: {
                return Boolean.toString(row.getBool(i));
            }
            case DOUBLE: {
                return Double.toString(row.getDouble(i));
            }
            case FLOAT: {
                return Float.toString(row.getFloat(i));
            }
            case DECIMAL: {
                return row.getDecimal(i).toString();
            }
            case UUID: 
            case TIMEUUID: {
                return row.getUUID(i).toString();
            }
            case TIMESTAMP: {
                return Long.toString(row.getDate(i).getTime());
            }
            case INET: {
                return CassandraCqlUtils.quoteStringLiteral(InetAddresses.toAddrString((InetAddress)row.getInet(i)));
            }
            case VARINT: {
                return row.getVarint(i).toString();
            }
            case BLOB: 
            case CUSTOM: {
                return Bytes.toHexString((ByteBuffer)row.getBytesUnsafe(i));
            }
        }
        throw new IllegalStateException("Handling of type " + cassandraType + " is not implemented");
    }

    private static String objectToString(Object object, CassandraType elemType) {
        switch (elemType) {
            case ASCII: 
            case TEXT: 
            case VARCHAR: 
            case UUID: 
            case TIMEUUID: 
            case TIMESTAMP: 
            case INET: 
            case VARINT: {
                return CassandraCqlUtils.quoteStringLiteralForJson(object.toString());
            }
            case BLOB: 
            case CUSTOM: {
                return CassandraCqlUtils.quoteStringLiteralForJson(Bytes.toHexString((ByteBuffer)((ByteBuffer)object)));
            }
            case INT: 
            case BIGINT: 
            case COUNTER: 
            case BOOLEAN: 
            case DOUBLE: 
            case FLOAT: 
            case DECIMAL: {
                return object.toString();
            }
        }
        throw new IllegalStateException("Handling of type " + elemType + " is not implemented");
    }

    @Override
    public CassandraType getCassandraType() {
        if (this.getTypeArgumentSize() == 0) {
            return this;
        }
        throw new IllegalStateException();
    }

    @Override
    public List<CassandraType> getTypeArguments() {
        if (this.getTypeArgumentSize() == 0) {
            return null;
        }
        throw new IllegalStateException();
    }

    public Object getJavaValue(Comparable<?> comparable) {
        switch (this) {
            case ASCII: 
            case TEXT: 
            case VARCHAR: 
            case BIGINT: 
            case COUNTER: 
            case BOOLEAN: 
            case DOUBLE: {
                return comparable;
            }
            case INET: {
                return InetAddresses.forString((String)((String)((Object)comparable)));
            }
            case INT: {
                return ((Long)comparable).intValue();
            }
            case FLOAT: {
                return Float.valueOf(((Double)comparable).floatValue());
            }
            case DECIMAL: {
                return new BigDecimal(comparable.toString());
            }
            case TIMESTAMP: {
                return new Date((Long)comparable);
            }
            case UUID: 
            case TIMEUUID: {
                return java.util.UUID.fromString((String)((Object)comparable));
            }
            case BLOB: 
            case CUSTOM: {
                return Bytes.fromHexString((String)((String)((Object)comparable)));
            }
            case VARINT: {
                return new BigInteger((String)((Object)comparable));
            }
        }
        throw new IllegalStateException("Back conversion not implemented for " + this);
    }

    public Comparable<?> getValueForPartitionKey(Comparable<?> comparable) {
        switch (this) {
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                if (comparable instanceof Slice) {
                    return ((Slice)comparable).toStringUtf8();
                }
                return comparable;
            }
            case INT: 
            case BIGINT: 
            case BOOLEAN: 
            case DOUBLE: 
            case FLOAT: 
            case DECIMAL: 
            case UUID: 
            case TIMEUUID: 
            case TIMESTAMP: 
            case INET: {
                return comparable;
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupport partition key type: " + this);
    }

    public static CassandraType toCassandraType(Type type) {
        if (type.equals(BooleanType.BOOLEAN)) {
            return BOOLEAN;
        }
        if (type.equals(BigintType.BIGINT)) {
            return BIGINT;
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return DOUBLE;
        }
        if (type.equals(VarcharType.VARCHAR)) {
            return TEXT;
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }
}

