/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.client;

import com.facebook.airlift.json.JsonObjectMapperProvider;
import com.facebook.presto.client.ClientTypeSignature;
import com.facebook.presto.common.type.BigintEnumType;
import com.facebook.presto.common.type.DistinctTypeInfo;
import com.facebook.presto.common.type.NamedTypeSignature;
import com.facebook.presto.common.type.ParameterKind;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarcharEnumType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@JsonDeserialize(using=ClientTypeSignatureParameterDeserializer.class)
@Immutable
public class ClientTypeSignatureParameter {
    private final ParameterKind kind;
    private final Object value;

    public ClientTypeSignatureParameter(TypeSignatureParameter typeParameterSignature) {
        this.kind = typeParameterSignature.getKind();
        switch (this.kind) {
            case TYPE: {
                this.value = new ClientTypeSignature(typeParameterSignature.getTypeSignature());
                break;
            }
            case LONG: {
                this.value = typeParameterSignature.getLongLiteral();
                break;
            }
            case NAMED_TYPE: {
                this.value = typeParameterSignature.getNamedTypeSignature();
                break;
            }
            case LONG_ENUM: {
                this.value = typeParameterSignature.getLongEnumMap();
                break;
            }
            case VARCHAR_ENUM: {
                this.value = typeParameterSignature.getVarcharEnumMap();
                break;
            }
            case DISTINCT_TYPE: {
                this.value = typeParameterSignature.getDistinctTypeInfo();
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unknown kind [%s]", this.kind));
            }
        }
    }

    @JsonCreator
    public ClientTypeSignatureParameter(@JsonProperty(value="kind") ParameterKind kind, @JsonProperty(value="value") Object value) {
        this.kind = kind;
        this.value = value;
    }

    @JsonProperty
    public ParameterKind getKind() {
        return this.kind;
    }

    @JsonProperty
    public Object getValue() {
        return this.value;
    }

    private <A> A getValue(ParameterKind expectedParameterKind, Class<A> target) {
        if (this.kind != expectedParameterKind) {
            throw new IllegalArgumentException(String.format("ParameterKind is [%s] but expected [%s]", this.kind, expectedParameterKind));
        }
        return target.cast(this.value);
    }

    public ClientTypeSignature getTypeSignature() {
        return this.getValue(ParameterKind.TYPE, ClientTypeSignature.class);
    }

    public Long getLongLiteral() {
        return this.getValue(ParameterKind.LONG, Long.class);
    }

    public NamedTypeSignature getNamedTypeSignature() {
        return this.getValue(ParameterKind.NAMED_TYPE, NamedTypeSignature.class);
    }

    public String toString() {
        return this.value.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientTypeSignatureParameter other = (ClientTypeSignatureParameter)o;
        return Objects.equals(this.kind, other.kind) && Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hash(this.kind, this.value);
    }

    public static class ClientTypeSignatureParameterDeserializer
    extends JsonDeserializer<ClientTypeSignatureParameter> {
        private static final ObjectMapper MAPPER = new JsonObjectMapperProvider().get();

        public ClientTypeSignatureParameter deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
            Object value;
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            ParameterKind kind = (ParameterKind)MAPPER.readValue(MAPPER.treeAsTokens((TreeNode)node.get("kind")), ParameterKind.class);
            JsonParser jsonValue = MAPPER.treeAsTokens((TreeNode)node.get("value"));
            switch (kind) {
                case TYPE: {
                    value = MAPPER.readValue(jsonValue, ClientTypeSignature.class);
                    break;
                }
                case NAMED_TYPE: {
                    value = MAPPER.readValue(jsonValue, NamedTypeSignature.class);
                    break;
                }
                case LONG: {
                    value = MAPPER.readValue(jsonValue, Long.class);
                    break;
                }
                case LONG_ENUM: {
                    value = MAPPER.readValue(jsonValue, BigintEnumType.LongEnumMap.class);
                    break;
                }
                case VARCHAR_ENUM: {
                    value = MAPPER.readValue(jsonValue, VarcharEnumType.VarcharEnumMap.class);
                    break;
                }
                case DISTINCT_TYPE: {
                    value = MAPPER.readValue(jsonValue, DistinctTypeInfo.class);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unsupported kind [%s]", kind));
                }
            }
            return new ClientTypeSignatureParameter(kind, value);
        }
    }
}

