/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.function;

import com.facebook.presto.common.QualifiedObjectName;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum OperatorType {
    ADD("+", false),
    SUBTRACT("-", false),
    MULTIPLY("*", false),
    DIVIDE("/", false),
    MODULUS("%", false),
    NEGATION("-", false),
    EQUAL("=", false),
    NOT_EQUAL("<>", false),
    LESS_THAN("<", false),
    LESS_THAN_OR_EQUAL("<=", false),
    GREATER_THAN(">", false),
    GREATER_THAN_OR_EQUAL(">=", false),
    BETWEEN("BETWEEN", false),
    CAST("CAST", false),
    SUBSCRIPT("[]", false),
    HASH_CODE("HASH CODE", false),
    SATURATED_FLOOR_CAST("SATURATED FLOOR CAST", false),
    IS_DISTINCT_FROM("IS DISTINCT FROM", true),
    XX_HASH_64("XX HASH 64", false),
    INDETERMINATE("INDETERMINATE", true);

    private static final Map<QualifiedObjectName, OperatorType> OPERATOR_TYPES;
    private final String operator;
    private final QualifiedObjectName functionName;
    private final boolean calledOnNullInput;

    private OperatorType(String operator, boolean calledOnNullInput) {
        this.operator = operator;
        this.functionName = QualifiedObjectName.valueOf("presto", "default", "$operator$" + this.name());
        this.calledOnNullInput = calledOnNullInput;
    }

    public String getOperator() {
        return this.operator;
    }

    public QualifiedObjectName getFunctionName() {
        return this.functionName;
    }

    public boolean isCalledOnNullInput() {
        return this.calledOnNullInput;
    }

    public static Optional<OperatorType> tryGetOperatorType(QualifiedObjectName operatorName) {
        return Optional.ofNullable(OPERATOR_TYPES.get(operatorName));
    }

    public boolean isComparisonOperator() {
        return this.equals((Object)EQUAL) || this.equals((Object)NOT_EQUAL) || this.equals((Object)LESS_THAN) || this.equals((Object)LESS_THAN_OR_EQUAL) || this.equals((Object)GREATER_THAN) || this.equals((Object)GREATER_THAN_OR_EQUAL) || this.equals((Object)IS_DISTINCT_FROM);
    }

    public boolean isArithmeticOperator() {
        return this.equals((Object)ADD) || this.equals((Object)SUBTRACT) || this.equals((Object)MULTIPLY) || this.equals((Object)DIVIDE) || this.equals((Object)MODULUS);
    }

    static {
        OPERATOR_TYPES = Arrays.stream(OperatorType.values()).collect(Collectors.toMap(OperatorType::getFunctionName, Function.identity()));
    }
}

