/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.EncoderUtil;
import com.facebook.presto.common.block.Int128ArrayBlock;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;

public class Int128ArrayBlockEncoding
implements BlockEncoding {
    public static final String NAME = "INT128_ARRAY";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        int positionCount = block.getPositionCount();
        sliceOutput.appendInt(positionCount);
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
        boolean mayHaveNull = block.mayHaveNull();
        for (int position = 0; position < positionCount; ++position) {
            if (mayHaveNull && block.isNull(position)) continue;
            sliceOutput.writeLong(block.getLong(position, 0));
            sliceOutput.writeLong(block.getLong(position, 8));
        }
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount).orElse(null);
        long[] values = new long[positionCount * 2];
        if (valueIsNull == null) {
            sliceInput.readBytes(Slices.wrappedLongArray((long[])values));
        } else {
            int position = 0;
            for (int index = 0; index < values.length; index += 2) {
                if (!valueIsNull[position]) {
                    values[index] = sliceInput.readLong();
                    values[index + 1] = sliceInput.readLong();
                }
                ++position;
            }
        }
        return new Int128ArrayBlock(0, positionCount, valueIsNull, values);
    }
}

