/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.block.AbstractMapBlock;
import com.facebook.presto.common.block.Block;
import io.airlift.slice.SizeOf;
import java.lang.invoke.MethodHandle;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ObjLongConsumer;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class MapBlock
extends AbstractMapBlock
implements Block {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MapBlock.class).instanceSize();
    private final int startOffset;
    private final int positionCount;
    @Nullable
    private final boolean[] mapIsNull;
    private final int[] offsets;
    private final Block keyBlock;
    private final Block valueBlock;
    private final AbstractMapBlock.HashTables hashTables;
    private final long retainedSizeInBytesExceptHashtable;
    private volatile long sizeInBytes;

    public static MapBlock fromKeyValueBlock(int positionCount, Optional<boolean[]> mapIsNull, int[] offsets, Block keyBlock, Block valueBlock) {
        MapBlock.validateConstructorArguments(0, positionCount, mapIsNull.orElse(null), offsets, keyBlock, valueBlock);
        return MapBlock.createMapBlockInternal(0, positionCount, mapIsNull, offsets, keyBlock, valueBlock, new AbstractMapBlock.HashTables(Optional.empty(), positionCount));
    }

    public static MapBlock createMapBlockInternal(int startOffset, int positionCount, Optional<boolean[]> mapIsNull, int[] offsets, Block keyBlock, Block valueBlock, AbstractMapBlock.HashTables hashTables) {
        MapBlock.validateConstructorArguments(startOffset, positionCount, mapIsNull.orElse(null), offsets, keyBlock, valueBlock);
        Objects.requireNonNull(hashTables, "hashTables is null");
        return new MapBlock(startOffset, positionCount, mapIsNull.orElse(null), offsets, keyBlock, valueBlock, hashTables);
    }

    private static void validateConstructorArguments(int startOffset, int positionCount, @Nullable boolean[] mapIsNull, int[] offsets, Block keyBlock, Block valueBlock) {
        if (startOffset < 0) {
            throw new IllegalArgumentException("startOffset is negative");
        }
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        if (mapIsNull != null && mapIsNull.length - startOffset < positionCount) {
            throw new IllegalArgumentException("isNull length is less than positionCount");
        }
        Objects.requireNonNull(offsets, "offsets is null");
        if (offsets.length - startOffset < positionCount + 1) {
            throw new IllegalArgumentException("offsets length is less than positionCount");
        }
        Objects.requireNonNull(keyBlock, "keyBlock is null");
        Objects.requireNonNull(valueBlock, "valueBlock is null");
        if (keyBlock.getPositionCount() != valueBlock.getPositionCount()) {
            throw new IllegalArgumentException(String.format("keyBlock and valueBlock has different size: %s %s", keyBlock.getPositionCount(), valueBlock.getPositionCount()));
        }
    }

    private MapBlock(int startOffset, int positionCount, @Nullable boolean[] mapIsNull, int[] offsets, Block keyBlock, Block valueBlock, AbstractMapBlock.HashTables hashTables) {
        int[] rawHashTables = hashTables.get();
        if (rawHashTables != null && rawHashTables.length < keyBlock.getPositionCount() * 2) {
            throw new IllegalArgumentException(String.format("keyBlock/valueBlock size does not match hash table size: %s %s", keyBlock.getPositionCount(), rawHashTables.length));
        }
        this.startOffset = startOffset;
        this.positionCount = positionCount;
        this.mapIsNull = mapIsNull;
        this.offsets = offsets;
        this.keyBlock = keyBlock;
        this.valueBlock = valueBlock;
        this.hashTables = hashTables;
        this.sizeInBytes = -1L;
        this.logicalSizeInBytes = -1L;
        this.retainedSizeInBytesExceptHashtable = (long)INSTANCE_SIZE + keyBlock.getRetainedSizeInBytes() + valueBlock.getRetainedSizeInBytes() + SizeOf.sizeOf((int[])offsets) + SizeOf.sizeOf((boolean[])mapIsNull);
    }

    @Override
    protected Block getRawKeyBlock() {
        return this.keyBlock;
    }

    @Override
    protected Block getRawValueBlock() {
        return this.valueBlock;
    }

    @Override
    protected AbstractMapBlock.HashTables getHashTables() {
        return this.hashTables;
    }

    @Override
    protected int[] getOffsets() {
        return this.offsets;
    }

    @Override
    public int getOffsetBase() {
        return this.startOffset;
    }

    @Override
    @Nullable
    protected boolean[] getMapIsNull() {
        return this.mapIsNull;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        if (this.sizeInBytes < 0L) {
            this.calculateSize();
        }
        return this.sizeInBytes;
    }

    private boolean isSinglePositionBlock(int position) {
        return position == 0 && this.positionCount == 1 && this.offsets.length == 2;
    }

    @Override
    public Block getSingleValueBlock(int position) {
        if (this.isSinglePositionBlock(position)) {
            return this;
        }
        return this.getSingleValueBlockInternal(position);
    }

    private void calculateSize() {
        int entriesStart = this.offsets[this.startOffset];
        int entriesEnd = this.offsets[this.startOffset + this.positionCount];
        int entryCount = entriesEnd - entriesStart;
        this.sizeInBytes = this.keyBlock.getRegionSizeInBytes(entriesStart, entryCount) + this.valueBlock.getRegionSizeInBytes(entriesStart, entryCount) + 5L * (long)this.positionCount + 8L * (long)entryCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytesExceptHashtable + this.hashTables.getRetainedSizeInBytes();
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        consumer.accept(this.keyBlock, this.keyBlock.getRetainedSizeInBytes());
        consumer.accept(this.valueBlock, this.valueBlock.getRetainedSizeInBytes());
        consumer.accept(this.offsets, SizeOf.sizeOf((int[])this.offsets));
        if (this.mapIsNull != null) {
            consumer.accept(this.mapIsNull, SizeOf.sizeOf((boolean[])this.mapIsNull));
        }
        consumer.accept(this.hashTables, this.hashTables.getRetainedSizeInBytes());
        consumer.accept(this, INSTANCE_SIZE);
    }

    public String toString() {
        return String.format("MapBlock(%d){positionCount=%d}", this.hashCode(), this.getPositionCount());
    }

    @Override
    public Block getLoadedBlock() {
        if (this.keyBlock != this.keyBlock.getLoadedBlock()) {
            throw new IllegalStateException();
        }
        Block loadedValueBlock = this.valueBlock.getLoadedBlock();
        if (loadedValueBlock == this.valueBlock) {
            return this;
        }
        return MapBlock.createMapBlockInternal(this.startOffset, this.positionCount, Optional.ofNullable(this.mapIsNull), this.offsets, this.keyBlock, loadedValueBlock, this.hashTables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void ensureHashTableLoaded(MethodHandle keyBlockHashCode) {
        if (this.isHashTablesPresent()) {
            return;
        }
        AbstractMapBlock.HashTables hashTables = this.hashTables;
        synchronized (hashTables) {
            if (!this.isHashTablesPresent()) {
                this.hashTables.loadHashTables(this.hashTables.getExpectedHashTableCount(), this.offsets, this.mapIsNull, this.getRawKeyBlock(), keyBlockHashCode);
            }
        }
    }
}

