/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockUtil;
import com.facebook.presto.common.block.DictionaryId;
import com.facebook.presto.common.block.IntArrayList;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.ObjLongConsumer;
import org.openjdk.jol.info.ClassLayout;

public class DictionaryBlock
implements Block {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DictionaryBlock.class).instanceSize() + ClassLayout.parseClass(DictionaryId.class).instanceSize();
    private static final int NULL_NOT_FOUND = -1;
    private final int positionCount;
    private final Block dictionary;
    private final int idsOffset;
    private final int[] ids;
    private final long retainedSizeInBytes;
    private volatile long sizeInBytes = -1L;
    private volatile long logicalSizeInBytes = -1L;
    private volatile int uniqueIds = -1;
    private final DictionaryId dictionarySourceId;

    public DictionaryBlock(Block dictionary, int[] ids) {
        this(Objects.requireNonNull(ids, "ids is null").length, dictionary, ids);
    }

    public DictionaryBlock(int positionCount, Block dictionary, int[] ids) {
        this(0, positionCount, dictionary, ids, false, DictionaryId.randomDictionaryId());
    }

    public DictionaryBlock(int positionCount, Block dictionary, int[] ids, DictionaryId dictionaryId) {
        this(0, positionCount, dictionary, ids, false, dictionaryId);
    }

    public DictionaryBlock(int positionCount, Block dictionary, int[] ids, boolean dictionaryIsCompacted) {
        this(0, positionCount, dictionary, ids, dictionaryIsCompacted, DictionaryId.randomDictionaryId());
    }

    public DictionaryBlock(int positionCount, Block dictionary, int[] ids, boolean dictionaryIsCompacted, DictionaryId dictionarySourceId) {
        this(0, positionCount, dictionary, ids, dictionaryIsCompacted, dictionarySourceId);
    }

    public DictionaryBlock(int idsOffset, int positionCount, Block dictionary, int[] ids, boolean dictionaryIsCompacted, DictionaryId dictionarySourceId) {
        Objects.requireNonNull(dictionary, "dictionary is null");
        Objects.requireNonNull(ids, "ids is null");
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.idsOffset = idsOffset;
        if (ids.length - idsOffset < positionCount) {
            throw new IllegalArgumentException("ids length is less than positionCount");
        }
        this.positionCount = positionCount;
        this.dictionary = dictionary;
        this.ids = ids;
        this.dictionarySourceId = Objects.requireNonNull(dictionarySourceId, "dictionarySourceId is null");
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + dictionary.getRetainedSizeInBytes() + SizeOf.sizeOf((int[])ids);
        if (dictionaryIsCompacted) {
            this.sizeInBytes = dictionary.getSizeInBytes() + 4L * (long)positionCount;
            this.uniqueIds = dictionary.getPositionCount();
        }
    }

    @Override
    public int getSliceLength(int position) {
        return this.dictionary.getSliceLength(this.getId(position));
    }

    @Override
    public byte getByte(int position) {
        return this.dictionary.getByte(this.getId(position));
    }

    @Override
    public short getShort(int position) {
        return this.dictionary.getShort(this.getId(position));
    }

    @Override
    public int getInt(int position) {
        return this.dictionary.getInt(this.getId(position));
    }

    @Override
    public long getLong(int position) {
        return this.dictionary.getLong(this.getId(position));
    }

    @Override
    public long getLong(int position, int offset) {
        return this.dictionary.getLong(this.getId(position), offset);
    }

    @Override
    public Slice getSlice(int position, int offset, int length) {
        return this.dictionary.getSlice(this.getId(position), offset, length);
    }

    @Override
    public Block getBlock(int position) {
        return this.dictionary.getBlock(this.getId(position));
    }

    @Override
    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        return this.dictionary.bytesEqual(this.getId(position), offset, otherSlice, otherOffset, length);
    }

    @Override
    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        return this.dictionary.bytesCompare(this.getId(position), offset, length, otherSlice, otherOffset, otherLength);
    }

    @Override
    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        this.dictionary.writeBytesTo(this.getId(position), offset, length, blockBuilder);
    }

    @Override
    public void writeBytesTo(int position, int offset, int length, SliceOutput sliceOutput) {
        this.dictionary.writeBytesTo(this.getId(position), offset, length, sliceOutput);
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.dictionary.writePositionTo(this.getId(position), blockBuilder);
    }

    @Override
    public void writePositionTo(int position, SliceOutput output) {
        this.dictionary.writePositionTo(this.getId(position), output);
    }

    @Override
    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        return this.dictionary.equals(this.getId(position), offset, otherBlock, otherPosition, otherOffset, length);
    }

    @Override
    public long hash(int position, int offset, int length) {
        return this.dictionary.hash(this.getId(position), offset, length);
    }

    @Override
    public int compareTo(int leftPosition, int leftOffset, int leftLength, Block rightBlock, int rightPosition, int rightOffset, int rightLength) {
        return this.dictionary.compareTo(this.getId(leftPosition), leftOffset, leftLength, rightBlock, rightPosition, rightOffset, rightLength);
    }

    @Override
    public Block getSingleValueBlock(int position) {
        return this.dictionary.getSingleValueBlock(this.getId(position));
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        if (this.sizeInBytes < 0L) {
            this.calculateCompactSize();
        }
        return this.sizeInBytes;
    }

    @Override
    public OptionalInt fixedSizeInBytesPerPosition() {
        OptionalInt dictionarySizePerPosition;
        if (this.uniqueIds == this.positionCount && (dictionarySizePerPosition = this.dictionary.fixedSizeInBytesPerPosition()).isPresent()) {
            return OptionalInt.of(dictionarySizePerPosition.getAsInt() + 4);
        }
        return OptionalInt.empty();
    }

    private void calculateCompactSize() {
        int uniqueIds = 0;
        boolean[] used = new boolean[this.dictionary.getPositionCount()];
        for (int i = this.idsOffset; i < this.idsOffset + this.positionCount; ++i) {
            int id = this.ids[i];
            uniqueIds += used[id] ? 0 : 1;
            used[id] = true;
        }
        this.uniqueIds = uniqueIds;
        this.sizeInBytes = this.getSizeInBytesForSelectedPositions(used, uniqueIds, this.positionCount);
    }

    @Override
    public long getLogicalSizeInBytes() {
        return this.getRegionLogicalSizeInBytes(0, this.getPositionCount());
    }

    @Override
    public long getRegionSizeInBytes(int positionOffset, int length) {
        if (positionOffset == 0 && length == this.getPositionCount()) {
            return this.getSizeInBytes();
        }
        OptionalInt fixedSizePerPosition = this.fixedSizeInBytesPerPosition();
        if (fixedSizePerPosition.isPresent()) {
            return (long)fixedSizePerPosition.getAsInt() * (long)length;
        }
        int uniqueIds = 0;
        boolean[] used = new boolean[this.dictionary.getPositionCount()];
        for (int i = this.idsOffset + positionOffset; i < this.idsOffset + positionOffset + length; ++i) {
            int id = this.ids[i];
            uniqueIds += used[id] ? 0 : 1;
            used[id] = true;
        }
        return this.getSizeInBytesForSelectedPositions(used, uniqueIds, length);
    }

    @Override
    public long getRegionLogicalSizeInBytes(int positionOffset, int length) {
        if (positionOffset == 0 && length == this.getPositionCount() && this.logicalSizeInBytes >= 0L) {
            return this.logicalSizeInBytes;
        }
        long sizeInBytes = 0L;
        if (length > this.dictionary.getPositionCount()) {
            long[] seenSizes = new long[this.dictionary.getPositionCount()];
            Arrays.fill(seenSizes, -1L);
            for (int i = positionOffset; i < positionOffset + length; ++i) {
                int position = this.getId(i);
                if (seenSizes[position] < 0L) {
                    seenSizes[position] = this.dictionary.getRegionLogicalSizeInBytes(position, 1);
                }
                sizeInBytes += seenSizes[position];
            }
        } else {
            for (int i = positionOffset; i < positionOffset + length; ++i) {
                sizeInBytes += this.dictionary.getRegionLogicalSizeInBytes(this.getId(i), 1);
            }
        }
        if (positionOffset == 0 && length == this.getPositionCount()) {
            this.logicalSizeInBytes = sizeInBytes;
        }
        return sizeInBytes;
    }

    @Override
    public long getApproximateRegionLogicalSizeInBytes(int position, int length) {
        int dictionaryPositionCount = this.dictionary.getPositionCount();
        return dictionaryPositionCount == 0 ? 0L : this.dictionary.getApproximateRegionLogicalSizeInBytes(0, dictionaryPositionCount) * (long)length / (long)dictionaryPositionCount;
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions, int usedPositionCount) {
        BlockUtil.checkValidPositions(positions, this.positionCount);
        if (usedPositionCount == 0) {
            return 0L;
        }
        if (usedPositionCount == this.positionCount) {
            return this.getSizeInBytes();
        }
        OptionalInt fixedSizePerPosition = this.fixedSizeInBytesPerPosition();
        if (fixedSizePerPosition.isPresent()) {
            return (long)fixedSizePerPosition.getAsInt() * (long)usedPositionCount;
        }
        int uniqueIds = 0;
        boolean[] used = new boolean[this.dictionary.getPositionCount()];
        for (int i = 0; i < positions.length; ++i) {
            int id = this.ids[this.idsOffset + i];
            if (!positions[i]) continue;
            uniqueIds += used[id] ? 0 : 1;
            used[id] = true;
        }
        return this.getSizeInBytesForSelectedPositions(used, uniqueIds, usedPositionCount);
    }

    private long getSizeInBytesForSelectedPositions(boolean[] usedIds, int uniqueIds, int selectedPositions) {
        long dictionarySize = this.dictionary.getPositionsSizeInBytes(usedIds, uniqueIds);
        if (uniqueIds == this.dictionary.getPositionCount() && this.uniqueIds == -1) {
            this.uniqueIds = uniqueIds;
            this.sizeInBytes = dictionarySize + 4L * (long)this.positionCount;
        }
        return dictionarySize + 4L * (long)selectedPositions;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        return this.dictionary.getEstimatedDataSizeForStats(this.getId(position));
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        consumer.accept(this.dictionary, this.dictionary.getRetainedSizeInBytes());
        consumer.accept(this.ids, SizeOf.sizeOf((int[])this.ids));
        consumer.accept(this, INSTANCE_SIZE);
    }

    @Override
    public String getEncodingName() {
        return "DICTIONARY";
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        IntArrayList positionsToCopy = new IntArrayList();
        HashMap<Integer, Integer> oldIndexToNewIndex = new HashMap<Integer, Integer>();
        int[] newIds = new int[length];
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            int oldIndex = this.getId(position);
            if (!oldIndexToNewIndex.containsKey(oldIndex)) {
                oldIndexToNewIndex.put(oldIndex, positionsToCopy.size());
                positionsToCopy.add(oldIndex);
            }
            newIds[i] = (Integer)oldIndexToNewIndex.get(oldIndex);
        }
        return new DictionaryBlock(length, this.dictionary.copyPositions(positionsToCopy.elements(), 0, positionsToCopy.size()), newIds, true);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.positionCount, positionOffset, length);
        return new DictionaryBlock(this.idsOffset + positionOffset, length, this.dictionary, this.ids, false, this.dictionarySourceId);
    }

    @Override
    public Block copyRegion(int position, int length) {
        BlockUtil.checkValidRegion(this.positionCount, position, length);
        int[] newIds = Arrays.copyOfRange(this.ids, this.idsOffset + position, this.idsOffset + position + length);
        DictionaryBlock dictionaryBlock = new DictionaryBlock(this.dictionary, newIds);
        return dictionaryBlock.compact();
    }

    @Override
    public boolean isNull(int position) {
        return this.dictionary.isNull(this.getId(position));
    }

    @Override
    public boolean mayHaveNull() {
        return this.positionCount > 0 && this.dictionary.mayHaveNull();
    }

    @Override
    public Block getPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        int[] newIds = new int[length];
        boolean isCompact = length >= this.dictionary.getPositionCount() && this.isCompact();
        boolean[] usedIds = isCompact ? new boolean[this.dictionary.getPositionCount()] : null;
        int uniqueIds = 0;
        for (int i = 0; i < length; ++i) {
            int id;
            newIds[i] = id = this.getId(positions[offset + i]);
            if (usedIds == null) continue;
            uniqueIds += usedIds[id] ? 0 : 1;
            usedIds[id] = true;
        }
        DictionaryBlock result = new DictionaryBlock(newIds.length, this.dictionary, newIds, isCompact &= usedIds != null && usedIds.length == uniqueIds, this.dictionarySourceId);
        if (usedIds != null && !isCompact) {
            result.uniqueIds = uniqueIds;
            result.sizeInBytes = this.dictionary.getPositionsSizeInBytes(usedIds, uniqueIds) + 4L * (long)length;
        }
        return result;
    }

    public String toString() {
        return String.format("DictionaryBlock(%d){positionCount=%d,dictionary=%s}", this.hashCode(), this.getPositionCount(), this.dictionary.toString());
    }

    @Override
    public Block getLoadedBlock() {
        Block loadedDictionary = this.dictionary.getLoadedBlock();
        if (loadedDictionary == this.dictionary) {
            return this;
        }
        return new DictionaryBlock(this.idsOffset, this.getPositionCount(), loadedDictionary, this.ids, false, DictionaryId.randomDictionaryId());
    }

    public Block getDictionary() {
        return this.dictionary;
    }

    Slice getIds() {
        return Slices.wrappedIntArray((int[])this.ids, (int)this.idsOffset, (int)this.positionCount);
    }

    int[] getRawIds() {
        return this.ids;
    }

    public int getId(int position) {
        BlockUtil.checkValidPosition(position, this.positionCount);
        return this.ids[position + this.idsOffset];
    }

    public DictionaryId getDictionarySourceId() {
        return this.dictionarySourceId;
    }

    public boolean isCompact() {
        if (this.dictionary.getPositionCount() > this.positionCount) {
            return false;
        }
        if (this.uniqueIds < 0) {
            this.calculateCompactSize();
        }
        return this.uniqueIds == this.dictionary.getPositionCount();
    }

    public DictionaryBlock compact() {
        if (this.isCompact()) {
            return this;
        }
        int dictionarySize = this.dictionary.getPositionCount();
        IntArrayList dictionaryPositionsToCopy = new IntArrayList(Math.min(dictionarySize, this.positionCount));
        int[] remapIndex = new int[dictionarySize];
        Arrays.fill(remapIndex, -1);
        int newIndex = 0;
        for (int i = 0; i < this.positionCount; ++i) {
            int dictionaryIndex = this.getId(i);
            if (remapIndex[dictionaryIndex] != -1) continue;
            dictionaryPositionsToCopy.add(dictionaryIndex);
            remapIndex[dictionaryIndex] = newIndex++;
        }
        if (dictionaryPositionsToCopy.size() == dictionarySize) {
            return this;
        }
        int[] newIds = new int[this.positionCount];
        for (int i = 0; i < this.positionCount; ++i) {
            int newId = remapIndex[this.getId(i)];
            if (newId == -1) {
                throw new IllegalStateException("reference to a non-existent key");
            }
            newIds[i] = newId;
        }
        try {
            Block compactDictionary = this.dictionary.copyPositions(dictionaryPositionsToCopy.elements(), 0, dictionaryPositionsToCopy.size());
            return new DictionaryBlock(this.positionCount, compactDictionary, newIds, true);
        }
        catch (UnsupportedOperationException e) {
            return this;
        }
    }

    @Override
    public byte getByteUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.dictionary.getByte(this.ids[internalPosition]);
    }

    @Override
    public short getShortUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.dictionary.getShort(this.ids[internalPosition]);
    }

    @Override
    public int getIntUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.dictionary.getInt(this.ids[internalPosition]);
    }

    @Override
    public long getLongUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.dictionary.getLong(this.ids[internalPosition]);
    }

    @Override
    public long getLongUnchecked(int internalPosition, int offset) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.dictionary.getLong(this.ids[internalPosition], offset);
    }

    @Override
    public Slice getSliceUnchecked(int internalPosition, int offset, int length) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.dictionary.getSlice(this.ids[internalPosition], offset, length);
    }

    @Override
    public int getSliceLengthUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.dictionary.getSliceLength(this.ids[internalPosition]);
    }

    @Override
    public Block getBlockUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.dictionary.getBlock(this.ids[internalPosition]);
    }

    @Override
    public int getOffsetBase() {
        return this.idsOffset;
    }

    @Override
    public boolean isNullUnchecked(int internalPosition) {
        assert (this.mayHaveNull()) : "no nulls present";
        assert (BlockUtil.internalPositionInRange(internalPosition, this.idsOffset, this.positionCount));
        return this.dictionary.isNull(this.ids[internalPosition]);
    }

    @Override
    public Block appendNull() {
        int desiredLength = this.idsOffset + this.positionCount + 1;
        int[] newIds = Arrays.copyOf(this.ids, desiredLength);
        Block newDictionary = this.dictionary;
        int nullIndex = -1;
        if (this.dictionary.mayHaveNull()) {
            int dictionaryPositionCount = this.dictionary.getPositionCount();
            for (int i = 0; i < dictionaryPositionCount; ++i) {
                if (!this.dictionary.isNull(i)) continue;
                nullIndex = i;
                break;
            }
        }
        if (nullIndex == -1) {
            newIds[this.idsOffset + this.positionCount] = this.dictionary.getPositionCount();
            newDictionary = this.dictionary.appendNull();
        } else {
            newIds[this.idsOffset + this.positionCount] = nullIndex;
        }
        return new DictionaryBlock(this.idsOffset, this.positionCount + 1, newDictionary, newIds, this.isCompact(), this.getDictionarySourceId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DictionaryBlock other = (DictionaryBlock)obj;
        return this.positionCount == other.positionCount && Objects.equals(this.dictionary, other.dictionary) && this.idsOffset == other.idsOffset && Arrays.equals(this.ids, other.ids) && this.retainedSizeInBytes == other.retainedSizeInBytes && this.sizeInBytes == other.sizeInBytes && this.logicalSizeInBytes == other.logicalSizeInBytes && this.uniqueIds == other.uniqueIds && Objects.equals(this.dictionarySourceId, other.dictionarySourceId);
    }

    public int hashCode() {
        return Objects.hash(this.positionCount, this.dictionary, this.idsOffset, Arrays.hashCode(this.ids), this.retainedSizeInBytes, this.sizeInBytes, this.logicalSizeInBytes, this.uniqueIds, this.dictionarySourceId);
    }
}

