/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.common.CatalogSchemaName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@ThriftStruct
@Immutable
public class QualifiedObjectName {
    private final String catalogName;
    private final String schemaName;
    private final String objectName;

    @JsonCreator
    public static QualifiedObjectName valueOf(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        String[] parts = name.split("\\.");
        if (parts.length != 3) {
            throw new IllegalArgumentException("QualifiedObjectName should have exactly 3 parts");
        }
        return new QualifiedObjectName(parts[0], parts[1], parts[2]);
    }

    public static QualifiedObjectName valueOf(CatalogSchemaName catalogSchemaName, String objectName) {
        return new QualifiedObjectName(catalogSchemaName.getCatalogName(), catalogSchemaName.getSchemaName(), objectName.toLowerCase(Locale.ENGLISH));
    }

    public static QualifiedObjectName valueOf(String catalogName, String schemaName, String objectName) {
        return new QualifiedObjectName(catalogName, schemaName, objectName.toLowerCase(Locale.ENGLISH));
    }

    @ThriftConstructor
    public QualifiedObjectName(String catalogName, String schemaName, String objectName) {
        QualifiedObjectName.checkLowerCase(catalogName, "catalogName");
        QualifiedObjectName.checkLowerCase(schemaName, "schemaName");
        QualifiedObjectName.checkLowerCase(objectName, "objectName");
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.objectName = objectName;
    }

    public CatalogSchemaName getCatalogSchemaName() {
        return new CatalogSchemaName(this.catalogName, this.schemaName);
    }

    @ThriftField(value=1)
    public String getCatalogName() {
        return this.catalogName;
    }

    @ThriftField(value=2)
    public String getSchemaName() {
        return this.schemaName;
    }

    @ThriftField(value=3)
    public String getObjectName() {
        return this.objectName;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QualifiedObjectName o = (QualifiedObjectName)obj;
        return Objects.equals(this.catalogName, o.catalogName) && Objects.equals(this.schemaName, o.schemaName) && Objects.equals(this.objectName, o.objectName);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.schemaName, this.objectName);
    }

    @JsonValue
    public String toString() {
        return this.catalogName + '.' + this.schemaName + '.' + this.objectName;
    }

    private static void checkLowerCase(String value, String name) {
        Objects.requireNonNull(value, String.format("%s is null", name));
        if (!value.equals(value.toLowerCase(Locale.ENGLISH))) {
            throw new IllegalArgumentException(String.format("%s is not lowercase: %s", name, value));
        }
    }
}

