/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.block.AbstractSingleRowBlock;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockBuilderStatus;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import java.util.OptionalInt;
import java.util.function.ObjLongConsumer;
import org.openjdk.jol.info.ClassLayout;

public class SingleRowBlockWriter
extends AbstractSingleRowBlock
implements BlockBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleRowBlockWriter.class).instanceSize();
    private final BlockBuilder[] fieldBlockBuilders;
    private boolean isEntryOpen;
    private int currentFieldIndexToWrite;
    private boolean fieldBlockBuilderReturned;

    SingleRowBlockWriter(int rowIndex, BlockBuilder[] fieldBlockBuilders) {
        super(rowIndex);
        this.fieldBlockBuilders = fieldBlockBuilders;
    }

    public BlockBuilder getFieldBlockBuilder(int fieldIndex) {
        if (this.currentFieldIndexToWrite != 0) {
            throw new IllegalStateException("field block builder can only be obtained before any sequential write has done");
        }
        this.fieldBlockBuilderReturned = true;
        return this.fieldBlockBuilders[fieldIndex];
    }

    @Override
    protected Block getRawFieldBlock(int fieldIndex) {
        return this.fieldBlockBuilders[fieldIndex];
    }

    @Override
    public long getSizeInBytes() {
        long size = 0L;
        if (this.rowIndex == 0) {
            for (BlockBuilder blockBuilder : this.fieldBlockBuilders) {
                size += blockBuilder.getSizeInBytes();
            }
            return size;
        }
        int endIndex = this.currentFieldIndexToWrite + (this.isEntryOpen ? 1 : 0);
        for (int i = 0; i < endIndex; ++i) {
            BlockBuilder builder = this.fieldBlockBuilders[i];
            size += builder.getSizeInBytes() - builder.getRegionSizeInBytes(0, this.rowIndex);
        }
        return size;
    }

    @Override
    public OptionalInt fixedSizeInBytesPerPosition() {
        return OptionalInt.empty();
    }

    @Override
    public long getRetainedSizeInBytes() {
        long size = INSTANCE_SIZE;
        for (BlockBuilder fieldBlockBuilder : this.fieldBlockBuilders) {
            size += fieldBlockBuilder.getRetainedSizeInBytes();
        }
        return size;
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        for (BlockBuilder fieldBlockBuilder : this.fieldBlockBuilders) {
            consumer.accept(fieldBlockBuilder, fieldBlockBuilder.getRetainedSizeInBytes());
        }
        consumer.accept(this, INSTANCE_SIZE);
    }

    @Override
    public BlockBuilder writeByte(int value) {
        this.checkFieldIndexToWrite();
        this.fieldBlockBuilders[this.currentFieldIndexToWrite].writeByte(value);
        return this;
    }

    @Override
    public BlockBuilder writeShort(int value) {
        this.checkFieldIndexToWrite();
        this.fieldBlockBuilders[this.currentFieldIndexToWrite].writeShort(value);
        return this;
    }

    @Override
    public BlockBuilder writeInt(int value) {
        this.checkFieldIndexToWrite();
        this.fieldBlockBuilders[this.currentFieldIndexToWrite].writeInt(value);
        return this;
    }

    @Override
    public BlockBuilder writeLong(long value) {
        this.checkFieldIndexToWrite();
        this.fieldBlockBuilders[this.currentFieldIndexToWrite].writeLong(value);
        return this;
    }

    @Override
    public BlockBuilder writeBytes(Slice source, int sourceIndex, int length) {
        this.checkFieldIndexToWrite();
        this.fieldBlockBuilders[this.currentFieldIndexToWrite].writeBytes(source, sourceIndex, length);
        return this;
    }

    @Override
    public BlockBuilder appendStructure(Block block) {
        this.checkFieldIndexToWrite();
        this.fieldBlockBuilders[this.currentFieldIndexToWrite].appendStructure(block);
        this.entryAdded();
        return this;
    }

    @Override
    public BlockBuilder appendStructureInternal(Block block, int position) {
        this.checkFieldIndexToWrite();
        this.fieldBlockBuilders[this.currentFieldIndexToWrite].appendStructureInternal(block, position);
        this.entryAdded();
        return this;
    }

    @Override
    public BlockBuilder beginBlockEntry() {
        this.checkFieldIndexToWrite();
        this.isEntryOpen = true;
        return this.fieldBlockBuilders[this.currentFieldIndexToWrite].beginBlockEntry();
    }

    @Override
    public BlockBuilder appendNull() {
        this.checkFieldIndexToWrite();
        this.fieldBlockBuilders[this.currentFieldIndexToWrite].appendNull();
        this.entryAdded();
        return this;
    }

    @Override
    public BlockBuilder closeEntry() {
        this.checkFieldIndexToWrite();
        this.fieldBlockBuilders[this.currentFieldIndexToWrite].closeEntry();
        this.entryAdded();
        return this;
    }

    @Override
    public BlockBuilder readPositionFrom(SliceInput input) {
        boolean isNull;
        boolean bl = isNull = input.readByte() == 0;
        if (isNull) {
            this.appendNull();
        } else {
            this.checkFieldIndexToWrite();
            this.fieldBlockBuilders[this.currentFieldIndexToWrite].readPositionFrom(input);
            this.entryAdded();
        }
        return this;
    }

    private void entryAdded() {
        this.isEntryOpen = false;
        ++this.currentFieldIndexToWrite;
    }

    @Override
    public int getPositionCount() {
        if (this.fieldBlockBuilderReturned) {
            throw new IllegalStateException("field block builder has been returned");
        }
        return this.currentFieldIndexToWrite;
    }

    @Override
    public String getEncodingName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block build() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        if (!this.fieldBlockBuilderReturned) {
            return String.format("SingleRowBlockWriter(%d){numFields=%d, fieldBlockBuilderReturned=false, positionCount=%d}", this.hashCode(), this.fieldBlockBuilders.length, this.getPositionCount());
        }
        return String.format("SingleRowBlockWriter(%d){numFields=%d, fieldBlockBuilderReturned=true}", this.hashCode(), this.fieldBlockBuilders.length);
    }

    private void checkFieldIndexToWrite() {
        if (this.fieldBlockBuilderReturned) {
            throw new IllegalStateException("cannot do sequential write after getFieldBlockBuilder is called");
        }
        if (this.currentFieldIndexToWrite >= this.fieldBlockBuilders.length) {
            throw new IllegalStateException("currentFieldIndexToWrite is not valid");
        }
    }
}

