/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.array;

import com.facebook.presto.common.array.AdaptiveLongBigArray;
import io.airlift.slice.SizeOf;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAdaptiveLongBigArray {
    @Test
    public void test() {
        AdaptiveLongBigArray array = new AdaptiveLongBigArray();
        array.ensureCapacity(0);
        Assert.assertEquals((long)array.getRetainedSizeInBytes(), (long)TestAdaptiveLongBigArray.expectedRetainedMemorySize(0, 0));
        array.ensureCapacity(1);
        array.set(0, -559038801L);
        Assert.assertEquals((long)array.get(0), (long)-559038801L);
        Assert.assertEquals((long)array.getRetainedSizeInBytes(), (long)TestAdaptiveLongBigArray.expectedRetainedMemorySize(1, 16384));
        array.ensureCapacity(16384);
        array.set(16383, -559038801L);
        Assert.assertEquals((long)array.get(16383), (long)-559038801L);
        Assert.assertEquals((long)array.getRetainedSizeInBytes(), (long)TestAdaptiveLongBigArray.expectedRetainedMemorySize(1, 16384));
        array.ensureCapacity(16385);
        array.set(16384, -559038801L);
        Assert.assertEquals((long)array.get(16384), (long)-559038801L);
        Assert.assertEquals((long)array.getRetainedSizeInBytes(), (long)TestAdaptiveLongBigArray.expectedRetainedMemorySize(1, 32768));
        array.ensureCapacity(32769);
        array.set(32768, -559038801L);
        Assert.assertEquals((long)array.get(32768), (long)-559038801L);
        Assert.assertEquals((long)array.getRetainedSizeInBytes(), (long)TestAdaptiveLongBigArray.expectedRetainedMemorySize(1, 65536));
        array.ensureCapacity(65537);
        array.set(65536, -559038801L);
        Assert.assertEquals((long)array.get(65536), (long)-559038801L);
        Assert.assertEquals((long)array.getRetainedSizeInBytes(), (long)TestAdaptiveLongBigArray.expectedRetainedMemorySize(1, 131072));
        array.ensureCapacity(0x2000000);
        array.set(0x1FFFFFF, -559038801L);
        Assert.assertEquals((long)array.get(0x1FFFFFF), (long)-559038801L);
        Assert.assertEquals((long)array.getRetainedSizeInBytes(), (long)TestAdaptiveLongBigArray.expectedRetainedMemorySize(1, 0x2000000));
        array.ensureCapacity(0x2000001);
        array.set(0x2000000, -559038801L);
        Assert.assertEquals((long)array.get(0x2000000), (long)-559038801L);
        Assert.assertEquals((long)array.getRetainedSizeInBytes(), (long)TestAdaptiveLongBigArray.expectedRetainedMemorySize(2, 0x2000000));
        array = new AdaptiveLongBigArray();
        array.ensureCapacity(0x2000001);
        array.set(65536, -1095770451L);
        Assert.assertEquals((long)array.get(65536), (long)-1095770451L);
        array.set(0x2000000, -559038801L);
        Assert.assertEquals((long)array.get(0x2000000), (long)-559038801L);
        Assert.assertEquals((long)array.getRetainedSizeInBytes(), (long)TestAdaptiveLongBigArray.expectedRetainedMemorySize(2, 0x2000000));
        array = new AdaptiveLongBigArray();
        array.ensureCapacity(33603585);
        array.set(0x200C000, -1095770451L);
        Assert.assertEquals((long)array.get(0x200C000), (long)-1095770451L);
        Assert.assertEquals((long)array.getRetainedSizeInBytes(), (long)TestAdaptiveLongBigArray.expectedRetainedMemorySize(2, 0x2000000));
        array = new AdaptiveLongBigArray();
        array.ensureCapacity(1);
        array.set(0, -559038801L);
        Assert.assertEquals((long)array.get(0), (long)-559038801L);
        Assert.assertEquals((long)array.getRetainedSizeInBytes(), (long)TestAdaptiveLongBigArray.expectedRetainedMemorySize(1, 16384));
        array.ensureCapacity(33603585);
        array.set(0x200C000, -1095770451L);
        Assert.assertEquals((long)array.get(0x200C000), (long)-1095770451L);
        array.set(16385, -559038801L);
        Assert.assertEquals((long)array.get(16385), (long)-559038801L);
        Assert.assertEquals((long)array.getRetainedSizeInBytes(), (long)TestAdaptiveLongBigArray.expectedRetainedMemorySize(2, 0x2000000));
    }

    @Test
    public void testSwap() {
        AdaptiveLongBigArray array = new AdaptiveLongBigArray();
        array.ensureCapacity(10);
        array.set(1, -559038801L);
        Assert.assertEquals((long)array.get(1), (long)-559038801L);
        array.set(9, -1095770451L);
        Assert.assertEquals((long)array.get(9), (long)-1095770451L);
        array.swap(1, 9);
        Assert.assertEquals((long)array.get(1), (long)-1095770451L);
        Assert.assertEquals((long)array.get(9), (long)-559038801L);
        array.ensureCapacity(0x2000001);
        array.set(1, -559038801L);
        Assert.assertEquals((long)array.get(1), (long)-559038801L);
        array.set(0x2000009, -1095770451L);
        Assert.assertEquals((long)array.get(0x2000009), (long)-1095770451L);
        array.swap(1, 0x2000009);
        Assert.assertEquals((long)array.get(1), (long)-1095770451L);
        Assert.assertEquals((long)array.get(0x2000009), (long)-559038801L);
    }

    private static long expectedRetainedMemorySize(int segments, int lastSegmentLength) {
        return (long)AdaptiveLongBigArray.INSTANCE_SIZE + SizeOf.sizeOfObjectArray((int)10) + (segments > 0 ? (long)(segments - 1) * AdaptiveLongBigArray.MAX_SEGMENT_SIZE_IN_BYTES + SizeOf.sizeOfLongArray((int)lastSegmentLength) : 0L);
    }
}

