/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.array;

import com.facebook.presto.common.array.BlockBigArray;
import com.facebook.presto.common.array.ObjectBigArray;
import com.facebook.presto.common.array.ReferenceCountMap;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.IntArrayBlockBuilder;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBlockBigArray {
    @Test
    public void testRetainedSizeWithOverlappingBlocks() {
        int entries = 123;
        IntArrayBlockBuilder blockBuilder = new IntArrayBlockBuilder(null, entries);
        for (int i = 0; i < entries; ++i) {
            blockBuilder.writeInt(i);
        }
        Block block = blockBuilder.build();
        int arraySize = 456;
        int blocks = 7890;
        BlockBigArray blockBigArray = new BlockBigArray();
        blockBigArray.ensureCapacity((long)arraySize);
        for (int i = 0; i < blocks; ++i) {
            blockBigArray.set((long)(i % arraySize), block.getRegion(0, entries));
        }
        ReferenceCountMap referenceCountMap = new ReferenceCountMap();
        referenceCountMap.incrementAndGet((Object)block);
        long expectedSize = (long)ClassLayout.parseClass(BlockBigArray.class).instanceSize() + referenceCountMap.sizeOf() + new ObjectBigArray().sizeOf() + block.getRetainedSizeInBytes() + (long)((arraySize - 1) * ClassLayout.parseClass(block.getClass()).instanceSize());
        Assert.assertEquals((long)blockBigArray.sizeOf(), (long)expectedSize);
    }
}

