/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.array;

import com.facebook.presto.common.array.ObjectBigArray;
import com.facebook.presto.common.array.ReferenceCountMap;
import com.facebook.presto.common.array.SliceBigArray;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestSliceBigArray {
    private static final long BIG_ARRAY_INSTANCE_SIZE = (long)ClassLayout.parseClass(SliceBigArray.class).instanceSize() + new ReferenceCountMap().sizeOf() + new ObjectBigArray().sizeOf();
    private static final long SLICE_INSTANCE_SIZE = ClassLayout.parseClass(Slice.class).instanceSize();
    private static final int CAPACITY = 32;
    private final byte[] firstBytes = new byte[1234];
    private final byte[] secondBytes = new byte[4567];
    private SliceBigArray sliceBigArray;

    @BeforeMethod
    public void setup() {
        this.sliceBigArray = new SliceBigArray();
        this.sliceBigArray.ensureCapacity(32L);
    }

    @Test
    public void testSameSliceRetainedSize() {
        Slice slice = Slices.wrappedBuffer((byte[])this.secondBytes, (int)201, (int)1501);
        for (int i = 0; i < 32; ++i) {
            this.sliceBigArray.set((long)i, slice);
            Assert.assertEquals((long)this.sliceBigArray.sizeOf(), (long)(BIG_ARRAY_INSTANCE_SIZE + SizeOf.sizeOf((byte[])this.secondBytes) + SLICE_INSTANCE_SIZE));
        }
        slice = Slices.wrappedBuffer((byte[])this.secondBytes, (int)201, (int)1501);
        this.sliceBigArray.set(3L, slice);
        Assert.assertEquals((long)this.sliceBigArray.sizeOf(), (long)(BIG_ARRAY_INSTANCE_SIZE + SizeOf.sizeOf((byte[])this.secondBytes) + SLICE_INSTANCE_SIZE * 2L));
    }

    @Test
    public void testNullSlicesRetainedSize() {
        this.sliceBigArray.set(0L, null);
        Assert.assertEquals((long)this.sliceBigArray.sizeOf(), (long)BIG_ARRAY_INSTANCE_SIZE);
        this.sliceBigArray.set(0L, Slices.wrappedBuffer((byte[])this.secondBytes, (int)201, (int)1501));
        Assert.assertEquals((long)this.sliceBigArray.sizeOf(), (long)(BIG_ARRAY_INSTANCE_SIZE + SizeOf.sizeOf((byte[])this.secondBytes) + SLICE_INSTANCE_SIZE));
        this.sliceBigArray.set(1L, Slices.wrappedBuffer((byte[])this.secondBytes, (int)201, (int)1501));
        Assert.assertEquals((long)this.sliceBigArray.sizeOf(), (long)(BIG_ARRAY_INSTANCE_SIZE + SizeOf.sizeOf((byte[])this.secondBytes) + SLICE_INSTANCE_SIZE * 2L));
        this.sliceBigArray.set(1L, null);
        Assert.assertEquals((long)this.sliceBigArray.sizeOf(), (long)(BIG_ARRAY_INSTANCE_SIZE + SizeOf.sizeOf((byte[])this.secondBytes) + SLICE_INSTANCE_SIZE));
    }

    @Test
    public void testRetainedSize() {
        this.sliceBigArray.set(0L, Slices.wrappedBuffer((byte[])this.firstBytes, (int)0, (int)100));
        this.sliceBigArray.set(1L, Slices.wrappedBuffer((byte[])this.secondBytes, (int)0, (int)100));
        Assert.assertEquals((long)this.sliceBigArray.sizeOf(), (long)(BIG_ARRAY_INSTANCE_SIZE + SizeOf.sizeOf((byte[])this.firstBytes) + SizeOf.sizeOf((byte[])this.secondBytes) + SLICE_INSTANCE_SIZE * 2L));
        this.sliceBigArray.set(2L, Slices.wrappedBuffer((byte[])this.firstBytes, (int)100, (int)200));
        this.sliceBigArray.set(3L, Slices.wrappedBuffer((byte[])this.secondBytes, (int)20, (int)150));
        Assert.assertEquals((long)this.sliceBigArray.sizeOf(), (long)(BIG_ARRAY_INSTANCE_SIZE + SizeOf.sizeOf((byte[])this.firstBytes) + SizeOf.sizeOf((byte[])this.secondBytes) + SLICE_INSTANCE_SIZE * 4L));
        this.sliceBigArray.set(2L, Slices.wrappedBuffer((byte[])this.firstBytes, (int)11, (int)1200));
        this.sliceBigArray.set(3L, Slices.wrappedBuffer((byte[])this.secondBytes, (int)201, (int)1501));
        Assert.assertEquals((long)this.sliceBigArray.sizeOf(), (long)(BIG_ARRAY_INSTANCE_SIZE + SizeOf.sizeOf((byte[])this.firstBytes) + SizeOf.sizeOf((byte[])this.secondBytes) + SLICE_INSTANCE_SIZE * 4L));
        this.sliceBigArray.set(0L, Slices.wrappedBuffer((byte[])this.secondBytes, (int)11, (int)1200));
        this.sliceBigArray.set(2L, Slices.wrappedBuffer((byte[])this.secondBytes, (int)201, (int)1501));
        Assert.assertEquals((long)this.sliceBigArray.sizeOf(), (long)(BIG_ARRAY_INSTANCE_SIZE + SizeOf.sizeOf((byte[])this.secondBytes) + SLICE_INSTANCE_SIZE * 4L));
    }
}

