/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=3)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkComputePosition {
    private int hashTableSize = ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE);
    private long hashcode = ThreadLocalRandom.current().nextLong();

    @Benchmark
    public long computePositionWithFloorMod() {
        return Math.floorMod(this.hashcode, (long)this.hashTableSize);
    }

    @Benchmark
    public long computePositionWithMod() {
        return (int)(this.hashcode & Long.MAX_VALUE) % this.hashTableSize;
    }

    @Benchmark
    public long computePositionWithMask() {
        return (int)this.hashcode & this.hashTableSize - 1;
    }

    @Benchmark
    public long computePositionWithBitShifting() {
        return (int)(Integer.toUnsignedLong(Long.hashCode(this.hashcode)) * (long)this.hashTableSize >> 32);
    }

    @Benchmark
    public long computePositionWithDivision() {
        return (int)(Integer.toUnsignedLong(Long.hashCode(this.hashcode)) * (long)this.hashTableSize / 1L);
    }

    public static void main(String[] args) throws Throwable {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkComputePosition.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }
}

