/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.block.ArrayAllocator;

public class CountingArrayAllocator
implements ArrayAllocator {
    private int borrowedIntArrays;
    private int borrowedByteArrays;

    public int[] borrowIntArray(int positionCount) {
        ++this.borrowedIntArrays;
        return new int[positionCount];
    }

    public void returnArray(int[] array) {
        --this.borrowedIntArrays;
    }

    public byte[] borrowByteArray(int positionCount) {
        ++this.borrowedByteArrays;
        return new byte[positionCount];
    }

    public void returnArray(byte[] array) {
        --this.borrowedByteArrays;
    }

    public int getBorrowedArrayCount() {
        return this.borrowedIntArrays + this.borrowedByteArrays;
    }

    public long getEstimatedSizeInBytes() {
        return 0L;
    }
}

