/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockLease;
import com.facebook.presto.common.block.ClosingBlockLease;
import com.facebook.presto.common.block.CountingArrayAllocator;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestClosingBlockLease {
    private final Block dummyBlock = RunLengthEncodedBlock.create((Type)BigintType.BIGINT, (Object)1L, (int)100);

    @Test
    public void testArrayAllocations() {
        CountingArrayAllocator allocator = new CountingArrayAllocator();
        Assert.assertEquals((int)allocator.getBorrowedArrayCount(), (int)0);
        int[] array = allocator.borrowIntArray(1);
        try (BlockLease ignored = ClosingBlockLease.newLease((Block)this.dummyBlock, (ClosingBlockLease.Closer[])new ClosingBlockLease.Closer[]{() -> allocator.returnArray(array)});){
            Assert.assertEquals((int)allocator.getBorrowedArrayCount(), (int)1);
        }
        Assert.assertEquals((int)allocator.getBorrowedArrayCount(), (int)0);
    }

    @Test
    public void testArrayOverReturn() {
        CountingArrayAllocator allocator = new CountingArrayAllocator();
        Assert.assertEquals((int)allocator.getBorrowedArrayCount(), (int)0);
        int[] array = allocator.borrowIntArray(1);
        BlockLease lease = ClosingBlockLease.newLease((Block)this.dummyBlock, (ClosingBlockLease.Closer[])new ClosingBlockLease.Closer[]{() -> allocator.returnArray(array)});
        Assert.assertEquals((int)allocator.getBorrowedArrayCount(), (int)1);
        lease.close();
        Assert.assertEquals((int)allocator.getBorrowedArrayCount(), (int)0);
        lease.close();
        Assert.assertEquals((int)allocator.getBorrowedArrayCount(), (int)0);
    }

    @Test
    public void testClosingErrors() {
        BlockLease lease = ClosingBlockLease.newLease((Block)this.dummyBlock, (ClosingBlockLease.Closer[])new ClosingBlockLease.Closer[]{() -> {
            throw new IllegalStateException("1");
        }, () -> {
            throw new IllegalArgumentException("2");
        }, () -> {
            throw new StringIndexOutOfBoundsException("3");
        }});
        try {
            lease.close();
            Assert.fail((String)"expected RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertEquals(e.getCause().getClass(), IllegalStateException.class);
            Assert.assertEquals((int)e.getCause().getSuppressed().length, (int)2);
            Assert.assertEquals(e.getCause().getSuppressed()[0].getClass(), IllegalArgumentException.class);
            Assert.assertEquals(e.getCause().getSuppressed()[1].getClass(), StringIndexOutOfBoundsException.class);
        }
    }
}

