/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.MethodHandleUtil;
import com.facebook.presto.common.block.RowBlockBuilder;
import com.facebook.presto.common.block.SingleRowBlockWriter;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSingleRowBlockWriter {
    @Test
    public void testSizeInBytes() {
        MapType mapType = new MapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR, MethodHandleUtil.methodHandle(TestSingleRowBlockWriter.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestSingleRowBlockWriter.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]));
        ArrayType arrayType = new ArrayType((Type)DoubleType.DOUBLE);
        RowType.Field rowField = new RowType.Field(Optional.of("my_struct"), (Type)IntegerType.INTEGER);
        RowType rowType = RowType.from((List)ImmutableList.of((Object)rowField));
        ImmutableList fieldTypes = ImmutableList.of((Object)RealType.REAL, (Object)mapType, (Object)arrayType, (Object)rowType);
        RowBlockBuilder rowBlockBuilder = new RowBlockBuilder((List)fieldTypes, null, 1);
        for (int i = 0; i < 100; ++i) {
            SingleRowBlockWriter singleRowBlockWriter = rowBlockBuilder.beginBlockEntry();
            int expectedSize = 0;
            Assert.assertEquals((long)singleRowBlockWriter.getSizeInBytes(), (long)expectedSize, (String)("For Index: " + i));
            RealType.REAL.writeLong((BlockBuilder)singleRowBlockWriter, (long)i);
            Assert.assertEquals((long)singleRowBlockWriter.getSizeInBytes(), (long)(expectedSize += 5), (String)("For Index: " + i));
            BlockBuilder mapWriter = singleRowBlockWriter.beginBlockEntry();
            Assert.assertEquals((long)singleRowBlockWriter.getSizeInBytes(), (long)expectedSize, (String)("For Index: " + i));
            BigintType.BIGINT.writeLong(mapWriter, (long)(i * 2));
            VarcharType.VARCHAR.writeSlice(mapWriter, Slices.utf8Slice((String)"Value1"));
            Assert.assertEquals((long)singleRowBlockWriter.getSizeInBytes(), (long)(expectedSize += 28), (String)("For Index: " + i));
            BigintType.BIGINT.writeLong(mapWriter, (long)(i * 2 + 1));
            VarcharType.VARCHAR.writeSlice(mapWriter, Slices.utf8Slice((String)"Value2"));
            Assert.assertEquals((long)singleRowBlockWriter.getSizeInBytes(), (long)(expectedSize += 28), (String)("For Index: " + i));
            singleRowBlockWriter.closeEntry();
            Assert.assertEquals((long)singleRowBlockWriter.getSizeInBytes(), (long)(expectedSize += 5), (String)("For Index: " + i));
            BlockBuilder arrayWriter = singleRowBlockWriter.beginBlockEntry();
            Assert.assertEquals((long)singleRowBlockWriter.getSizeInBytes(), (long)expectedSize, (String)("For Index: " + i));
            DoubleType.DOUBLE.writeDouble(arrayWriter, (double)(i * 3));
            Assert.assertEquals((long)singleRowBlockWriter.getSizeInBytes(), (long)(expectedSize += 9), (String)("For Index: " + i));
            DoubleType.DOUBLE.writeDouble(arrayWriter, (double)(i * 3 + 1));
            Assert.assertEquals((long)singleRowBlockWriter.getSizeInBytes(), (long)(expectedSize += 9), (String)("For Index: " + i));
            singleRowBlockWriter.closeEntry();
            Assert.assertEquals((long)singleRowBlockWriter.getSizeInBytes(), (long)(expectedSize += 5), (String)("For Index: " + i));
            BlockBuilder rowWriter = singleRowBlockWriter.beginBlockEntry();
            Assert.assertEquals((long)singleRowBlockWriter.getSizeInBytes(), (long)expectedSize, (String)("For Index: " + i));
            rowWriter.appendNull();
            Assert.assertEquals((long)singleRowBlockWriter.getSizeInBytes(), (long)(expectedSize += 5), (String)("For Index: " + i));
            singleRowBlockWriter.closeEntry();
            Assert.assertEquals((long)singleRowBlockWriter.getSizeInBytes(), (long)(expectedSize += 5), (String)("For Index: " + i));
            rowBlockBuilder.closeEntry();
            Assert.assertEquals((long)singleRowBlockWriter.getSizeInBytes(), (long)expectedSize, (String)("For Index: " + i));
            rowBlockBuilder.appendNull();
        }
    }

    @Test
    public void testSizeInBytesForNulls() {
        MapType mapType = new MapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR, MethodHandleUtil.methodHandle(TestSingleRowBlockWriter.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestSingleRowBlockWriter.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]));
        ArrayType arrayType = new ArrayType((Type)DoubleType.DOUBLE);
        RowType.Field rowField = new RowType.Field(Optional.of("my_struct"), (Type)IntegerType.INTEGER);
        RowType rowType = RowType.from((List)ImmutableList.of((Object)rowField));
        ImmutableList fieldTypes = ImmutableList.of((Object)RealType.REAL, (Object)mapType, (Object)arrayType, (Object)rowType);
        RowBlockBuilder rowBlockBuilder = new RowBlockBuilder((List)fieldTypes, null, 1);
        for (int i = 0; i < 100; ++i) {
            SingleRowBlockWriter singleRowBlockWriter = rowBlockBuilder.beginBlockEntry();
            int expectedSize = 0;
            Assert.assertEquals((long)singleRowBlockWriter.getSizeInBytes(), (long)expectedSize);
            singleRowBlockWriter.appendNull();
            Assert.assertEquals((long)singleRowBlockWriter.getSizeInBytes(), (long)(expectedSize += 5), (String)("For Index: " + i));
            singleRowBlockWriter.appendNull();
            Assert.assertEquals((long)singleRowBlockWriter.getSizeInBytes(), (long)(expectedSize += 5), (String)("For Index: " + i));
            singleRowBlockWriter.appendNull();
            Assert.assertEquals((long)singleRowBlockWriter.getSizeInBytes(), (long)(expectedSize += 5), (String)("For Index: " + i));
            singleRowBlockWriter.appendNull();
            Assert.assertEquals((long)singleRowBlockWriter.getSizeInBytes(), (long)(expectedSize += 5), (String)("For Index: " + i));
            rowBlockBuilder.closeEntry();
            Assert.assertEquals((long)singleRowBlockWriter.getSizeInBytes(), (long)expectedSize, (String)("For Index: " + i));
            rowBlockBuilder.appendNull();
        }
    }

    public static void throwUnsupportedOperation() {
        throw new UnsupportedOperationException();
    }
}

