/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.TestingBlockEncodingSerde;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.util.Locale;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestVariableWidthBlockEncoding {
    public static final SqlFunctionProperties PROPERTIES = SqlFunctionProperties.builder().setTimeZoneKey(TimeZoneKey.UTC_KEY).setLegacyTimestamp(true).setSessionStartTime(0L).setSessionLocale(Locale.ENGLISH).setSessionUser("user").build();
    private final BlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde(new BlockEncoding[0]);

    @Test
    public void testRoundTrip() {
        BlockBuilder expectedBlockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 4);
        VarcharType.VARCHAR.writeString(expectedBlockBuilder, "alice");
        VarcharType.VARCHAR.writeString(expectedBlockBuilder, "bob");
        VarcharType.VARCHAR.writeString(expectedBlockBuilder, "charlie");
        VarcharType.VARCHAR.writeString(expectedBlockBuilder, "dave");
        Block expectedBlock = expectedBlockBuilder.build();
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1024);
        this.blockEncodingSerde.writeBlock((SliceOutput)sliceOutput, expectedBlock);
        Block actualBlock = this.blockEncodingSerde.readBlock((SliceInput)sliceOutput.slice().getInput());
        TestVariableWidthBlockEncoding.assertBlockEquals((Type)VarcharType.VARCHAR, actualBlock, expectedBlock);
    }

    private static void assertBlockEquals(Type type, Block actual, Block expected) {
        for (int position = 0; position < actual.getPositionCount(); ++position) {
            Assert.assertEquals((Object)type.getObjectValue(PROPERTIES, actual, position), (Object)type.getObjectValue(PROPERTIES, expected, position));
        }
    }
}

