/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.predicate;

import com.facebook.airlift.json.JsonObjectMapperProvider;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.TestingBlockEncodingSerde;
import com.facebook.presto.common.block.TestingBlockJsonSerde;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.predicate.Marker;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.TestingTypeDeserializer;
import com.facebook.presto.common.type.TestingTypeManager;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.airlift.slice.Slices;
import java.util.Locale;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRange {
    public static final SqlFunctionProperties PROPERTIES = SqlFunctionProperties.builder().setTimeZoneKey(TimeZoneKey.UTC_KEY).setLegacyTimestamp(true).setSessionStartTime(0L).setSessionLocale(Locale.ENGLISH).setSessionUser("user").build();
    private final ObjectMapper mapper;

    public TestRange() {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingBlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde(new BlockEncoding[0]);
        this.mapper = new JsonObjectMapperProvider().get().registerModule((Module)new SimpleModule().addDeserializer(Type.class, (JsonDeserializer)new TestingTypeDeserializer(typeManager)).addSerializer(Block.class, (JsonSerializer)new TestingBlockJsonSerde.Serializer(blockEncodingSerde)).addDeserializer(Block.class, (JsonDeserializer)new TestingBlockJsonSerde.Deserializer(blockEncodingSerde)));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMismatchedTypes() {
        new Range(Marker.exactly((Type)BigintType.BIGINT, (Object)1L), Marker.exactly((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvertedBounds() {
        new Range(Marker.exactly((Type)BigintType.BIGINT, (Object)1L), Marker.exactly((Type)BigintType.BIGINT, (Object)0L));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testLowerUnboundedOnly() {
        new Range(Marker.lowerUnbounded((Type)BigintType.BIGINT), Marker.lowerUnbounded((Type)BigintType.BIGINT));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testUpperUnboundedOnly() {
        new Range(Marker.upperUnbounded((Type)BigintType.BIGINT), Marker.upperUnbounded((Type)BigintType.BIGINT));
    }

    @Test
    public void testSingleValue() {
        Assert.assertTrue((boolean)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)1L, (boolean)true).isSingleValue());
        Assert.assertFalse((boolean)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)2L, (boolean)true).isSingleValue());
        Assert.assertTrue((boolean)Range.range((Type)DoubleType.DOUBLE, (Object)1.1, (boolean)true, (Object)1.1, (boolean)true).isSingleValue());
        Assert.assertTrue((boolean)Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a"), (boolean)true, (Object)Slices.utf8Slice((String)"a"), (boolean)true).isSingleValue());
        Assert.assertTrue((boolean)Range.range((Type)BooleanType.BOOLEAN, (Object)true, (boolean)true, (Object)true, (boolean)true).isSingleValue());
        Assert.assertFalse((boolean)Range.range((Type)BooleanType.BOOLEAN, (Object)false, (boolean)true, (Object)true, (boolean)true).isSingleValue());
    }

    @Test
    public void testAllRange() {
        Range range = Range.all((Type)BigintType.BIGINT);
        Assert.assertEquals((Object)range.getLow(), (Object)Marker.lowerUnbounded((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)range.getHigh(), (Object)Marker.upperUnbounded((Type)BigintType.BIGINT));
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertTrue((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), (Object)BigintType.BIGINT);
        Assert.assertTrue((boolean)range.includes(Marker.lowerUnbounded((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)range.includes(Marker.below((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertTrue((boolean)range.includes(Marker.above((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertTrue((boolean)range.includes(Marker.upperUnbounded((Type)BigintType.BIGINT)));
    }

    @Test
    public void testGreaterThanRange() {
        Range range = Range.greaterThan((Type)BigintType.BIGINT, (Object)1L);
        Assert.assertEquals((Object)range.getLow(), (Object)Marker.above((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertEquals((Object)range.getHigh(), (Object)Marker.upperUnbounded((Type)BigintType.BIGINT));
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), (Object)BigintType.BIGINT);
        Assert.assertFalse((boolean)range.includes(Marker.lowerUnbounded((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)2L)));
        Assert.assertTrue((boolean)range.includes(Marker.upperUnbounded((Type)BigintType.BIGINT)));
    }

    @Test
    public void testGreaterThanOrEqualRange() {
        Range range = Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)1L);
        Assert.assertEquals((Object)range.getLow(), (Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertEquals((Object)range.getHigh(), (Object)Marker.upperUnbounded((Type)BigintType.BIGINT));
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), (Object)BigintType.BIGINT);
        Assert.assertFalse((boolean)range.includes(Marker.lowerUnbounded((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)2L)));
        Assert.assertTrue((boolean)range.includes(Marker.upperUnbounded((Type)BigintType.BIGINT)));
    }

    @Test
    public void testLessThanRange() {
        Range range = Range.lessThan((Type)BigintType.BIGINT, (Object)1L);
        Assert.assertEquals((Object)range.getLow(), (Object)Marker.lowerUnbounded((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)range.getHigh(), (Object)Marker.below((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), (Object)BigintType.BIGINT);
        Assert.assertTrue((boolean)range.includes(Marker.lowerUnbounded((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertFalse((boolean)range.includes(Marker.upperUnbounded((Type)BigintType.BIGINT)));
    }

    @Test
    public void testLessThanOrEqualRange() {
        Range range = Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)1L);
        Assert.assertEquals((Object)range.getLow(), (Object)Marker.lowerUnbounded((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)range.getHigh(), (Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), (Object)BigintType.BIGINT);
        Assert.assertTrue((boolean)range.includes(Marker.lowerUnbounded((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)2L)));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertFalse((boolean)range.includes(Marker.upperUnbounded((Type)BigintType.BIGINT)));
    }

    @Test
    public void testEqualRange() {
        Range range = Range.equal((Type)BigintType.BIGINT, (Object)1L);
        Assert.assertEquals((Object)range.getLow(), (Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertEquals((Object)range.getHigh(), (Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertTrue((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), (Object)BigintType.BIGINT);
        Assert.assertFalse((boolean)range.includes(Marker.lowerUnbounded((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertFalse((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)2L)));
        Assert.assertFalse((boolean)range.includes(Marker.upperUnbounded((Type)BigintType.BIGINT)));
    }

    @Test
    public void testRange() {
        Range range = Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)2L, (boolean)true);
        Assert.assertEquals((Object)range.getLow(), (Object)Marker.above((Type)BigintType.BIGINT, (Object)0L));
        Assert.assertEquals((Object)range.getHigh(), (Object)Marker.exactly((Type)BigintType.BIGINT, (Object)2L));
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), (Object)BigintType.BIGINT);
        Assert.assertFalse((boolean)range.includes(Marker.lowerUnbounded((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertTrue((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)2L)));
        Assert.assertFalse((boolean)range.includes(Marker.exactly((Type)BigintType.BIGINT, (Object)3L)));
        Assert.assertFalse((boolean)range.includes(Marker.upperUnbounded((Type)BigintType.BIGINT)));
    }

    @Test
    public void testGetSingleValue() {
        Assert.assertEquals((Object)Range.equal((Type)BigintType.BIGINT, (Object)0L).getSingleValue(), (Object)0L);
        Assert.assertThrows(IllegalStateException.class, () -> Range.lessThan((Type)BigintType.BIGINT, (Object)0L).getSingleValue());
    }

    @Test
    public void testContains() {
        Assert.assertTrue((boolean)Range.all((Type)BigintType.BIGINT).contains(Range.all((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Range.all((Type)BigintType.BIGINT).contains(Range.equal((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertTrue((boolean)Range.all((Type)BigintType.BIGINT).contains(Range.greaterThan((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertTrue((boolean)Range.equal((Type)BigintType.BIGINT, (Object)0L).contains(Range.equal((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertFalse((boolean)Range.equal((Type)BigintType.BIGINT, (Object)0L).contains(Range.greaterThan((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertFalse((boolean)Range.equal((Type)BigintType.BIGINT, (Object)0L).contains(Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertFalse((boolean)Range.equal((Type)BigintType.BIGINT, (Object)0L).contains(Range.all((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L).contains(Range.greaterThan((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertTrue((boolean)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L).contains(Range.greaterThan((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertFalse((boolean)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L).contains(Range.lessThan((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertTrue((boolean)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)2L, (boolean)true).contains(Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)2L, (boolean)true)));
        Assert.assertFalse((boolean)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)2L, (boolean)true).contains(Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false)));
    }

    @Test
    public void testSpan() {
        Assert.assertEquals((Object)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L).span(Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)2L)), (Object)Range.all((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Range.greaterThan((Type)BigintType.BIGINT, (Object)2L).span(Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)0L)), (Object)Range.all((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).span(Range.equal((Type)BigintType.BIGINT, (Object)2L)), (Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false));
        Assert.assertEquals((Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).span(Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)false, (Object)10L, (boolean)false)), (Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)10L, (boolean)false));
        Assert.assertEquals((Object)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L).span(Range.equal((Type)BigintType.BIGINT, (Object)0L)), (Object)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L));
        Assert.assertEquals((Object)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L).span(Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)10L)), (Object)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertEquals((Object)Range.lessThan((Type)BigintType.BIGINT, (Object)1L).span(Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)1L)), (Object)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertEquals((Object)Range.all((Type)BigintType.BIGINT).span(Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)1L)), (Object)Range.all((Type)BigintType.BIGINT));
    }

    @Test
    public void testOverlaps() {
        Assert.assertTrue((boolean)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L).overlaps(Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)2L)));
        Assert.assertFalse((boolean)Range.greaterThan((Type)BigintType.BIGINT, (Object)2L).overlaps(Range.lessThan((Type)BigintType.BIGINT, (Object)2L)));
        Assert.assertTrue((boolean)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).overlaps(Range.equal((Type)BigintType.BIGINT, (Object)2L)));
        Assert.assertTrue((boolean)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).overlaps(Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)false, (Object)10L, (boolean)false)));
        Assert.assertFalse((boolean)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).overlaps(Range.range((Type)BigintType.BIGINT, (Object)3L, (boolean)true, (Object)10L, (boolean)false)));
        Assert.assertTrue((boolean)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)true).overlaps(Range.range((Type)BigintType.BIGINT, (Object)3L, (boolean)true, (Object)10L, (boolean)false)));
        Assert.assertTrue((boolean)Range.all((Type)BigintType.BIGINT).overlaps(Range.equal((Type)BigintType.BIGINT, (Object)Long.MAX_VALUE)));
    }

    @Test
    public void testIntersect() {
        Assert.assertEquals((Object)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L).intersect(Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)2L)), (Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)false, (Object)2L, (boolean)true));
        Assert.assertEquals((Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).intersect(Range.equal((Type)BigintType.BIGINT, (Object)2L)), (Object)Range.equal((Type)BigintType.BIGINT, (Object)2L));
        Assert.assertEquals((Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).intersect(Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)false, (Object)10L, (boolean)false)), (Object)Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)false, (Object)3L, (boolean)false));
        Assert.assertEquals((Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)true).intersect(Range.range((Type)BigintType.BIGINT, (Object)3L, (boolean)true, (Object)10L, (boolean)false)), (Object)Range.equal((Type)BigintType.BIGINT, (Object)3L));
        Assert.assertEquals((Object)Range.all((Type)BigintType.BIGINT).intersect(Range.equal((Type)BigintType.BIGINT, (Object)Long.MAX_VALUE)), (Object)Range.equal((Type)BigintType.BIGINT, (Object)Long.MAX_VALUE));
    }

    @Test
    public void testExceptionalIntersect() {
        Assert.assertThrows(IllegalArgumentException.class, () -> Range.greaterThan((Type)BigintType.BIGINT, (Object)2L).intersect(Range.lessThan((Type)BigintType.BIGINT, (Object)2L)));
        Assert.assertThrows(IllegalArgumentException.class, () -> Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).intersect(Range.range((Type)BigintType.BIGINT, (Object)3L, (boolean)true, (Object)10L, (boolean)false)));
    }

    @Test
    public void testJsonSerialization() throws Exception {
        Range range = Range.all((Type)BigintType.BIGINT);
        Assert.assertEquals((Object)range, (Object)this.mapper.readValue(this.mapper.writeValueAsString((Object)range), Range.class));
        range = Range.equal((Type)DoubleType.DOUBLE, (Object)0.123);
        Assert.assertEquals((Object)range, (Object)this.mapper.readValue(this.mapper.writeValueAsString((Object)range), Range.class));
        range = Range.greaterThan((Type)BigintType.BIGINT, (Object)0L);
        Assert.assertEquals((Object)range, (Object)this.mapper.readValue(this.mapper.writeValueAsString((Object)range), Range.class));
        range = Range.greaterThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"abc"));
        Assert.assertEquals((Object)range, (Object)this.mapper.readValue(this.mapper.writeValueAsString((Object)range), Range.class));
        range = Range.lessThan((Type)BigintType.BIGINT, (Object)Long.MAX_VALUE);
        Assert.assertEquals((Object)range, (Object)this.mapper.readValue(this.mapper.writeValueAsString((Object)range), Range.class));
        range = Range.lessThanOrEqual((Type)DoubleType.DOUBLE, (Object)Double.MAX_VALUE);
        Assert.assertEquals((Object)range, (Object)this.mapper.readValue(this.mapper.writeValueAsString((Object)range), Range.class));
    }

    @Test
    public void testToString() {
        Range range = Range.all((Type)VarcharType.VARCHAR);
        Assert.assertEquals((String)range.toString(PROPERTIES), (String)"(<min>, <max>)");
        range = Range.equal((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"some string"));
        Assert.assertEquals((String)range.toString(PROPERTIES), (String)"[\"some string\"]");
        range = Range.equal((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"here's a quote: \""));
        Assert.assertEquals((String)range.toString(PROPERTIES), (String)"[\"here's a quote: \\\"\"]");
        range = Range.equal((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)""));
        Assert.assertEquals((String)range.toString(PROPERTIES), (String)"[\"\"]");
        range = Range.greaterThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"string with \"quotes\" inside")).intersect(Range.lessThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"this string's quote is here -> \"")));
        Assert.assertEquals((String)range.toString(PROPERTIES), (String)"[\"string with \\\"quotes\\\" inside\", \"this string's quote is here -> \\\"\"]");
        range = Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"string with \"quotes\" inside")).intersect(Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"this string's quote is here -> \"")));
        Assert.assertEquals((String)range.toString(PROPERTIES), (String)"(\"string with \\\"quotes\\\" inside\", \"this string's quote is here -> \\\"\")");
        range = Range.equal((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"<min>"));
        Assert.assertEquals((String)range.toString(PROPERTIES), (String)"[\"<min>\"]");
        range = Range.equal((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"<max>"));
        Assert.assertEquals((String)range.toString(PROPERTIES), (String)"[\"<max>\"]");
        range = Range.equal((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"<min>, <max>"));
        Assert.assertEquals((String)range.toString(PROPERTIES), (String)"[\"<min>, <max>\"]");
        range = Range.greaterThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")).intersect(Range.lessThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b")));
        Assert.assertEquals((String)range.toString(PROPERTIES), (String)"[\"a\", \"b\"]");
        range = Range.equal((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a, b"));
        Assert.assertEquals((String)range.toString(PROPERTIES), (String)"[\"a, b\"]");
    }

    @Test
    public void testCanonicalize() throws Exception {
        this.assertSameRange(Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), false);
        this.assertSameRange(Range.equal((Type)BigintType.BIGINT, (Object)0L), Range.equal((Type)BigintType.BIGINT, (Object)0L), false);
        this.assertSameRange(Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)0L), Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)0L), false);
        this.assertSameRange(Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)2L, (boolean)false), Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)2L, (boolean)false), false);
        this.assertSameRange(Range.all((Type)VarcharType.VARCHAR), Range.all((Type)VarcharType.VARCHAR), false);
        this.assertDifferentRange(Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), Range.greaterThan((Type)BigintType.BIGINT, (Object)3L), false);
        this.assertDifferentRange(Range.equal((Type)BigintType.BIGINT, (Object)0L), Range.equal((Type)BigintType.BIGINT, (Object)1L), false);
        this.assertDifferentRange(Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)0L), Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)6L), false);
        this.assertDifferentRange(Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)2L, (boolean)false), Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)3L, (boolean)false), false);
        this.assertDifferentRange(Range.all((Type)VarcharType.VARCHAR), Range.all((Type)BigintType.BIGINT), false);
        this.assertDifferentRange(Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), Range.lessThan((Type)BigintType.BIGINT, (Object)0L), false);
        this.assertDifferentRange(Range.equal((Type)BigintType.BIGINT, (Object)0L), Range.equal((Type)BigintType.BIGINT, (Object)1L), false);
        this.assertDifferentRange(Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), false);
        this.assertDifferentRange(Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)2L, (boolean)false), Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)2L, (boolean)false), false);
        this.assertDifferentRange(Range.all((Type)VarcharType.VARCHAR), Range.all((Type)BigintType.BIGINT), false);
        this.assertSameRange(Range.equal((Type)BigintType.BIGINT, (Object)10L), Range.equal((Type)BigintType.BIGINT, (Object)3L), true);
        this.assertSameRange(Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)0L, (boolean)true), Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)1L, (boolean)true), true);
        this.assertDifferentRange(Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), Range.greaterThan((Type)BigintType.BIGINT, (Object)1L), true);
        this.assertDifferentRange(Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)1L), true);
        this.assertDifferentRange(Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)2L, (boolean)false), Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)3L, (boolean)false), true);
        this.assertDifferentRange(Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), Range.lessThan((Type)BigintType.BIGINT, (Object)0L), true);
        this.assertDifferentRange(Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), true);
        this.assertDifferentRange(Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)2L, (boolean)false), Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)2L, (boolean)true), true);
        this.assertDifferentRange(Range.all((Type)VarcharType.VARCHAR), Range.all((Type)BigintType.BIGINT), true);
    }

    private void assertSameRange(Range range1, Range range2, boolean removeSafeConstants) throws Exception {
        Assert.assertEquals((String)this.mapper.writeValueAsString((Object)range1.canonicalize(removeSafeConstants)), (String)this.mapper.writeValueAsString((Object)range2.canonicalize(removeSafeConstants)));
    }

    private void assertDifferentRange(Range range1, Range range2, boolean removeSafeConstants) throws Exception {
        Assert.assertNotEquals((Object)this.mapper.writeValueAsString((Object)range1.canonicalize(removeSafeConstants)), (Object)this.mapper.writeValueAsString((Object)range2.canonicalize(removeSafeConstants)));
    }
}

