/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.type;

import com.facebook.presto.common.type.BigintEnumType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.VarcharEnumType;
import java.util.HashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Fork(value=2)
@Warmup(iterations=5, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkTypeSignatureParsing {
    @Benchmark
    public void parseRowTypeSignature(BenchmarkData data) {
        TypeSignature.parseTypeSignature((String)data.signature);
    }

    @Benchmark
    public void parseRowTypeSignatureWithEnums(BenchmarkData data) {
        TypeSignature.parseTypeSignature((String)data.enumSignature);
    }

    @Benchmark
    public void parseBigVarcharEnumTypeSignature(BenchmarkData data) {
        TypeSignature.parseTypeSignature((String)data.bigVarcharEnumSignature);
    }

    @Benchmark
    public void parseBigLongEnumTypeSignature(BenchmarkData data) {
        TypeSignature.parseTypeSignature((String)data.bigLongEnumSignature);
    }

    public static void main(String[] args) throws Throwable {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkTypeSignatureParsing.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private String signature;
        private String enumSignature;
        private String bigVarcharEnumSignature;
        private String bigLongEnumSignature;

        private static String randomString() {
            String symbols = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_123456789@ .,+-!?";
            char[] chars = new char[15];
            for (int i = 0; i < 15; ++i) {
                chars[i] = symbols.charAt(ThreadLocalRandom.current().nextInt(symbols.length()));
            }
            return new String(chars);
        }

        private static Type bigVarcharEnumType() {
            HashMap<String, String> bigMap = new HashMap<String, String>();
            for (int i = 0; i < 35000; ++i) {
                bigMap.put(String.format("KEY_%d", i), String.format("VALUE_%d_%s", i, BenchmarkData.randomString()));
            }
            return new VarcharEnumType(new VarcharEnumType.VarcharEnumMap("test.enum.bigvarcharenum", bigMap));
        }

        private static Type bigLongEnumType() {
            HashMap<String, Long> bigMap = new HashMap<String, Long>();
            for (int i = 0; i < 35000; ++i) {
                bigMap.put(String.format("KEY_%d", i), ThreadLocalRandom.current().nextLong());
            }
            return new BigintEnumType(new BigintEnumType.LongEnumMap("test.enum.biglongenum", bigMap));
        }

        @Setup
        public void setup() throws Exception {
            this.signature = "array(row(field_20 varchar, field_139 row(field_112 row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_61 row(field_155 varchar), field_122 array(varchar), field_137 varchar, field_166 row(field_61 row(field_155 varchar), field_7 row(field_45 row(field_164 row(field_137 varchar, field_1 bigint, field_92 bigint)))), field_175 array(varchar), field_45 row(field_136 row(field_1 bigint, field_92 bigint), field_62 varchar, field_203 varchar), field_132 row(field_136 row(field_1 bigint, field_92 bigint), field_62 varchar, field_203 varchar)), field_7 row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_234 varchar, field_85 varchar, field_244 varchar, field_72 varchar, field_228 varchar, field_222 bigint, field_21 varchar, field_248 bigint, field_172 bigint, field_205 bigint, field_267 varchar), field_243 row(field_128 boolean), field_210 row(field_1 bigint, field_92 bigint), field_47 row(field_128 boolean, field_67 boolean), field_143 boolean), field_236 row(field_235 varchar, field_249 varchar, field_218 varchar, field_83 row(field_155 varchar)), field_90 bigint, field_92 bigint, field_200 varchar, field_91 bigint, field_97 row(field_11 varchar, field_231 bigint, field_39 array(row(field_1 bigint, field_92 bigint)), field_108 array(row(field_1 bigint, field_92 bigint)), field_230 varchar, field_262 row(field_92 bigint)), field_88 row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_246 row(field_155 varchar), field_7 row(field_234 varchar, field_85 varchar, field_244 varchar, field_72 varchar, field_248 bigint), field_122 array(varchar), field_137 varchar, field_166 row(field_246 row(field_155 varchar), field_7 row(field_234 varchar, field_85 varchar, field_244 varchar, field_72 varchar, field_248 bigint)), field_175 array(varchar)), field_40 row(field_174 varchar, field_66 array(varchar), field_217 array(varchar), field_44 array(row(field_20 varchar, field_1 bigint, field_92 bigint, field_122 array(varchar), field_145 row(field_20 varchar, field_1 bigint, field_92 bigint, field_175 array(varchar), field_166 row(field_7 row(field_234 varchar, field_85 varchar, field_244 varchar, field_72 varchar, field_21 varchar, field_248 bigint, field_172 bigint, field_205 bigint, field_222 bigint), field_61 row(field_155 varchar))), field_260 row(field_233 boolean, field_119 boolean, field_57 bigint, field_162 bigint, field_14 boolean, field_4 double, field_37 double))), field_163 array(row(field_49 varchar, field_117 array(varchar), field_92 bigint)), field_133 array(row(field_268 row(field_92 bigint, field_23 row(field_33 varchar)))), field_111 array(row(field_92 bigint, field_235 varchar)), field_73 bigint), field_137 varchar, field_63 row(field_92 bigint, field_8 varchar, field_153 varchar, field_90 bigint, field_195 bigint, field_265 row(field_68 row(field_1 bigint, field_92 bigint, field_50 varchar, field_137 varchar, field_175 array(varchar)), field_92 bigint, field_90 bigint, field_195 bigint)), field_159 row(field_92 bigint, field_206 double, field_123 double, field_235 varchar), field_259 row(field_190 varchar, field_92 bigint, field_183 boolean), field_180 varchar, field_252 boolean, field_102 row(field_36 varchar, field_184 varchar, field_92 bigint, field_179 varchar, field_9 varchar), field_176 row(field_30 varchar, field_148 bigint, field_2 varchar), field_177 array(row(field_139 row(field_112 row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_61 row(field_155 varchar), field_122 array(varchar), field_137 varchar, field_166 row(field_61 row(field_155 varchar), field_7 row(field_45 row(field_164 row(field_137 varchar, field_1 bigint, field_92 bigint)))), field_175 array(varchar), field_45 row(field_136 row(field_1 bigint, field_92 bigint), field_62 varchar, field_203 varchar), field_132 row(field_136 row(field_1 bigint, field_92 bigint), field_62 varchar, field_203 varchar)), field_7 row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_234 varchar, field_85 varchar, field_244 varchar, field_72 varchar, field_228 varchar, field_222 bigint, field_21 varchar, field_248 bigint, field_172 bigint, field_205 bigint), field_243 row(field_128 boolean), field_210 row(field_1 bigint, field_92 bigint), field_47 row(field_128 boolean, field_67 boolean), field_143 boolean), field_92 bigint, field_137 varchar, field_63 row(field_92 bigint, field_8 varchar, field_153 varchar, field_90 bigint, field_195 bigint, field_265 row(field_68 row(field_1 bigint, field_92 bigint, field_50 varchar, field_137 varchar, field_175 array(varchar)), field_92 bigint, field_90 bigint, field_195 bigint)), field_51 varchar, field_24 array(row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_122 array(varchar), field_145 row(field_20 varchar, field_137 varchar, field_1 bigint, field_92 bigint, field_175 array(varchar), field_166 row(field_7 row(field_234 varchar, field_85 varchar, field_244 varchar, field_72 varchar, field_21 varchar, field_248 bigint, field_172 bigint, field_205 bigint, field_222 bigint), field_61 row(field_155 varchar))), field_260 row(field_233 boolean, field_119 boolean, field_57 bigint, field_162 bigint, field_14 boolean, field_4 double, field_37 double))), field_118 bigint, field_138 boolean, field_186 varchar, field_52 bigint, field_241 boolean, field_198 row(field_149 varchar), field_169 array(row(field_125 varchar, field_92 bigint)), field_157 row(field_92 bigint, field_206 double, field_123 double, field_235 varchar), field_164 varchar, field_31 row(field_92 bigint, field_214 bigint, field_229 row(field_92 bigint), field_167 bigint), field_93 array(row(field_40 row(field_174 varchar), field_251 row(field_92 bigint, field_268 row(field_23 row(field_33 varchar, field_92 bigint, field_235 varchar), field_92 bigint, field_9 varchar)))), field_261 row(field_140 varchar, field_79 array(row(field_92 bigint, field_235 varchar, field_131 double))), field_144 row(field_253 bigint), field_170 varchar, field_258 varchar, field_237 array(row(field_58 double, field_76 double, field_69 varchar)), field_25 row(field_235 varchar, field_9 varchar, field_219 varchar, field_105 bigint), field_141 row(field_235 varchar, field_9 varchar, field_219 varchar), field_6 array(row(field_235 varchar, field_9 varchar, field_219 varchar, field_105 bigint)))), field_22 row(field_41 row(field_20 varchar, field_139 row(field_112 row(field_20 varchar, field_1 bigint, field_92 bigint, field_122 array(varchar), field_50 varchar, field_61 row(field_155 varchar), field_137 varchar, field_166 row(field_61 row(field_155 varchar), field_7 row(field_45 row(field_164 row(field_137 varchar, field_1 bigint, field_92 bigint)))), field_175 array(varchar), field_45 row(field_136 row(field_1 bigint, field_92 bigint), field_62 varchar, field_203 varchar), field_132 row(field_136 row(field_1 bigint, field_92 bigint), field_62 varchar, field_203 varchar)), field_7 row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_234 varchar, field_85 varchar, field_244 varchar, field_72 varchar, field_228 varchar, field_222 bigint, field_21 varchar, field_248 bigint, field_172 bigint, field_205 bigint), field_243 row(field_128 boolean), field_210 row(field_1 bigint, field_92 bigint), field_47 row(field_128 boolean, field_67 boolean), field_143 boolean), field_92 bigint, field_263 row(field_118 bigint, field_186 varchar, field_52 bigint, field_169 array(row(field_125 varchar, field_92 bigint))), field_40 row(field_174 varchar, field_66 array(varchar), field_217 array(varchar), field_163 array(row(field_49 varchar, field_117 array(varchar), field_92 bigint)), field_111 array(row(field_92 bigint, field_235 varchar)), field_73 bigint), field_202 row(field_177 array(row(field_92 bigint, field_137 varchar, field_51 varchar, field_118 bigint, field_138 boolean, field_186 varchar, field_52 bigint, field_241 boolean, field_169 array(row(field_125 varchar, field_92 bigint)))), field_192 row(field_211 boolean, field_251 row(field_35 varchar, field_92 bigint, field_110 row(field_33 varchar, field_235 varchar, field_92 bigint))), field_158 array(row(field_92 bigint, field_137 varchar, field_51 varchar, field_208 boolean, field_95 varchar, field_94 varchar, field_42 double, field_169 array(row(field_125 varchar, field_92 bigint)))), field_38 varchar), field_88 row(field_20 varchar, field_1 bigint, field_92 bigint, field_122 array(varchar), field_175 array(varchar)), field_90 bigint, field_99 array(row(field_92 bigint, field_54 varchar, field_204 row(field_113 row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_122 array(varchar))), field_12 row(field_86 array(varchar), field_264 varchar), field_225 row(field_100 varchar), field_166 row(field_225 row(field_100 varchar), field_204 row(field_113 row(field_20 varchar, field_137 varchar, field_1 bigint, field_92 bigint, field_175 array(varchar))), field_12 row(field_26 row(field_86 array(row(field_220 varchar)), field_264 row(field_174 varchar))), field_227 row(field_254 row(field_92 bigint, field_206 double, field_123 double, field_235 varchar)), field_216 row(field_182 bigint, field_86 array(row(field_40 varchar)), field_264 varchar), field_81 row(field_176 row(field_30 varchar, field_148 bigint, field_2 varchar)), field_10 row(field_168 varchar), field_247 row(field_19 bigint), field_232 row(field_8 row(field_174 varchar)), field_250 row(field_212 varchar)), field_40 row(field_174 varchar))), field_166 row(field_263 row(field_118 bigint, field_52 bigint, field_169 array(row(field_125 varchar, field_92 bigint)), field_186 varchar), field_202 row(field_177 array(row(field_137 varchar, field_92 bigint, field_51 varchar, field_118 bigint, field_52 bigint, field_169 array(row(field_125 varchar, field_92 bigint)), field_138 boolean, field_186 varchar, field_241 boolean, field_31 row(field_229 row(field_92 bigint)))), field_192 row(field_211 boolean, field_251 row(field_92 bigint, field_268 row(field_23 row(field_33 varchar, field_92 bigint, field_235 varchar), field_9 varchar, field_92 bigint))), field_158 array(row(field_137 varchar, field_92 bigint, field_51 varchar, field_169 array(row(field_125 varchar, field_92 bigint)), field_208 boolean, field_95 varchar, field_94 varchar, field_42 double, field_31 row(field_229 row(field_92 bigint)), field_90 bigint, field_195 bigint, field_97 row(field_11 varchar, field_231 bigint, field_230 varchar, field_262 row(field_92 bigint)), field_191 varchar, field_5 bigint, field_8 varchar, field_194 row(field_213 boolean))), field_38 varchar)), field_185 row(field_92 bigint, field_113 row(field_20 varchar, field_1 bigint, field_92 bigint, field_175 array(varchar)), field_27 row(field_92 bigint)), field_200 varchar, field_175 array(varchar)), field_48 row(field_20 varchar, field_139 row(field_112 row(field_20 varchar, field_1 bigint, field_92 bigint, field_122 array(varchar), field_50 varchar, field_61 row(field_155 varchar), field_137 varchar, field_166 row(field_61 row(field_155 varchar), field_7 row(field_45 row(field_164 row(field_137 varchar, field_1 bigint, field_92 bigint)))), field_175 array(varchar), field_45 row(field_136 row(field_1 bigint, field_92 bigint), field_62 varchar, field_203 varchar), field_132 row(field_136 row(field_1 bigint, field_92 bigint), field_62 varchar, field_203 varchar)), field_7 row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_234 varchar, field_85 varchar, field_244 varchar, field_72 varchar, field_228 varchar, field_222 bigint, field_21 varchar, field_248 bigint, field_172 bigint, field_205 bigint), field_243 row(field_128 boolean), field_210 row(field_1 bigint, field_92 bigint), field_47 row(field_128 boolean, field_67 boolean), field_143 boolean), field_92 bigint, field_263 row(field_118 bigint, field_186 varchar, field_52 bigint, field_169 array(row(field_125 varchar, field_92 bigint))), field_40 row(field_174 varchar, field_66 array(varchar), field_217 array(varchar), field_163 array(row(field_49 varchar, field_117 array(varchar), field_92 bigint)), field_111 array(row(field_92 bigint, field_235 varchar)), field_73 bigint), field_202 row(field_177 array(row(field_92 bigint, field_137 varchar, field_51 varchar, field_118 bigint, field_138 boolean, field_186 varchar, field_52 bigint, field_241 boolean, field_169 array(row(field_125 varchar, field_92 bigint)))), field_192 row(field_211 boolean, field_251 row(field_35 varchar, field_92 bigint, field_110 row(field_33 varchar, field_235 varchar, field_92 bigint))), field_158 array(row(field_92 bigint, field_137 varchar, field_51 varchar, field_208 boolean, field_95 varchar, field_94 varchar, field_42 double, field_169 array(row(field_125 varchar, field_92 bigint)))), field_38 varchar), field_88 row(field_20 varchar, field_1 bigint, field_92 bigint, field_122 array(varchar), field_175 array(varchar)), field_90 bigint, field_99 array(row(field_92 bigint, field_54 varchar, field_204 row(field_113 row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_122 array(varchar))), field_12 row(field_86 array(varchar), field_264 varchar), field_225 row(field_100 varchar), field_166 row(field_225 row(field_100 varchar), field_204 row(field_113 row(field_20 varchar, field_137 varchar, field_1 bigint, field_92 bigint, field_175 array(varchar))), field_12 row(field_26 row(field_86 array(row(field_220 varchar)), field_264 row(field_174 varchar))), field_227 row(field_254 row(field_92 bigint, field_206 double, field_123 double, field_235 varchar)), field_216 row(field_182 bigint, field_86 array(row(field_40 varchar)), field_264 varchar), field_81 row(field_176 row(field_30 varchar, field_148 bigint, field_2 varchar)), field_10 row(field_168 varchar), field_247 row(field_19 bigint), field_232 row(field_8 row(field_174 varchar)), field_250 row(field_212 varchar)), field_40 row(field_174 varchar))), field_166 row(field_263 row(field_118 bigint, field_52 bigint, field_169 array(row(field_125 varchar, field_92 bigint)), field_186 varchar), field_202 row(field_177 array(row(field_137 varchar, field_92 bigint, field_51 varchar, field_118 bigint, field_52 bigint, field_169 array(row(field_125 varchar, field_92 bigint)), field_138 boolean, field_186 varchar, field_241 boolean, field_31 row(field_229 row(field_92 bigint)))), field_192 row(field_211 boolean, field_251 row(field_92 bigint, field_268 row(field_23 row(field_33 varchar, field_92 bigint, field_235 varchar), field_9 varchar, field_92 bigint))), field_158 array(row(field_137 varchar, field_92 bigint, field_51 varchar, field_169 array(row(field_125 varchar, field_92 bigint)), field_208 boolean, field_95 varchar, field_94 varchar, field_42 double, field_31 row(field_229 row(field_92 bigint)), field_90 bigint, field_195 bigint, field_97 row(field_11 varchar, field_231 bigint, field_230 varchar, field_262 row(field_92 bigint)), field_191 varchar, field_5 bigint, field_8 varchar, field_194 row(field_213 boolean))), field_38 varchar)), field_185 row(field_92 bigint, field_113 row(field_20 varchar, field_1 bigint, field_92 bigint, field_175 array(varchar)), field_27 row(field_92 bigint)), field_200 varchar, field_175 array(varchar)), field_124 bigint, field_150 boolean), field_192 row(field_64 boolean, field_211 boolean, field_92 bigint, field_221 varchar, field_251 row(field_106 varchar, field_35 varchar, field_90 bigint, field_23 varchar, field_70 varchar, field_92 bigint, field_8 varchar, field_7 varchar, field_110 row(field_33 varchar, field_235 varchar, field_92 bigint), field_147 array(varchar), field_114 row(field_1 bigint, field_92 bigint), field_134 row(field_92 bigint, field_188 row(field_1 bigint, field_92 bigint)), field_121 varchar, field_165 bigint, field_256 varchar, field_268 row(field_106 varchar, field_77 array(varchar), field_89 bigint, field_23 row(field_33 varchar, field_92 bigint, field_235 varchar), field_134 row(field_92 bigint, field_188 row(field_1 bigint, field_92 bigint)), field_121 varchar, field_61 row(field_1 bigint, field_92 bigint), field_154 bigint, field_8 varchar, field_9 varchar, field_92 bigint)), field_178 varchar, field_8 varchar), field_209 bigint, field_158 array(row(field_139 row(field_112 row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_61 row(field_155 varchar), field_122 array(varchar), field_137 varchar, field_166 row(field_61 row(field_155 varchar), field_7 row(field_45 row(field_164 row(field_137 varchar, field_1 bigint, field_92 bigint)))), field_175 array(varchar)), field_7 row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_234 varchar, field_85 varchar, field_244 varchar, field_72 varchar, field_228 varchar, field_222 bigint, field_21 varchar, field_248 bigint, field_172 bigint, field_205 bigint)), field_92 bigint, field_137 varchar, field_63 row(field_92 bigint, field_8 varchar, field_153 varchar, field_90 bigint, field_195 bigint, field_265 row(field_68 row(field_1 bigint, field_92 bigint, field_50 varchar, field_137 varchar, field_175 array(varchar)), field_92 bigint, field_90 bigint, field_195 bigint)), field_51 varchar, field_24 array(row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_122 array(varchar), field_145 row(field_20 varchar, field_137 varchar, field_1 bigint, field_92 bigint, field_175 array(varchar), field_166 row(field_7 row(field_234 varchar, field_85 varchar, field_244 varchar, field_72 varchar, field_21 varchar, field_248 bigint, field_172 bigint, field_205 bigint, field_222 bigint), field_61 row(field_155 varchar))), field_260 row(field_233 boolean, field_119 boolean, field_57 bigint, field_162 bigint, field_14 boolean, field_4 double, field_37 double))), field_208 boolean, field_95 varchar, field_94 varchar, field_169 array(row(field_125 varchar, field_92 bigint)), field_157 row(field_92 bigint, field_206 double, field_123 double, field_235 varchar), field_164 varchar, field_80 row(field_92 bigint), field_93 array(row(field_40 row(field_174 varchar), field_251 row(field_92 bigint, field_268 row(field_23 row(field_33 varchar, field_92 bigint, field_235 varchar), field_92 bigint, field_9 varchar)))), field_31 row(field_92 bigint, field_214 bigint, field_229 row(field_92 bigint), field_167 bigint), field_90 bigint, field_195 bigint, field_97 row(field_11 varchar, field_231 bigint, field_39 array(row(field_1 bigint, field_92 bigint)), field_108 array(row(field_1 bigint, field_92 bigint)), field_230 varchar, field_262 row(field_92 bigint)), field_160 row(field_126 bigint, field_226 bigint), field_13 array(row(field_9 varchar)), field_118 bigint, field_52 bigint, field_138 boolean, field_78 bigint, field_42 double, field_194 row(field_92 bigint), field_115 row(field_32 array(row(field_82 bigint)), field_139 row(field_112 row(field_20 varchar, field_1 bigint, field_92 bigint, field_175 array(varchar), field_166 row(field_61 row(field_155 varchar, field_107 row(field_201 varchar, field_129 varchar))), field_137 varchar, field_45 row(field_136 row(field_1 bigint, field_92 bigint), field_62 varchar, field_203 varchar), field_132 row(field_136 row(field_1 bigint, field_92 bigint), field_62 varchar, field_203 varchar)), field_7 row(field_20 varchar, field_1 bigint, field_92 bigint, field_72 varchar, field_21 varchar, field_248 bigint, field_172 bigint, field_228 varchar), field_243 row(field_128 boolean), field_210 row(field_1 bigint, field_92 bigint), field_47 row(field_128 boolean, field_67 boolean), field_143 boolean), field_90 bigint, field_53 array(row(field_92 bigint)), field_92 bigint, field_245 boolean, field_16 boolean, field_121 varchar, field_199 row(field_92 bigint), field_193 row(field_171 varchar, field_71 varchar, field_15 varchar, field_92 bigint, field_3 varchar), field_236 row(field_235 varchar)), field_156 array(row(field_92 bigint)), field_191 varchar, field_84 boolean, field_5 bigint, field_239 varchar, field_8 varchar, field_261 row(field_140 varchar, field_79 array(row(field_92 bigint, field_235 varchar, field_131 double))), field_152 row(field_197 boolean, field_96 array(row(field_58 double, field_76 double, field_69 varchar, field_257 bigint))), field_144 row(field_181 bigint))), field_55 row(field_59 row(field_139 row(field_112 row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_61 row(field_155 varchar), field_122 array(varchar), field_137 varchar, field_166 row(field_61 row(field_155 varchar), field_7 row(field_45 row(field_164 row(field_137 varchar, field_1 bigint, field_92 bigint)))), field_175 array(varchar), field_45 row(field_136 row(field_1 bigint, field_92 bigint), field_62 varchar, field_203 varchar), field_132 row(field_136 row(field_1 bigint, field_92 bigint), field_62 varchar, field_203 varchar)), field_7 row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_234 varchar, field_85 varchar, field_244 varchar, field_72 varchar, field_228 varchar, field_222 bigint, field_21 varchar, field_248 bigint, field_172 bigint, field_205 bigint), field_243 row(field_128 boolean), field_210 row(field_1 bigint, field_92 bigint), field_47 row(field_128 boolean, field_67 boolean), field_143 boolean), field_92 bigint, field_95 varchar, field_169 array(row(field_125 varchar, field_92 bigint))), field_92 bigint, field_223 bigint), field_46 array(row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_122 array(varchar), field_145 row(field_20 varchar, field_137 varchar, field_1 bigint, field_92 bigint, field_175 array(varchar), field_166 row(field_7 row(field_234 varchar, field_85 varchar, field_244 varchar, field_72 varchar, field_21 varchar, field_248 bigint, field_172 bigint, field_205 bigint, field_222 bigint), field_61 row(field_155 varchar))), field_260 row(field_233 boolean, field_119 boolean, field_57 bigint, field_162 bigint, field_14 boolean, field_4 double, field_37 double))), field_109 boolean, field_99 array(row(field_92 bigint, field_54 varchar, field_204 row(field_113 row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_122 array(varchar))), field_12 row(field_86 array(varchar), field_264 varchar), field_225 row(field_100 varchar), field_166 row(field_225 row(field_100 varchar), field_204 row(field_113 row(field_20 varchar, field_137 varchar, field_1 bigint, field_92 bigint, field_175 array(varchar))), field_12 row(field_26 row(field_86 array(row(field_220 varchar)), field_264 row(field_174 varchar))), field_227 row(field_254 row(field_92 bigint, field_206 double, field_123 double, field_235 varchar)), field_216 row(field_182 bigint, field_86 array(row(field_40 varchar)), field_264 varchar), field_81 row(field_176 row(field_30 varchar, field_148 bigint, field_2 varchar)), field_10 row(field_168 varchar), field_247 row(field_19 bigint), field_232 row(field_8 row(field_174 varchar)), field_250 row(field_212 varchar)), field_40 row(field_174 varchar))), field_264 row(field_92 bigint, field_60 varchar), field_104 varchar, field_38 varchar, field_56 varchar, field_196 row(field_92 bigint), field_98 array(row(field_92 bigint, field_155 varchar)), field_120 bigint, field_27 row(field_92 bigint), field_18 row(field_161 boolean), field_130 row(field_92 bigint, field_38 varchar, field_27 row(field_92 bigint)), field_189 row(field_92 bigint, field_116 row(field_1 bigint, field_92 bigint, field_50 varchar, field_137 varchar), field_238 row(field_191 varchar, field_92 bigint, field_235 varchar, field_103 varchar)), field_113 row(field_20 varchar, field_137 varchar, field_1 bigint, field_92 bigint, field_166 row(field_246 row(field_155 varchar), field_7 row(field_234 varchar, field_85 varchar, field_244 varchar, field_72 varchar, field_248 bigint, field_21 varchar, field_172 bigint, field_205 bigint, field_222 bigint), field_146 row(field_74 bigint, field_142 bigint, field_242 bigint, field_155 varchar, field_97 row(field_9 varchar), field_89 bigint), field_61 row(field_74 bigint, field_127 boolean, field_155 varchar)), field_175 array(varchar)), field_26 array(row(field_92 bigint, field_60 varchar)), field_240 row(field_233 boolean, field_119 boolean, field_57 bigint, field_162 bigint, field_14 boolean, field_4 double, field_37 double), field_224 row(field_233 boolean, field_119 boolean, field_57 bigint, field_162 bigint, field_34 boolean, field_207 boolean, field_65 boolean, field_28 bigint), field_43 row(field_215 varchar, field_43 varchar), field_101 row(field_233 boolean, field_119 boolean, field_57 bigint, field_162 bigint, field_14 boolean, field_4 double, field_37 double), field_29 row(field_151 row(field_92 bigint, field_235 varchar), field_135 varchar, field_92 bigint), field_75 boolean))";
            this.enumSignature = "array(row(field_20 varcharenum(my_enum{\"a\": \"EA======\", \"c\": \"EI======\"}), field_139 row(field_112 row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_61 row(field_155 varchar), field_122 array(varchar), field_137 varchar, field_166 row(field_61 row(field_155 varchar), field_7 row(field_45 row(field_164 row(field_137 varchar, field_1 bigint, field_92 bigint)))), field_175 array(varcharenum(some_enum{\"a\": \"EI======\", \"c\": \"PV5XW===\"})), field_45 row(field_136 row(field_1 bigint, field_92 bigint), field_62 varchar, field_203 varchar), field_132 row(field_136 row(field_1 bigint, field_92 bigint), field_62 varchar, field_203 varchar)), field_7 row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_234 varcharenum(my_enum{\"a\": \"PV5XW===\", \"c\": \"EA======\"}), field_85 varchar, field_244 varchar, field_72 varchar, field_228 varchar, field_222 bigint, field_21 varchar, field_248 bigint, field_172 bigint, field_205 bigint, field_267 varchar), field_243 row(field_128 boolean), field_210 row(field_1 bigint, field_92 bigint), field_47 row(field_128 boolean, field_67 boolean), field_143 boolean), field_236 row(field_235 varchar, field_249 varchar, field_218 varchar, field_83 row(field_155 varchar)), field_90 bigint, field_92 bigint, field_200 varchar, field_91 bigint, field_97 row(field_11 varchar, field_231 bigint, field_39 array(row(field_1 bigint, field_92 bigint)), field_108 array(row(field_1 bigint, field_92 bigint)), field_230 varchar, field_262 row(field_92 bigint)), field_88 row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_246 row(field_155 varchar), field_7 row(field_234 varchar, field_85 varchar, field_244 varchar, field_72 varchar, field_248 bigint), field_122 array(varchar), field_137 varchar, field_166 row(field_246 row(field_155 varchar), field_7 row(field_234 varchar, field_85 varchar, field_244 varchar, field_72 varchar, field_248 bigint)), field_175 array(varchar)), field_40 row(field_174 varchar, field_66 array(varchar), field_217 array(varchar), field_44 array(row(field_20 varchar, field_1 bigint, field_92 bigint, field_122 array(varchar), field_145 row(field_20 varchar, field_1 bigint, field_92 bigint, field_175 array(varchar), field_166 row(field_7 row(field_234 varchar, field_85 varchar, field_244 varchar, field_72 varchar, field_21 varchar, field_248 bigint, field_172 bigint, field_205 bigint, field_222 bigint), field_61 row(field_155 varchar))), field_260 row(field_233 boolean, field_119 boolean, field_57 bigint, field_162 bigint, field_14 boolean, field_4 varcharenum(my_other_enum{\"a\": \"EA======\", \"c\": \"EI======\"}), field_37 double))), field_163 array(row(field_49 varchar, field_117 array(varchar), field_92 bigint)), field_133 array(row(field_268 row(field_92 bigint, field_23 row(field_33 varchar)))), field_111 array(row(field_92 bigint, field_235 varchar)), field_73 bigint), field_137 varchar, field_63 row(field_92 bigint, field_8 varchar, field_153 varchar, field_90 bigint, field_195 bigint, field_265 row(field_68 row(field_1 bigint, field_92 bigint, field_50 varchar, field_137 varchar, field_175 array(varchar)), field_92 bigint, field_90 bigint, field_195 bigint)), field_159 row(field_92 bigint, field_206 double, field_123 double, field_235 varchar), field_259 row(field_190 varchar, field_92 bigint, field_183 boolean), field_180 varchar, field_252 boolean, field_102 row(field_36 varchar, field_184 varchar, field_92 bigint, field_179 varchar, field_9 varchar), field_176 row(field_30 varchar, field_148 bigint, field_2 varchar), field_177 array(row(field_139 row(field_112 row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_61 row(field_155 varchar), field_122 array(varchar), field_137 varchar, field_166 row(field_61 row(field_155 varchar), field_7 row(field_45 row(field_164 row(field_137 varchar, field_1 bigint, field_92 bigint)))), field_175 array(varchar), field_45 row(field_136 row(field_1 bigint, field_92 bigint), field_62 varchar, field_203 varchar), field_132 row(field_136 row(field_1 bigint, field_92 bigint), field_62 varchar, field_203 varchar)), field_7 row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_234 varchar, field_85 varchar, field_244 varchar, field_72 varchar, field_228 varchar, field_222 bigint, field_21 varchar, field_248 bigint, field_172 bigint, field_205 bigint), field_243 row(field_128 boolean), field_210 row(field_1 bigint, field_92 bigint), field_47 row(field_128 boolean, field_67 boolean), field_143 boolean), field_92 bigint, field_137 varchar, field_63 row(field_92 bigint, field_8 varchar, field_153 varchar, field_90 bigint, field_195 bigint, field_265 row(field_68 row(field_1 bigint, field_92 bigint, field_50 varchar, field_137 varchar, field_175 array(varchar)), field_92 bigint, field_90 bigint, field_195 bigint)), field_51 varchar, field_24 array(row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_122 array(varchar), field_145 row(field_20 varchar, field_137 varchar, field_1 bigint, field_92 bigint, field_175 array(varchar), field_166 row(field_7 row(field_234 varchar, field_85 varchar, field_244 varchar, field_72 varchar, field_21 varchar, field_248 bigint, field_172 bigint, field_205 bigint, field_222 bigint), field_61 row(field_155 varchar))), field_260 row(field_233 boolean, field_119 boolean, field_57 bigint, field_162 bigint, field_14 boolean, field_4 double, field_37 double))), field_118 bigint, field_138 boolean, field_186 varchar, field_52 bigint, field_241 boolean, field_198 row(field_149 varchar), field_169 array(row(field_125 varchar, field_92 bigint)), field_157 row(field_92 bigint, field_206 double, field_123 double, field_235 varchar), field_164 varchar, field_31 row(field_92 bigint, field_214 bigint, field_229 row(field_92 bigint), field_167 bigint), field_93 array(row(field_40 row(field_174 varchar), field_251 row(field_92 bigint, field_268 row(field_23 row(field_33 varchar, field_92 bigint, field_235 varchar), field_92 bigint, field_9 varchar)))), field_261 row(field_140 varchar, field_79 array(row(field_92 bigint, field_235 varchar, field_131 double))), field_144 row(field_253 bigint), field_170 varchar, field_258 varchar, field_237 array(row(field_58 double, field_76 double, field_69 varchar)), field_25 row(field_235 varchar, field_9 varchar, field_219 varchar, field_105 bigint), field_141 row(field_235 varchar, field_9 varchar, field_219 varchar), field_6 array(row(field_235 varchar, field_9 varchar, field_219 varchar, field_105 bigint)))), field_22 row(field_41 row(field_20 varchar, field_139 row(field_112 row(field_20 varchar, field_1 bigint, field_92 bigint, field_122 array(varchar), field_50 varchar, field_61 row(field_155 varchar), field_137 varchar, field_166 row(field_61 row(field_155 varchar), field_7 row(field_45 row(field_164 row(field_137 varchar, field_1 bigint, field_92 bigint)))), field_175 array(varchar), field_45 row(field_136 row(field_1 bigint, field_92 bigint), field_62 varchar, field_203 varchar), field_132 row(field_136 row(field_1 bigint, field_92 bigint), field_62 varchar, field_203 varchar)), field_7 row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_234 varcharenum(my_enum{\"a\": \"EI======\", \"c\": \"EA======\"}), field_85 varchar, field_244 varchar, field_72 varchar, field_228 varchar, field_222 bigint, field_21 varchar, field_248 bigint, field_172 bigint, field_205 bigint), field_243 row(field_128 boolean), field_210 row(field_1 bigint, field_92 bigint), field_47 row(field_128 boolean, field_67 boolean), field_143 boolean), field_92 bigint, field_263 row(field_118 bigint, field_186 varchar, field_52 bigint, field_169 array(row(field_125 varchar, field_92 bigint))), field_40 row(field_174 varchar, field_66 array(varchar), field_217 array(varchar), field_163 array(row(field_49 varchar, field_117 array(varchar), field_92 bigint)), field_111 array(row(field_92 bigint, field_235 varchar)), field_73 bigint), field_202 row(field_177 array(row(field_92 bigint, field_137 varchar, field_51 varchar, field_118 bigint, field_138 boolean, field_186 varchar, field_52 bigint, field_241 boolean, field_169 array(row(field_125 varchar, field_92 bigint)))), field_192 row(field_211 boolean, field_251 row(field_35 varchar, field_92 bigint, field_110 row(field_33 varchar, field_235 varchar, field_92 bigint))), field_158 array(row(field_92 bigint, field_137 varchar, field_51 varchar, field_208 boolean, field_95 varchar, field_94 varchar, field_42 double, field_169 array(row(field_125 varchar, field_92 bigint)))), field_38 varchar), field_88 row(field_20 varchar, field_1 bigint, field_92 bigint, field_122 array(varchar), field_175 array(varchar)), field_90 bigint, field_99 array(row(field_92 bigint, field_54 varchar, field_204 row(field_113 row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_122 array(varchar))), field_12 row(field_86 array(varchar), field_264 varchar), field_225 row(field_100 varchar), field_166 row(field_225 row(field_100 varchar), field_204 row(field_113 row(field_20 varchar, field_137 varchar, field_1 bigint, field_92 bigint, field_175 array(varchar))), field_12 row(field_26 row(field_86 array(row(field_220 varchar)), field_264 row(field_174 varchar))), field_227 row(field_254 row(field_92 bigint, field_206 double, field_123 double, field_235 varchar)), field_216 row(field_182 bigint, field_86 array(row(field_40 varchar)), field_264 varchar), field_81 row(field_176 row(field_30 varchar, field_148 bigint, field_2 varchar)), field_10 row(field_168 varchar), field_247 row(field_19 bigint), field_232 row(field_8 row(field_174 varchar)), field_250 row(field_212 varchar)), field_40 row(field_174 varchar))), field_166 row(field_263 row(field_118 bigint, field_52 bigint, field_169 array(row(field_125 varchar, field_92 bigint)), field_186 varchar), field_202 row(field_177 array(row(field_137 varchar, field_92 bigint, field_51 varchar, field_118 bigint, field_52 bigint, field_169 array(row(field_125 varchar, field_92 bigint)), field_138 boolean, field_186 varchar, field_241 boolean, field_31 row(field_229 row(field_92 bigint)))), field_192 row(field_211 boolean, field_251 row(field_92 bigint, field_268 row(field_23 row(field_33 varchar, field_92 bigint, field_235 varchar), field_9 varchar, field_92 bigint))), field_158 array(row(field_137 varchar, field_92 bigint, field_51 varchar, field_169 array(row(field_125 varchar, field_92 bigint)), field_208 boolean, field_95 varchar, field_94 varchar, field_42 double, field_31 row(field_229 row(field_92 bigint)), field_90 bigint, field_195 bigint, field_97 row(field_11 varchar, field_231 bigint, field_230 varchar, field_262 row(field_92 bigint)), field_191 varchar, field_5 bigint, field_8 varchar, field_194 row(field_213 boolean))), field_38 varchar)), field_185 row(field_92 bigint, field_113 row(field_20 varchar, field_1 bigint, field_92 bigint, field_175 array(varchar)), field_27 row(field_92 bigint)), field_200 varchar, field_175 array(varchar)), field_48 row(field_20 varchar, field_139 row(field_112 row(field_20 varchar, field_1 bigint, field_92 bigint, field_122 array(varchar), field_50 varchar, field_61 row(field_155 varchar), field_137 varchar, field_166 row(field_61 row(field_155 varchar), field_7 row(field_45 row(field_164 row(field_137 varchar, field_1 bigint, field_92 bigint)))), field_175 array(varchar), field_45 row(field_136 row(field_1 bigint, field_92 bigint), field_62 varchar, field_203 varchar), field_132 row(field_136 row(field_1 bigint, field_92 bigint), field_62 varchar, field_203 varchar)), field_7 row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_234 varchar, field_85 varchar, field_244 varchar, field_72 varchar, field_228 varchar, field_222 bigint, field_21 varchar, field_248 bigint, field_172 bigint, field_205 bigint), field_243 row(field_128 boolean), field_210 row(field_1 bigint, field_92 bigint), field_47 row(field_128 boolean, field_67 boolean), field_143 boolean), field_92 bigint, field_263 row(field_118 bigint, field_186 varchar, field_52 bigint, field_169 array(row(field_125 varchar, field_92 bigint))), field_40 row(field_174 varchar, field_66 array(varchar), field_217 array(varchar), field_163 array(row(field_49 varchar, field_117 array(varchar), field_92 bigint)), field_111 array(row(field_92 bigint, field_235 varchar)), field_73 bigint), field_202 row(field_177 array(row(field_92 bigint, field_137 varchar, field_51 varchar, field_118 bigint, field_138 boolean, field_186 varchar, field_52 bigint, field_241 boolean, field_169 array(row(field_125 varchar, field_92 bigint)))), field_192 row(field_211 boolean, field_251 row(field_35 varchar, field_92 bigint, field_110 row(field_33 varchar, field_235 varchar, field_92 bigint))), field_158 array(row(field_92 bigint, field_137 varchar, field_51 varchar, field_208 boolean, field_95 varchar, field_94 varchar, field_42 double, field_169 array(row(field_125 varchar, field_92 bigint)))), field_38 varchar), field_88 row(field_20 varchar, field_1 bigint, field_92 bigint, field_122 array(varchar), field_175 array(varchar)), field_90 bigint, field_99 array(row(field_92 bigint, field_54 varchar, field_204 row(field_113 row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_122 array(varchar))), field_12 row(field_86 array(varchar), field_264 varchar), field_225 row(field_100 varchar), field_166 row(field_225 row(field_100 varchar), field_204 row(field_113 row(field_20 varchar, field_137 varchar, field_1 bigint, field_92 bigint, field_175 array(varchar))), field_12 row(field_26 row(field_86 array(row(field_220 varchar)), field_264 row(field_174 varchar))), field_227 row(field_254 row(field_92 bigint, field_206 double, field_123 double, field_235 varchar)), field_216 row(field_182 bigint, field_86 array(row(field_40 varchar)), field_264 varchar), field_81 row(field_176 row(field_30 varchar, field_148 bigint, field_2 varchar)), field_10 row(field_168 varchar), field_247 row(field_19 bigint), field_232 row(field_8 row(field_174 varchar)), field_250 row(field_212 varchar)), field_40 row(field_174 varchar))), field_166 row(field_263 row(field_118 bigint, field_52 bigint, field_169 array(row(field_125 varchar, field_92 bigint)), field_186 varchar), field_202 row(field_177 array(row(field_137 varchar, field_92 bigint, field_51 varchar, field_118 bigint, field_52 bigint, field_169 array(row(field_125 varchar, field_92 bigint)), field_138 boolean, field_186 varchar, field_241 boolean, field_31 row(field_229 row(field_92 bigint)))), field_192 row(field_211 boolean, field_251 row(field_92 bigint, field_268 row(field_23 row(field_33 varchar, field_92 bigint, field_235 varchar), field_9 varchar, field_92 bigint))), field_158 array(row(field_137 varchar, field_92 bigint, field_51 varchar, field_169 array(row(field_125 varchar, field_92 bigint)), field_208 boolean, field_95 varchar, field_94 varchar, field_42 double, field_31 row(field_229 row(field_92 bigint)), field_90 bigint, field_195 bigint, field_97 row(field_11 varchar, field_231 bigint, field_230 varchar, field_262 row(field_92 bigint)), field_191 varchar, field_5 bigint, field_8 varchar, field_194 row(field_213 boolean))), field_38 varchar)), field_185 row(field_92 bigint, field_113 row(field_20 varchar, field_1 bigint, field_92 bigint, field_175 array(varchar)), field_27 row(field_92 bigint)), field_200 varchar, field_175 array(varchar)), field_124 bigint, field_150 boolean), field_192 row(field_64 boolean, field_211 boolean, field_92 bigint, field_221 varchar, field_251 row(field_106 varchar, field_35 varchar, field_90 bigint, field_23 varchar, field_70 varchar, field_92 bigint, field_8 varchar, field_7 varchar, field_110 row(field_33 varchar, field_235 varchar, field_92 bigint), field_147 array(varchar), field_114 row(field_1 bigint, field_92 bigint), field_134 row(field_92 bigint, field_188 row(field_1 bigint, field_92 bigint)), field_121 varchar, field_165 bigint, field_256 varchar, field_268 row(field_106 varchar, field_77 array(varchar), field_89 bigint, field_23 row(field_33 varchar, field_92 bigint, field_235 varchar), field_134 row(field_92 bigint, field_188 row(field_1 bigint, field_92 bigint)), field_121 varchar, field_61 row(field_1 bigint, field_92 bigint), field_154 bigint, field_8 varchar, field_9 varchar, field_92 bigint)), field_178 varchar, field_8 varchar), field_209 bigint, field_158 array(row(field_139 row(field_112 row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_61 row(field_155 varchar), field_122 array(varchar), field_137 varchar, field_166 row(field_61 row(field_155 varchar), field_7 row(field_45 row(field_164 row(field_137 varchar, field_1 bigint, field_92 bigint)))), field_175 array(varchar)), field_7 row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_234 varchar, field_85 varchar, field_244 varchar, field_72 varchar, field_228 varchar, field_222 bigint, field_21 varchar, field_248 bigint, field_172 bigint, field_205 bigint)), field_92 bigint, field_137 varchar, field_63 row(field_92 bigint, field_8 varchar, field_153 varchar, field_90 bigint, field_195 bigint, field_265 row(field_68 row(field_1 bigint, field_92 bigint, field_50 varchar, field_137 varchar, field_175 array(varchar)), field_92 bigint, field_90 bigint, field_195 bigint)), field_51 varchar, field_24 array(row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_122 array(varchar), field_145 row(field_20 varchar, field_137 varchar, field_1 bigint, field_92 bigint, field_175 array(varchar), field_166 row(field_7 row(field_234 varchar, field_85 varchar, field_244 varchar, field_72 varchar, field_21 varchar, field_248 bigint, field_172 bigint, field_205 bigint, field_222 bigint), field_61 row(field_155 varchar))), field_260 row(field_233 boolean, field_119 boolean, field_57 bigint, field_162 bigint, field_14 boolean, field_4 double, field_37 double))), field_208 boolean, field_95 varchar, field_94 varchar, field_169 array(row(field_125 varchar, field_92 bigint)), field_157 row(field_92 bigint, field_206 double, field_123 double, field_235 varchar), field_164 varchar, field_80 row(field_92 bigint), field_93 array(row(field_40 row(field_174 varchar), field_251 row(field_92 bigint, field_268 row(field_23 row(field_33 varchar, field_92 bigint, field_235 varchar), field_92 bigint, field_9 varchar)))), field_31 row(field_92 bigint, field_214 bigint, field_229 row(field_92 bigint), field_167 bigint), field_90 bigint, field_195 bigint, field_97 row(field_11 varchar, field_231 bigint, field_39 array(row(field_1 bigint, field_92 bigint)), field_108 array(row(field_1 bigint, field_92 bigint)), field_230 varchar, field_262 row(field_92 bigint)), field_160 row(field_126 bigint, field_226 bigint), field_13 array(row(field_9 varchar)), field_118 bigint, field_52 bigint, field_138 boolean, field_78 bigint, field_42 double, field_194 row(field_92 bigint), field_115 row(field_32 array(row(field_82 bigint)), field_139 row(field_112 row(field_20 varchar, field_1 bigint, field_92 bigint, field_175 array(varchar), field_166 row(field_61 row(field_155 varchar, field_107 row(field_201 varchar, field_129 varchar))), field_137 varchar, field_45 row(field_136 row(field_1 bigint, field_92 bigint), field_62 varchar, field_203 varchar), field_132 row(field_136 row(field_1 bigint, field_92 bigint), field_62 varchar, field_203 varchar)), field_7 row(field_20 varchar, field_1 bigint, field_92 bigint, field_72 varchar, field_21 varchar, field_248 bigint, field_172 bigint, field_228 varchar), field_243 row(field_128 boolean), field_210 row(field_1 bigint, field_92 bigint), field_47 row(field_128 boolean, field_67 boolean), field_143 boolean), field_90 bigint, field_53 array(row(field_92 bigint)), field_92 bigint, field_245 boolean, field_16 boolean, field_121 varchar, field_199 row(field_92 bigint), field_193 row(field_171 varchar, field_71 varchar, field_15 varchar, field_92 bigint, field_3 varchar), field_236 row(field_235 varchar)), field_156 array(row(field_92 bigint)), field_191 varchar, field_84 boolean, field_5 bigint, field_239 varchar, field_8 varchar, field_261 row(field_140 varchar, field_79 array(row(field_92 bigint, field_235 varchar, field_131 double))), field_152 row(field_197 boolean, field_96 array(row(field_58 double, field_76 double, field_69 varchar, field_257 bigint))), field_144 row(field_181 bigint))), field_55 row(field_59 row(field_139 row(field_112 row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_61 row(field_155 varchar), field_122 array(varchar), field_137 varchar, field_166 row(field_61 row(field_155 varchar), field_7 row(field_45 row(field_164 row(field_137 varchar, field_1 bigint, field_92 bigint)))), field_175 array(varchar), field_45 row(field_136 row(field_1 bigint, field_92 bigint), field_62 varchar, field_203 varchar), field_132 row(field_136 row(field_1 bigint, field_92 bigint), field_62 varchar, field_203 varchar)), field_7 row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_234 varchar, field_85 varchar, field_244 varchar, field_72 varchar, field_228 varchar, field_222 bigint, field_21 varchar, field_248 bigint, field_172 bigint, field_205 bigint), field_243 row(field_128 boolean), field_210 row(field_1 bigint, field_92 bigint), field_47 row(field_128 boolean, field_67 boolean), field_143 boolean), field_92 bigint, field_95 varchar, field_169 array(row(field_125 varchar, field_92 bigint))), field_92 bigint, field_223 bigint), field_46 array(row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_122 array(varchar), field_145 row(field_20 varchar, field_137 varchar, field_1 bigint, field_92 bigint, field_175 array(varchar), field_166 row(field_7 row(field_234 varchar, field_85 varchar, field_244 varchar, field_72 varchar, field_21 varchar, field_248 bigint, field_172 bigint, field_205 bigint, field_222 bigint), field_61 row(field_155 varchar))), field_260 row(field_233 boolean, field_119 boolean, field_57 bigint, field_162 bigint, field_14 boolean, field_4 double, field_37 double))), field_109 boolean, field_99 array(row(field_92 bigint, field_54 varchar, field_204 row(field_113 row(field_20 varchar, field_1 bigint, field_92 bigint, field_50 varchar, field_122 array(varchar))), field_12 row(field_86 array(varchar), field_264 varchar), field_225 row(field_100 varchar), field_166 row(field_225 row(field_100 varchar), field_204 row(field_113 row(field_20 varchar, field_137 varchar, field_1 bigint, field_92 bigint, field_175 array(varchar))), field_12 row(field_26 row(field_86 array(row(field_220 varchar)), field_264 row(field_174 varchar))), field_227 row(field_254 row(field_92 bigint, field_206 double, field_123 double, field_235 varchar)), field_216 row(field_182 bigint, field_86 array(row(field_40 varchar)), field_264 varchar), field_81 row(field_176 row(field_30 varchar, field_148 bigint, field_2 varchar)), field_10 row(field_168 varchar), field_247 row(field_19 bigint), field_232 row(field_8 row(field_174 varchar)), field_250 row(field_212 varchar)), field_40 row(field_174 varchar))), field_264 row(field_92 bigint, field_60 varchar), field_104 varchar, field_38 varchar, field_56 varchar, field_196 row(field_92 bigint), field_98 array(row(field_92 bigint, field_155 varchar)), field_120 bigint, field_27 row(field_92 bigint), field_18 row(field_161 boolean), field_130 row(field_92 bigint, field_38 varchar, field_27 row(field_92 bigint)), field_189 row(field_92 bigint, field_116 row(field_1 bigint, field_92 bigint, field_50 varchar, field_137 varchar), field_238 row(field_191 varchar, field_92 bigint, field_235 varchar, field_103 varchar)), field_113 row(field_20 varchar, field_137 varchar, field_1 bigint, field_92 bigint, field_166 row(field_246 row(field_155 varchar), field_7 row(field_234 varchar, field_85 varchar, field_244 varchar, field_72 varchar, field_248 bigint, field_21 varchar, field_172 bigint, field_205 longenum(other_enum{\"a\":1, \"b\": 2}), field_222 bigint), field_146 row(field_74 bigint, field_142 bigint, field_242 bigint, field_155 varchar, field_97 row(field_9 varchar), field_89 bigint), field_61 row(field_74 bigint, field_127 boolean, field_155 varchar)), field_175 array(varchar)), field_26 array(row(field_92 bigint, field_60 varchar)), field_240 row(field_233 boolean, field_119 boolean, field_57 bigint, field_162 bigint, field_14 boolean, field_4 double, field_37 double), field_224 row(field_233 boolean, field_119 boolean, field_57 bigint, field_162 bigint, field_34 boolean, field_207 boolean, field_65 boolean, field_28 bigint), field_43 row(field_215 varchar, field_43 varchar), field_101 row(field_233 boolean, field_119 boolean, field_57 bigint, field_162 bigint, field_14 boolean, field_4 double, field_37 double), field_29 row(field_151 row(field_92 bigint, field_235 varchar), field_135 varchar, field_92 bigint), field_75 boolean))";
            this.bigVarcharEnumSignature = BenchmarkData.bigVarcharEnumType().getTypeSignature().toString();
            this.bigLongEnumSignature = BenchmarkData.bigLongEnumType().getTypeSignature().toString();
        }
    }
}

