/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.type;

import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.DistinctType;
import com.facebook.presto.common.type.DistinctTypeInfo;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.common.type.VarcharType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTypeUtils {
    @Test
    public void testContainsDistinctType() {
        QualifiedObjectName distinctTypeName = QualifiedObjectName.valueOf((String)"test.dt.int00");
        DistinctTypeInfo distinctTypeInfo = new DistinctTypeInfo(distinctTypeName, IntegerType.INTEGER.getTypeSignature(), Optional.empty(), false);
        DistinctType distinctType = new DistinctType(distinctTypeInfo, (Type)IntegerType.INTEGER, null);
        Assert.assertFalse((boolean)TypeUtils.containsDistinctType((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.VARCHAR)));
        Assert.assertTrue((boolean)TypeUtils.containsDistinctType((List)ImmutableList.of((Object)distinctType)));
        Assert.assertFalse((boolean)TypeUtils.containsDistinctType((List)ImmutableList.of((Object)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.VARCHAR)))));
        Assert.assertFalse((boolean)TypeUtils.containsDistinctType((List)ImmutableList.of((Object)new ArrayType((Type)IntegerType.INTEGER))));
        Assert.assertTrue((boolean)TypeUtils.containsDistinctType((List)ImmutableList.of((Object)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)distinctType)))));
        Assert.assertTrue((boolean)TypeUtils.containsDistinctType((List)ImmutableList.of((Object)new ArrayType((Type)distinctType))));
        Assert.assertFalse((boolean)TypeUtils.containsDistinctType((List)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)))));
        Assert.assertFalse((boolean)TypeUtils.containsDistinctType((List)ImmutableList.of((Object)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.VARCHAR))))));
        Assert.assertTrue((boolean)TypeUtils.containsDistinctType((List)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)distinctType)))));
        Assert.assertTrue((boolean)TypeUtils.containsDistinctType((List)ImmutableList.of((Object)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)distinctType))))));
    }
}

