/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.type;

import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.UnscaledDecimal128Arithmetic;
import com.google.common.primitives.Bytes;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Collections;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestUnscaledDecimal128Arithmetic {
    private static final Slice MAX_DECIMAL = UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)Decimals.MAX_DECIMAL_UNSCALED_VALUE);
    private static final Slice MIN_DECIMAL = UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)Decimals.MIN_DECIMAL_UNSCALED_VALUE);
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    @Test
    public void testUnscaledBigIntegerToDecimal() {
        TestUnscaledDecimal128Arithmetic.assertConvertsUnscaledBigIntegerToDecimal(Decimals.MAX_DECIMAL_UNSCALED_VALUE);
        TestUnscaledDecimal128Arithmetic.assertConvertsUnscaledBigIntegerToDecimal(Decimals.MIN_DECIMAL_UNSCALED_VALUE);
        TestUnscaledDecimal128Arithmetic.assertConvertsUnscaledBigIntegerToDecimal(BigInteger.ZERO);
        TestUnscaledDecimal128Arithmetic.assertConvertsUnscaledBigIntegerToDecimal(BigInteger.ONE);
        TestUnscaledDecimal128Arithmetic.assertConvertsUnscaledBigIntegerToDecimal(BigInteger.ONE.negate());
    }

    @Test
    public void testUnscaledBigIntegerToDecimalOverflow() {
        TestUnscaledDecimal128Arithmetic.assertUnscaledBigIntegerToDecimalOverflows(Decimals.MAX_DECIMAL_UNSCALED_VALUE.add(BigInteger.ONE));
        TestUnscaledDecimal128Arithmetic.assertUnscaledBigIntegerToDecimalOverflows(Decimals.MAX_DECIMAL_UNSCALED_VALUE.setBit(95));
        TestUnscaledDecimal128Arithmetic.assertUnscaledBigIntegerToDecimalOverflows(Decimals.MAX_DECIMAL_UNSCALED_VALUE.setBit(127));
        TestUnscaledDecimal128Arithmetic.assertUnscaledBigIntegerToDecimalOverflows(Decimals.MIN_DECIMAL_UNSCALED_VALUE.subtract(BigInteger.ONE));
    }

    @Test
    public void testUnscaledLongToDecimal() {
        TestUnscaledDecimal128Arithmetic.assertConvertsUnscaledLongToDecimal(0L);
        TestUnscaledDecimal128Arithmetic.assertConvertsUnscaledLongToDecimal(1L);
        TestUnscaledDecimal128Arithmetic.assertConvertsUnscaledLongToDecimal(-1L);
        TestUnscaledDecimal128Arithmetic.assertConvertsUnscaledLongToDecimal(Long.MAX_VALUE);
        TestUnscaledDecimal128Arithmetic.assertConvertsUnscaledLongToDecimal(Long.MIN_VALUE);
    }

    @Test
    public void testDecimalToUnscaledLongOverflow() {
        TestUnscaledDecimal128Arithmetic.assertDecimalToUnscaledLongOverflows(BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE));
        TestUnscaledDecimal128Arithmetic.assertDecimalToUnscaledLongOverflows(BigInteger.valueOf(Long.MIN_VALUE).subtract(BigInteger.ONE));
        TestUnscaledDecimal128Arithmetic.assertDecimalToUnscaledLongOverflows(Decimals.MAX_DECIMAL_UNSCALED_VALUE);
        TestUnscaledDecimal128Arithmetic.assertDecimalToUnscaledLongOverflows(Decimals.MIN_DECIMAL_UNSCALED_VALUE);
    }

    @Test
    public void testRescale() {
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.rescale((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)10L), (int)0), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)10L));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.rescale((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)10L), (int)-20), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.rescale((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)15L), (int)-1), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)2L));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.rescale((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)1050L), (int)-3), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)1L));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.rescale((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)15L), (int)1), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)150L));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.rescale((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)-14L), (int)-1), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)-1L));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.rescale((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)-14L), (int)1), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)-140L));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.rescale((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L), (int)1), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.rescale((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)5L), (int)-1), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)1L));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.rescale((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)10L), (int)10), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)100000000000L));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.rescale((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((String)"150000000000000000000"), (int)-20), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)2L));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.rescale((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((String)"-140000000000000000000"), (int)-20), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)-1L));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.rescale((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((String)"50000000000000000000"), (int)-20), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)1L));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.rescale((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((String)"150500000000000000000"), (int)-18), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)151L));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.rescale((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((String)"-140000000000000000000"), (int)-18), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)-140L));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.rescale((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)BigInteger.ONE.shiftLeft(63)), (int)-18), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)9L));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.rescale((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)BigInteger.ONE.shiftLeft(62)), (int)-18), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)5L));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.rescale((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)BigInteger.ONE.shiftLeft(62)), (int)-19), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.rescale((Slice)MAX_DECIMAL, (int)-1), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)Decimals.MAX_DECIMAL_UNSCALED_VALUE.divide(BigInteger.TEN).add(BigInteger.ONE)));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.rescale((Slice)MIN_DECIMAL, (int)-10), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)Decimals.MIN_DECIMAL_UNSCALED_VALUE.divide(BigInteger.valueOf(10000000000L)).subtract(BigInteger.ONE)));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.rescale((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)1L), (int)37), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((String)"10000000000000000000000000000000000000"));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.rescale((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)-1L), (int)37), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((String)"-10000000000000000000000000000000000000"));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.rescale((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((String)"10000000000000000000000000000000000000"), (int)-37), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)1L));
    }

    @Test
    public void testRescaleOverflows() {
        TestUnscaledDecimal128Arithmetic.assertRescaleOverflows(UnscaledDecimal128Arithmetic.unscaledDecimal((long)1L), 38);
    }

    @Test
    public void testAdd() {
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.add((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L), (Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L)), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.add((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)1L), (Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L)), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)1L));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.add((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)1L), (Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)1L)), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)2L));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.add((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0x100000000L), (Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L)), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0x100000000L));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.add((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0x80000000L), (Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0x80000000L)), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0x100000000L));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.add((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0x100000000L), (Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0x200000000L)), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0x300000000L));
    }

    @Test
    public void testAddReturnOverflow() {
        this.assertAddReturnOverflow(TWO, TWO);
        this.assertAddReturnOverflow(Decimals.MAX_DECIMAL_UNSCALED_VALUE, Decimals.MAX_DECIMAL_UNSCALED_VALUE);
        this.assertAddReturnOverflow(Decimals.MAX_DECIMAL_UNSCALED_VALUE.negate(), Decimals.MAX_DECIMAL_UNSCALED_VALUE);
        this.assertAddReturnOverflow(Decimals.MAX_DECIMAL_UNSCALED_VALUE, Decimals.MAX_DECIMAL_UNSCALED_VALUE.negate());
        this.assertAddReturnOverflow(Decimals.MAX_DECIMAL_UNSCALED_VALUE.negate(), Decimals.MAX_DECIMAL_UNSCALED_VALUE.negate());
    }

    @Test
    public void testMultiply() {
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.multiply((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L), (Slice)MAX_DECIMAL), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.multiply((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)1L), (Slice)MAX_DECIMAL), (Object)MAX_DECIMAL);
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.multiply((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)1L), (Slice)MIN_DECIMAL), (Object)MIN_DECIMAL);
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.multiply((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)-1L), (Slice)MAX_DECIMAL), (Object)MIN_DECIMAL);
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.multiply((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)-1L), (Slice)MIN_DECIMAL), (Object)MAX_DECIMAL);
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.multiply((Slice)Slices.wrappedIntArray((int[])new int[]{-1, -1, 0, 0}), (Slice)Slices.wrappedIntArray((int[])new int[]{-1, 0xFFFFFF, 0, 0})), (Object)Slices.wrappedLongArray((long[])new long[]{-72057594037927935L, 0xFFFFFFFFFFFFFEL}));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.multiply((Slice)Slices.wrappedLongArray((long[])new long[]{-1096982480896L, 0L}), (Slice)Slices.wrappedLongArray((long[])new long[]{4107341382742775296L, 0L})), (Object)Slices.wrappedLongArray((long[])new long[]{2079450807984455680L, 4107341138489289590L}));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.multiply((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)Integer.MAX_VALUE), (Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)Integer.MIN_VALUE)), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)-4611686016279904256L));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.multiply((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((String)"99999999999999"), (Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((String)"-1000000000000000000000000")), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((String)"-99999999999999000000000000000000000000"));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.multiply((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((String)"12380837221737387489365741632769922889"), (Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((String)"3")), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((String)"37142511665212162468097224898309768667"));
    }

    @Test
    public void testMultiply256() {
        TestUnscaledDecimal128Arithmetic.assertMultiply256(MAX_DECIMAL, MAX_DECIMAL, Slices.wrappedLongArray((long[])new long[]{-1374799102801346559L, -2234053005655177461L, 532749306367912312L, 1593091911132452277L}));
        TestUnscaledDecimal128Arithmetic.assertMultiply256(MIN_DECIMAL, MIN_DECIMAL, Slices.wrappedLongArray((long[])new long[]{-1374799102801346559L, -2234053005655177461L, 532749306367912312L, 1593091911132452277L}));
        TestUnscaledDecimal128Arithmetic.assertMultiply256(Slices.wrappedLongArray((long[])new long[]{-1L, 0xFFFFFFFFFFFFFFFL}), Slices.wrappedLongArray((long[])new long[]{-1L, 0xFFFFFFFFFFFFFFFL}), Slices.wrappedLongArray((long[])new long[]{1L, -2305843009213693952L, -1L, 0xFFFFFFFFFFFFFFL}));
        TestUnscaledDecimal128Arithmetic.assertMultiply256(Slices.wrappedLongArray((long[])new long[]{1311768467294899695L, 1070935361496367905L}), Slices.wrappedLongArray((long[])new long[]{-81986143110479071L, 81985529205931230L}), Slices.wrappedLongArray((long[])new long[]{-4446666709573166897L, -6164963839899820582L, 8941401567280465557L, 4759712717148820L}));
    }

    private static void assertMultiply256(Slice left, Slice right, Slice expected) {
        Slice actual = Slices.allocate((int)32);
        UnscaledDecimal128Arithmetic.multiply256((Slice)left, (Slice)right, (Slice)actual);
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testMultiplyByInt() {
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.multiply((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L), (int)1), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.multiply((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)2L), (int)Integer.MAX_VALUE), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0xFFFFFFFEL));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.multiply((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)Integer.MAX_VALUE), (int)-3), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)-6442450941L));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.multiply((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)Integer.MIN_VALUE), (int)-3), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0x180000000L));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.multiply((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)TWO.pow(100).subtract(BigInteger.ONE)), (int)2), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)TWO.pow(101).subtract(TWO)));
    }

    @Test
    public void testMultiplyOverflow() {
        TestUnscaledDecimal128Arithmetic.assertMultiplyOverflows(UnscaledDecimal128Arithmetic.unscaledDecimal((String)"99999999999999"), UnscaledDecimal128Arithmetic.unscaledDecimal((String)"-10000000000000000000000000"));
        TestUnscaledDecimal128Arithmetic.assertMultiplyOverflows(MAX_DECIMAL, UnscaledDecimal128Arithmetic.unscaledDecimal((String)"10"));
    }

    @Test
    public void testShiftRight() {
        TestUnscaledDecimal128Arithmetic.assertShiftRight(UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L), 0, true, UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L));
        TestUnscaledDecimal128Arithmetic.assertShiftRight(UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L), 33, true, UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L));
        TestUnscaledDecimal128Arithmetic.assertShiftRight(UnscaledDecimal128Arithmetic.unscaledDecimal((long)1L), 1, true, UnscaledDecimal128Arithmetic.unscaledDecimal((long)1L));
        TestUnscaledDecimal128Arithmetic.assertShiftRight(UnscaledDecimal128Arithmetic.unscaledDecimal((long)-4L), 1, true, UnscaledDecimal128Arithmetic.unscaledDecimal((long)-2L));
        TestUnscaledDecimal128Arithmetic.assertShiftRight(UnscaledDecimal128Arithmetic.unscaledDecimal((long)0x100000000L), 32, true, UnscaledDecimal128Arithmetic.unscaledDecimal((long)1L));
        TestUnscaledDecimal128Arithmetic.assertShiftRight(UnscaledDecimal128Arithmetic.unscaledDecimal((long)0x80000000L), 32, true, UnscaledDecimal128Arithmetic.unscaledDecimal((long)1L));
        TestUnscaledDecimal128Arithmetic.assertShiftRight(UnscaledDecimal128Arithmetic.unscaledDecimal((long)0x80000000L), 32, false, UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L));
        TestUnscaledDecimal128Arithmetic.assertShiftRight(UnscaledDecimal128Arithmetic.unscaledDecimal((long)0x600000000L), 34, true, UnscaledDecimal128Arithmetic.unscaledDecimal((long)2L));
        TestUnscaledDecimal128Arithmetic.assertShiftRight(UnscaledDecimal128Arithmetic.unscaledDecimal((long)0x600000000L), 34, false, UnscaledDecimal128Arithmetic.unscaledDecimal((long)1L));
        TestUnscaledDecimal128Arithmetic.assertShiftRight(UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)BigInteger.valueOf(Long.MAX_VALUE).setBit(63).setBit(64)), 1, true, UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)BigInteger.ONE.shiftLeft(64)));
        TestUnscaledDecimal128Arithmetic.assertShiftRight(MAX_DECIMAL, 1, true, UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)Decimals.MAX_DECIMAL_UNSCALED_VALUE.shiftRight(1).add(BigInteger.ONE)));
        TestUnscaledDecimal128Arithmetic.assertShiftRight(MIN_DECIMAL, 1, true, UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)Decimals.MAX_DECIMAL_UNSCALED_VALUE.shiftRight(1).add(BigInteger.ONE).negate()));
        TestUnscaledDecimal128Arithmetic.assertShiftRight(MAX_DECIMAL, 66, true, UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)Decimals.MAX_DECIMAL_UNSCALED_VALUE.shiftRight(66).add(BigInteger.ONE)));
    }

    @Test
    public void testShiftRightArray8() {
        this.assertShiftRightArray8(TWO.pow(1), 0);
        this.assertShiftRightArray8(TWO.pow(1), 1);
        this.assertShiftRightArray8(TWO.pow(1), 10);
        this.assertShiftRightArray8(TWO.pow(15).add(TWO.pow(3)), 2);
        this.assertShiftRightArray8(TWO.pow(15).add(TWO.pow(3)), 10);
        this.assertShiftRightArray8(TWO.pow(15).add(TWO.pow(3)), 20);
        this.assertShiftRightArray8(TWO.pow(70), 30);
        this.assertShiftRightArray8(TWO.pow(70).subtract(TWO.pow(1)), 30, true);
        this.assertShiftRightArray8(TWO.pow(70), 32);
        this.assertShiftRightArray8(TWO.pow(70).subtract(TWO.pow(1)), 32, true);
        this.assertShiftRightArray8(TWO.pow(120), 70);
        this.assertShiftRightArray8(TWO.pow(120).subtract(TWO.pow(1)), 70, true);
        this.assertShiftRightArray8(TWO.pow(120), 96);
        this.assertShiftRightArray8(TWO.pow(120).subtract(TWO.pow(1)), 96, true);
        this.assertShiftRightArray8(Decimals.MAX_DECIMAL_UNSCALED_VALUE, 20, true);
        this.assertShiftRightArray8(Decimals.MAX_DECIMAL_UNSCALED_VALUE.multiply(Decimals.MAX_DECIMAL_UNSCALED_VALUE), 130);
        this.assertShiftRightArray8(TWO.pow(256).subtract(BigInteger.ONE), 130, true);
        this.assertShiftRightArray8Overflow(TWO.pow(156), 1);
        this.assertShiftRightArray8Overflow(Decimals.MAX_DECIMAL_UNSCALED_VALUE.multiply(Decimals.MAX_DECIMAL_UNSCALED_VALUE), 20);
        this.assertShiftRightArray8Overflow(TWO.pow(256).subtract(BigInteger.ONE), 129);
    }

    @Test
    public void testDivide() {
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns("0", "10");
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns("5", "10");
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns("50", "100");
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns("99", "10");
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns("95", "10");
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns("91", "10");
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns("1000000000000000000000000", "10");
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns("1000000000000000000000000", "3");
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns("1000000000000000000000000", "9");
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns("1000000000000000000000000", "100000000000000000000000");
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns("1000000000000000000000000", "333333333333333333333333");
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns("1000000000000000000000000", "111111111111111111111111");
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{4, 3, 2, 0}, new int[]{4, 3, 2, 1});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{4, 3, 0, 0}, new int[]{4, 3, 2, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{4, 0, 0, 0}, new int[]{4, 3, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{0, 0, 0, 0}, new int[]{4, 0, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{1423957378, 1765820914, -1, 0}, new int[]{4, 65535, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{1423957378, 1765820914, -1, 0}, new int[]{2042457708, 0, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{1423957378, -925263858, 0, 0}, new int[]{2042457708, 0, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{-1, 0, 0, 0}, new int[]{2042457708, 0, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{1423957378, -1444436990, -925263858, 1106345725}, new int[]{2042457708, 0, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{0, -150994944, 0, 0x39000000}, new int[]{-1765820914, 0, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{-1981284352, -1966660860, 0, 0}, new int[]{-1794967296, 0, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{267387408, -150990288, -83842048, 956314880}, new int[]{-1765820914, 2042457708, -1, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{267387408, -150990288, -83842048, 956314880}, new int[]{-1765820914, -256, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{267387408, -150990288, -83842048, 956314880}, new int[]{-1765820914, -16777216, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{267387408, -150990288, -83842048, 956314880}, new int[]{-1765820914, 2042457708, -1, Integer.MAX_VALUE});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{267387408, -150990288, -83842048, 956314880}, new int[]{-1765820914, 2042457708, 0x4FFFFFFF, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{267387408, -150990288, -83842048, 956314880}, new int[]{-1765820914, 2042457708, 65535, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{1, 1, 1, Integer.MAX_VALUE}, new int[]{-1, 1, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{0, -1879048193, -1879048193, 0}, new int[]{-1, -1879048193, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{1, 1, -1, 0}, new int[]{-1, Integer.MAX_VALUE, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{1, 1, -1, 0}, new int[]{-1, Integer.MAX_VALUE, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{3, 0, Integer.MIN_VALUE, 0}, new int[]{1, 0, 0x20000000, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{3, 0, 32768, 0}, new int[]{1, 0, 8192, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{0, 0, 32768, Short.MAX_VALUE}, new int[]{1, 0, 32768, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{3, 0, 0, 0}, new int[]{2, 0, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{3, 0, 0, 0}, new int[]{3, 0, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{3, 0, 0, 0}, new int[]{4, 0, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{3, 0, 0, 0}, new int[]{-1, 0, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{-1, 0, 0, 0}, new int[]{1, 0, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{-1, 0, 0, 0}, new int[]{-1, 0, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{-1, 0, 0, 0}, new int[]{3, 0, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{-1, -1, 0, 0}, new int[]{1, 0, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{-1, -1, 0, 0}, new int[]{-1, 0, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{-1, -2, 0, 0}, new int[]{-1, 0, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{22136, 4660, 0, 0}, new int[]{39612, 0, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{0, 0, 0, 0}, new int[]{0, 1, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{0, 7, 0, 0}, new int[]{0, 3, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{5, 7, 0, 0}, new int[]{0, 3, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{0, 6, 0, 0}, new int[]{0, 2, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{Integer.MIN_VALUE, 0, 0, 0}, new int[]{0x40000001, 0, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{0, Integer.MIN_VALUE, 0, 0}, new int[]{0x40000001, 0, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{0, Integer.MIN_VALUE, 0, 0}, new int[]{1, 0x40000000, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{30874, 48350, 0, 0}, new int[]{30874, 48350, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{30875, 48350, 0, 0}, new int[]{30874, 48350, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{30873, 48350, 0, 0}, new int[]{30874, 48350, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{65535, 65535, 0, 0}, new int[]{65535, 65535, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{65535, 65535, 0, 0}, new int[]{0, 65535, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{35243, 17767, 291, 0}, new int[]{0, 1, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{35243, 17767, 291, 0}, new int[]{0, 1, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{0, 65534, 32768, 0}, new int[]{65535, 32768, 0, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{3, 0, Integer.MIN_VALUE, 0}, new int[]{1, 0, 0x20000000, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{3, 0, 32768, 0}, new int[]{1, 0, 8192, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{0, 0, 32768, Short.MAX_VALUE}, new int[]{1, 0, 32768, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{0, 65534, 0, 32768}, new int[]{65535, 0, 32768, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{0, -2, 0, Integer.MIN_VALUE}, new int[]{65535, 0, Integer.MIN_VALUE, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(new int[]{0, -2, 0, Integer.MIN_VALUE}, new int[]{-1, 0, Integer.MIN_VALUE, 0});
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns("100000000000000000000000", 10, "111111111111111111111111", 10);
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns("100000000000000000000000", 10, "111111111111", 22);
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns("99999999999999999999999999999999999999", 37, "99999999999999999999999999999999999999", 37);
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns("99999999999999999999999999999999999999", 2, "99999999999999999999999999999999999999", 1);
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns("99999999999999999999999999999999999999", 37, "9", 37);
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns("99999999999999999999999999999999999999", 37, "1", 37);
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns("11111111111111111111111111111111111111", 37, "2", 37);
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns("11111111111111111111111111111111111111", 37, "2", 1);
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns("97764425639372288753711864842425458618", 36, "32039006229599111733094986468789901155", 0);
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns("34354576602352622842481633786816220283", 0, "31137583115118564930544829855652258045", 0);
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns("96690614752287690630596513604374991473", 0, "10039352042372909488692220528497751229", 0);
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns("87568357716090115374029040878755891076", 0, "46106713604991337798209343815577148589", 0);
    }

    @Test
    public void testOverflows() {
        Assert.assertTrue((boolean)UnscaledDecimal128Arithmetic.overflows((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((String)"100"), (int)2));
        Assert.assertTrue((boolean)UnscaledDecimal128Arithmetic.overflows((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((String)"-100"), (int)2));
        Assert.assertFalse((boolean)UnscaledDecimal128Arithmetic.overflows((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((String)"99"), (int)2));
        Assert.assertFalse((boolean)UnscaledDecimal128Arithmetic.overflows((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((String)"-99"), (int)2));
    }

    @Test
    public void testCompare() {
        TestUnscaledDecimal128Arithmetic.assertCompare(UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L), UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L), 0);
        TestUnscaledDecimal128Arithmetic.assertCompare(TestUnscaledDecimal128Arithmetic.negate(UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L)), UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L), 0);
        TestUnscaledDecimal128Arithmetic.assertCompare(UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L), TestUnscaledDecimal128Arithmetic.negate(UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L)), 0);
        TestUnscaledDecimal128Arithmetic.assertCompare(UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L), UnscaledDecimal128Arithmetic.unscaledDecimal((long)10L), -1);
        TestUnscaledDecimal128Arithmetic.assertCompare(UnscaledDecimal128Arithmetic.unscaledDecimal((long)10L), UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L), 1);
        TestUnscaledDecimal128Arithmetic.assertCompare(TestUnscaledDecimal128Arithmetic.negate(UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L)), UnscaledDecimal128Arithmetic.unscaledDecimal((long)10L), -1);
        TestUnscaledDecimal128Arithmetic.assertCompare(UnscaledDecimal128Arithmetic.unscaledDecimal((long)10L), TestUnscaledDecimal128Arithmetic.negate(UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L)), 1);
        TestUnscaledDecimal128Arithmetic.assertCompare(TestUnscaledDecimal128Arithmetic.negate(UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L)), MAX_DECIMAL, -1);
        TestUnscaledDecimal128Arithmetic.assertCompare(MAX_DECIMAL, TestUnscaledDecimal128Arithmetic.negate(UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L)), 1);
        TestUnscaledDecimal128Arithmetic.assertCompare(UnscaledDecimal128Arithmetic.unscaledDecimal((long)-10L), UnscaledDecimal128Arithmetic.unscaledDecimal((long)-11L), 1);
        TestUnscaledDecimal128Arithmetic.assertCompare(UnscaledDecimal128Arithmetic.unscaledDecimal((long)-11L), UnscaledDecimal128Arithmetic.unscaledDecimal((long)-11L), 0);
        TestUnscaledDecimal128Arithmetic.assertCompare(UnscaledDecimal128Arithmetic.unscaledDecimal((long)-12L), UnscaledDecimal128Arithmetic.unscaledDecimal((long)-11L), -1);
        TestUnscaledDecimal128Arithmetic.assertCompare(UnscaledDecimal128Arithmetic.unscaledDecimal((long)10L), UnscaledDecimal128Arithmetic.unscaledDecimal((long)11L), -1);
        TestUnscaledDecimal128Arithmetic.assertCompare(UnscaledDecimal128Arithmetic.unscaledDecimal((long)11L), UnscaledDecimal128Arithmetic.unscaledDecimal((long)11L), 0);
        TestUnscaledDecimal128Arithmetic.assertCompare(UnscaledDecimal128Arithmetic.unscaledDecimal((long)12L), UnscaledDecimal128Arithmetic.unscaledDecimal((long)11L), 1);
    }

    @Test
    public void testNegate() {
        Assert.assertEquals((Object)TestUnscaledDecimal128Arithmetic.negate(TestUnscaledDecimal128Arithmetic.negate(MIN_DECIMAL)), (Object)MIN_DECIMAL);
        Assert.assertEquals((Object)TestUnscaledDecimal128Arithmetic.negate(MIN_DECIMAL), (Object)MAX_DECIMAL);
        Assert.assertEquals((Object)TestUnscaledDecimal128Arithmetic.negate(MIN_DECIMAL), (Object)MAX_DECIMAL);
        Assert.assertEquals((Object)TestUnscaledDecimal128Arithmetic.negate(UnscaledDecimal128Arithmetic.unscaledDecimal((long)1L)), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)-1L));
        Assert.assertEquals((Object)TestUnscaledDecimal128Arithmetic.negate(UnscaledDecimal128Arithmetic.unscaledDecimal((long)-1L)), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)1L));
        Assert.assertEquals((Object)TestUnscaledDecimal128Arithmetic.negate(TestUnscaledDecimal128Arithmetic.negate(UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L))), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L));
    }

    @Test
    public void testIsNegative() {
        Assert.assertEquals((boolean)UnscaledDecimal128Arithmetic.isNegative((Slice)MIN_DECIMAL), (boolean)true);
        Assert.assertEquals((boolean)UnscaledDecimal128Arithmetic.isNegative((Slice)MAX_DECIMAL), (boolean)false);
        Assert.assertEquals((boolean)UnscaledDecimal128Arithmetic.isNegative((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L)), (boolean)false);
    }

    @Test
    public void testHash() {
        Assert.assertEquals((long)UnscaledDecimal128Arithmetic.hash((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L)), (long)UnscaledDecimal128Arithmetic.hash((Slice)TestUnscaledDecimal128Arithmetic.negate(UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L))));
        Assert.assertNotEquals((Object)UnscaledDecimal128Arithmetic.hash((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L)), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)1L));
    }

    @Test
    public void testToString() {
        Assert.assertEquals((String)UnscaledDecimal128Arithmetic.toUnscaledString((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L)), (String)"0");
        Assert.assertEquals((String)UnscaledDecimal128Arithmetic.toUnscaledString((Slice)TestUnscaledDecimal128Arithmetic.negate(UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L))), (String)"0");
        Assert.assertEquals((String)UnscaledDecimal128Arithmetic.toUnscaledString((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)1L)), (String)"1");
        Assert.assertEquals((String)UnscaledDecimal128Arithmetic.toUnscaledString((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)-1L)), (String)"-1");
        Assert.assertEquals((String)UnscaledDecimal128Arithmetic.toUnscaledString((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((Slice)MAX_DECIMAL)), (String)Decimals.MAX_DECIMAL_UNSCALED_VALUE.toString());
        Assert.assertEquals((String)UnscaledDecimal128Arithmetic.toUnscaledString((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((Slice)MIN_DECIMAL)), (String)Decimals.MIN_DECIMAL_UNSCALED_VALUE.toString());
        Assert.assertEquals((String)UnscaledDecimal128Arithmetic.toUnscaledString((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((String)"1000000000000000000000000000000000000")), (String)"1000000000000000000000000000000000000");
        Assert.assertEquals((String)UnscaledDecimal128Arithmetic.toUnscaledString((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((String)"-1000000000002000000000000300000000000")), (String)"-1000000000002000000000000300000000000");
    }

    @Test
    public void testShiftLeftMultiPrecision() {
        Assert.assertEquals((int[])UnscaledDecimal128Arithmetic.shiftLeftMultiPrecision((int[])new int[]{-1589272251, 1452717397, 1392048298, -16667989, 0}, (int)4, (int)0), (int[])new int[]{-1589272251, 1452717397, 1392048298, -16667989, 0});
        Assert.assertEquals((int[])UnscaledDecimal128Arithmetic.shiftLeftMultiPrecision((int[])new int[]{-1589272251, 1452717397, 1392048298, -16667989, 0}, (int)5, (int)1), (int[])new int[]{1116422794, -1389532501, -1510870700, -33335978, 1});
        Assert.assertEquals((int[])UnscaledDecimal128Arithmetic.shiftLeftMultiPrecision((int[])new int[]{-1589272251, 1452717397, 1392048298, -16667989, 0}, (int)5, (int)31), (int[])new int[]{Integer.MIN_VALUE, -794636126, 726358698, -1451459499, 2139149653});
        Assert.assertEquals((int[])UnscaledDecimal128Arithmetic.shiftLeftMultiPrecision((int[])new int[]{-1589272251, 1452717397, 1392048298, -16667989, 0}, (int)5, (int)32), (int[])new int[]{0, -1589272251, 1452717397, 1392048298, -16667989});
        Assert.assertEquals((int[])UnscaledDecimal128Arithmetic.shiftLeftMultiPrecision((int[])new int[]{-1589272251, 1452717397, 1392048298, -16667989, 0, 0}, (int)6, (int)33), (int[])new int[]{0, 1116422794, -1389532501, -1510870700, -33335978, 1});
        Assert.assertEquals((int[])UnscaledDecimal128Arithmetic.shiftLeftMultiPrecision((int[])new int[]{-1589272251, 1452717397, 1392048298, -16667989, 0, 0}, (int)6, (int)37), (int[])new int[]{0, 682895520, -757683532, 1595872586, -533375638, 31});
        Assert.assertEquals((int[])UnscaledDecimal128Arithmetic.shiftLeftMultiPrecision((int[])new int[]{-1589272251, 1452717397, 1392048298, -16667989, 0, 0}, (int)6, (int)64), (int[])new int[]{0, 0, -1589272251, 1452717397, 1392048298, -16667989});
    }

    @Test
    public void testShiftRightMultiPrecision() {
        Assert.assertEquals((int[])UnscaledDecimal128Arithmetic.shiftRightMultiPrecision((int[])new int[]{-1589272251, 1452717397, 1392048298, -16667989, 0}, (int)4, (int)0), (int[])new int[]{-1589272251, 1452717397, 1392048298, -16667989, 0});
        Assert.assertEquals((int[])UnscaledDecimal128Arithmetic.shiftRightMultiPrecision((int[])new int[]{0, -1589272251, 1452717397, 1392048298, -16667989}, (int)5, (int)1), (int[])new int[]{Integer.MIN_VALUE, -794636126, 726358698, -1451459499, 2139149653});
        Assert.assertEquals((int[])UnscaledDecimal128Arithmetic.shiftRightMultiPrecision((int[])new int[]{0, -1589272251, 1452717397, 1392048298, -16667989}, (int)5, (int)32), (int[])new int[]{-1589272251, 1452717397, 1392048298, -16667989, 0});
        Assert.assertEquals((int[])UnscaledDecimal128Arithmetic.shiftRightMultiPrecision((int[])new int[]{0, 0, -1589272251, 1452717397, 1392048298, -16667989}, (int)6, (int)33), (int[])new int[]{Integer.MIN_VALUE, -794636126, 726358698, -1451459499, 2139149653, 0});
        Assert.assertEquals((int[])UnscaledDecimal128Arithmetic.shiftRightMultiPrecision((int[])new int[]{0, 0, -1589272251, 1452717397, 1392048298, -16667989}, (int)6, (int)37), (int[])new int[]{0x28000000, -1391842038, 1387574698, 1519896517, 133696853, 0});
        Assert.assertEquals((int[])UnscaledDecimal128Arithmetic.shiftRightMultiPrecision((int[])new int[]{0, 0, -1589272251, 1452717397, 1392048298, -16667989}, (int)6, (int)64), (int[])new int[]{-1589272251, 1452717397, 1392048298, -16667989, 0, 0});
    }

    @Test
    public void testShiftLeftCompareToBigInteger() {
        this.assertShiftLeft(new BigInteger("446319580078125"), 19);
        this.assertShiftLeft(TWO.pow(1), 10);
        this.assertShiftLeft(TWO.pow(5).add(TWO.pow(1)), 10);
        this.assertShiftLeft(TWO.pow(1), 100);
        this.assertShiftLeft(TWO.pow(5).add(TWO.pow(1)), 100);
        this.assertShiftLeft(TWO.pow(70), 30);
        this.assertShiftLeft(TWO.pow(70).add(TWO.pow(1)), 30);
        this.assertShiftLeft(TWO.pow(106), 20);
        this.assertShiftLeft(TWO.pow(106).add(TWO.pow(1)), 20);
        this.assertShiftLeftOverflow(TWO.pow(2), 127);
        this.assertShiftLeftOverflow(TWO.pow(64), 64);
        this.assertShiftLeftOverflow(TWO.pow(100), 28);
    }

    @Test
    public void testShiftLeft() {
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.shiftLeft((Slice)Slices.wrappedLongArray((long[])new long[]{1311768467294899695L, -1162850053679398111L}), (int)0), (Object)Slices.wrappedLongArray((long[])new long[]{1311768467294899695L, -1162850053679398111L}));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.shiftLeft((Slice)Slices.wrappedLongArray((long[])new long[]{1311768467294899695L, -1162850053679398111L}), (int)1), (Object)Slices.wrappedLongArray((long[])new long[]{2623536934589799390L, -2325700107358796222L}));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.shiftLeft((Slice)Slices.wrappedLongArray((long[])new long[]{1311768467294899695L, 62129044965376801L}), (int)8), (Object)Slices.wrappedLongArray((long[])new long[]{3771334300722392832L, -2541708562573090542L}));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.shiftLeft((Slice)Slices.wrappedLongArray((long[])new long[]{1311768467294899695L, 204550089032481L}), (int)16), (Object)Slices.wrappedLongArray((long[])new long[]{6230889152035880960L, -5041349438876872140L}));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.shiftLeft((Slice)Slices.wrappedLongArray((long[])new long[]{1311768467294899695L, 2271560481L}), (int)32), (Object)Slices.wrappedLongArray((long[])new long[]{-8022091884849528832L, -8690466096623102344L}));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.shiftLeft((Slice)Slices.wrappedLongArray((long[])new long[]{1311768467294899695L, 0L}), (int)64), (Object)Slices.wrappedLongArray((long[])new long[]{0L, 1311768467294899695L}));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.shiftLeft((Slice)Slices.wrappedLongArray((long[])new long[]{14731774612196847L, 0L}), (int)72), (Object)Slices.wrappedLongArray((long[])new long[]{0L, 3771334300722392832L}));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.shiftLeft((Slice)Slices.wrappedLongArray((long[])new long[]{52719L, 0L}), (int)112), (Object)Slices.wrappedLongArray((long[])new long[]{0L, -3607664776500477952L}));
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.shiftLeft((Slice)Slices.wrappedLongArray((long[])new long[]{1L, 0L}), (int)127), (Object)Slices.wrappedLongArray((long[])new long[]{0L, Long.MIN_VALUE}));
    }

    private void assertAddReturnOverflow(BigInteger left, BigInteger right) {
        Slice result = UnscaledDecimal128Arithmetic.unscaledDecimal();
        long overflow = UnscaledDecimal128Arithmetic.addWithOverflow((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)left), (Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)right), (Slice)result);
        BigInteger actual = UnscaledDecimal128Arithmetic.unscaledDecimalToBigInteger((Slice)result);
        BigInteger expected = left.add(right).remainder(TWO.pow(127));
        BigInteger expectedOverflow = left.add(right).divide(TWO.pow(127));
        Assert.assertEquals((Object)actual, (Object)expected);
        Assert.assertEquals((long)overflow, (long)expectedOverflow.longValueExact());
    }

    private static void assertUnscaledBigIntegerToDecimalOverflows(BigInteger value) {
        try {
            UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)value);
            Assert.fail();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    private static void assertDecimalToUnscaledLongOverflows(BigInteger value) {
        Slice decimal = UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)value);
        try {
            UnscaledDecimal128Arithmetic.unscaledDecimalToUnscaledLong((Slice)decimal);
            Assert.fail();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    private static void assertMultiplyOverflows(Slice left, Slice right) {
        try {
            UnscaledDecimal128Arithmetic.multiply((Slice)left, (Slice)right);
            Assert.fail();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    private static void assertRescaleOverflows(Slice decimal, int rescaleFactor) {
        try {
            UnscaledDecimal128Arithmetic.rescale((Slice)decimal, (int)rescaleFactor);
            Assert.fail();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    private static void assertCompare(Slice left, Slice right, int expectedResult) {
        Assert.assertEquals((int)UnscaledDecimal128Arithmetic.compare((Slice)left, (Slice)right), (int)expectedResult);
        Assert.assertEquals((int)UnscaledDecimal128Arithmetic.compare((long)left.getLong(0), (long)left.getLong(8), (long)right.getLong(0), (long)right.getLong(8)), (int)expectedResult);
    }

    private static void assertConvertsUnscaledBigIntegerToDecimal(BigInteger value) {
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.unscaledDecimalToBigInteger((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)value)), (Object)value);
    }

    private static void assertConvertsUnscaledLongToDecimal(long value) {
        Assert.assertEquals((long)UnscaledDecimal128Arithmetic.unscaledDecimalToUnscaledLong((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)value)), (long)value);
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)value), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)BigInteger.valueOf(value)));
    }

    private static void assertShiftRight(Slice decimal, int rightShifts, boolean roundUp, Slice expectedResult) {
        Slice result = UnscaledDecimal128Arithmetic.unscaledDecimal();
        UnscaledDecimal128Arithmetic.shiftRight((Slice)decimal, (int)rightShifts, (boolean)roundUp, (Slice)result);
        Assert.assertEquals((Object)result, (Object)expectedResult);
    }

    private static void assertDivideAllSigns(int[] dividend, int[] divisor) {
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(Slices.wrappedIntArray((int[])dividend), 0, Slices.wrappedIntArray((int[])divisor), 0);
    }

    private void assertShiftRightArray8Overflow(BigInteger value, int rightShifts) {
        try {
            this.assertShiftRightArray8(value, rightShifts);
            Assert.fail();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    private void assertShiftRightArray8(BigInteger value, int rightShifts) {
        this.assertShiftRightArray8(value, rightShifts, false);
    }

    private void assertShiftRightArray8(BigInteger value, int rightShifts, boolean roundUp) {
        BigInteger expectedResult = value.shiftRight(rightShifts);
        if (roundUp) {
            expectedResult = expectedResult.add(BigInteger.ONE);
        }
        int[] ints = TestUnscaledDecimal128Arithmetic.toInt8Array(value);
        Slice result = UnscaledDecimal128Arithmetic.unscaledDecimal();
        UnscaledDecimal128Arithmetic.shiftRightArray8((int[])ints, (int)rightShifts, (Slice)result);
        Assert.assertEquals((Object)Decimals.decodeUnscaledValue((Slice)result), (Object)expectedResult);
    }

    private void assertShiftLeftOverflow(BigInteger value, int leftShifts) {
        try {
            this.assertShiftLeft(value, leftShifts);
            Assert.fail();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    private void assertShiftLeft(BigInteger value, int leftShifts) {
        Slice decimal = UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)value);
        BigInteger expectedResult = value.multiply(TWO.pow(leftShifts));
        UnscaledDecimal128Arithmetic.shiftLeftDestructive((Slice)decimal, (int)leftShifts);
        Assert.assertEquals((Object)Decimals.decodeUnscaledValue((Slice)decimal), (Object)expectedResult);
    }

    private static void assertDivideAllSigns(String dividend, String divisor) {
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(dividend, 0, divisor, 0);
    }

    private static void assertDivideAllSigns(String dividend, int dividendRescaleFactor, String divisor, int divisorRescaleFactor) {
        TestUnscaledDecimal128Arithmetic.assertDivideAllSigns(UnscaledDecimal128Arithmetic.unscaledDecimal((String)dividend), dividendRescaleFactor, UnscaledDecimal128Arithmetic.unscaledDecimal((String)divisor), divisorRescaleFactor);
    }

    private static void assertDivideAllSigns(Slice dividend, int dividendRescaleFactor, Slice divisor, int divisorRescaleFactor) {
        TestUnscaledDecimal128Arithmetic.assertDivide(dividend, dividendRescaleFactor, divisor, divisorRescaleFactor);
        TestUnscaledDecimal128Arithmetic.assertDivide(dividend, dividendRescaleFactor, TestUnscaledDecimal128Arithmetic.negate(divisor), divisorRescaleFactor);
        TestUnscaledDecimal128Arithmetic.assertDivide(TestUnscaledDecimal128Arithmetic.negate(dividend), dividendRescaleFactor, divisor, divisorRescaleFactor);
        TestUnscaledDecimal128Arithmetic.assertDivide(TestUnscaledDecimal128Arithmetic.negate(dividend), dividendRescaleFactor, TestUnscaledDecimal128Arithmetic.negate(divisor), divisorRescaleFactor);
    }

    private static void assertDivide(Slice dividend, int dividendRescaleFactor, Slice divisor, int divisorRescaleFactor) {
        BigInteger dividendBigInteger = Decimals.decodeUnscaledValue((Slice)dividend);
        BigInteger divisorBigInteger = Decimals.decodeUnscaledValue((Slice)divisor);
        BigInteger rescaledDividend = dividendBigInteger.multiply(Decimals.bigIntegerTenToNth((int)dividendRescaleFactor));
        BigInteger rescaledDivisor = divisorBigInteger.multiply(Decimals.bigIntegerTenToNth((int)divisorRescaleFactor));
        BigInteger[] expectedQuotientAndRemainder = rescaledDividend.divideAndRemainder(rescaledDivisor);
        BigInteger expectedQuotient = expectedQuotientAndRemainder[0];
        BigInteger expectedRemainder = expectedQuotientAndRemainder[1];
        boolean overflowIsExpected = expectedQuotient.abs().compareTo(Decimals.bigIntegerTenToNth((int)38)) >= 0 || expectedRemainder.abs().compareTo(Decimals.bigIntegerTenToNth((int)38)) >= 0;
        Slice quotient = UnscaledDecimal128Arithmetic.unscaledDecimal();
        Slice remainder = UnscaledDecimal128Arithmetic.unscaledDecimal();
        try {
            UnscaledDecimal128Arithmetic.divide((Slice)dividend, (int)dividendRescaleFactor, (Slice)divisor, (int)divisorRescaleFactor, (Slice)quotient, (Slice)remainder);
            if (overflowIsExpected) {
                Assert.fail((String)"overflow is expected");
            }
        }
        catch (ArithmeticException e) {
            if (!overflowIsExpected) {
                Assert.fail((String)"overflow wasn't expected");
            }
            return;
        }
        BigInteger actualQuotient = Decimals.decodeUnscaledValue((Slice)quotient);
        BigInteger actualRemainder = Decimals.decodeUnscaledValue((Slice)remainder);
        if (expectedQuotient.equals(actualQuotient) && expectedRemainder.equals(actualRemainder)) {
            return;
        }
        Assert.fail((String)String.format("%s / %s ([%s * 2^%d] / [%s * 2^%d]) Expected: %s(%s). Actual: %s(%s)", rescaledDividend, rescaledDivisor, dividendBigInteger, dividendRescaleFactor, divisorBigInteger, divisorRescaleFactor, expectedQuotient, expectedRemainder, actualQuotient, actualRemainder));
    }

    private static Slice negate(Slice slice) {
        Slice copy = UnscaledDecimal128Arithmetic.unscaledDecimal((Slice)slice);
        UnscaledDecimal128Arithmetic.negate((Slice)copy);
        return copy;
    }

    private static int[] toInt8Array(BigInteger value) {
        byte[] bigIntegerBytes = value.toByteArray();
        Collections.reverse(Bytes.asList((byte[])bigIntegerBytes));
        byte[] bytes = new byte[33];
        System.arraycopy(bigIntegerBytes, 0, bytes, 0, bigIntegerBytes.length);
        return TestUnscaledDecimal128Arithmetic.toInt8Array(bytes);
    }

    private static int[] toInt8Array(byte[] bytes) {
        Slice slice = Slices.wrappedBuffer((byte[])bytes);
        int[] ints = new int[8];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = slice.getInt(i * 32 / 8);
        }
        return ints;
    }

    private static BigInteger toBigInteger(int[] data) {
        byte[] array = new byte[data.length * 4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(array);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        intBuffer.put(data);
        Collections.reverse(Bytes.asList((byte[])array));
        array[0] = (byte)(array[0] & 0xFFFFFF7F);
        return new BigInteger((array[0] & 0x80) > 0 ? -1 : 1, array);
    }
}

