/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.common.RuntimeMetric;
import com.facebook.presto.common.RuntimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRuntimeMetric {
    private static final String TEST_METRIC_NAME = "test_metric";

    private void assertRuntimeMetricEquals(RuntimeMetric m1, RuntimeMetric m2) {
        Assert.assertEquals((String)m1.getName(), (String)m2.getName());
        Assert.assertEquals((Object)m1.getUnit(), (Object)m2.getUnit());
        Assert.assertEquals((long)m1.getSum(), (long)m2.getSum());
        Assert.assertEquals((long)m1.getCount(), (long)m2.getCount());
        Assert.assertEquals((long)m1.getMax(), (long)m2.getMax());
        Assert.assertEquals((long)m1.getMin(), (long)m2.getMin());
    }

    @Test
    public void testAddValue() {
        RuntimeMetric metric = new RuntimeMetric(TEST_METRIC_NAME, RuntimeUnit.NONE);
        metric.addValue(101L);
        this.assertRuntimeMetricEquals(metric, new RuntimeMetric(TEST_METRIC_NAME, RuntimeUnit.NONE, 101L, 1L, 101L, 101L));
        metric.addValue(99L);
        this.assertRuntimeMetricEquals(metric, new RuntimeMetric(TEST_METRIC_NAME, RuntimeUnit.NONE, 200L, 2L, 101L, 99L));
        metric.addValue(201L);
        this.assertRuntimeMetricEquals(metric, new RuntimeMetric(TEST_METRIC_NAME, RuntimeUnit.NONE, 401L, 3L, 201L, 99L));
        metric.addValue(202L);
        this.assertRuntimeMetricEquals(metric, new RuntimeMetric(TEST_METRIC_NAME, RuntimeUnit.NONE, 603L, 4L, 202L, 99L));
    }

    @Test
    public void testCopy() {
        RuntimeMetric metric = new RuntimeMetric(TEST_METRIC_NAME, RuntimeUnit.NONE, 1L, 1L, 1L, 1L);
        RuntimeMetric metricCopy = RuntimeMetric.copyOf((RuntimeMetric)metric);
        metric.addValue(2L);
        this.assertRuntimeMetricEquals(metric, new RuntimeMetric(TEST_METRIC_NAME, RuntimeUnit.NONE, 3L, 2L, 2L, 1L));
        this.assertRuntimeMetricEquals(metricCopy, new RuntimeMetric(TEST_METRIC_NAME, RuntimeUnit.NONE, 1L, 1L, 1L, 1L));
        metricCopy.addValue(2L);
        this.assertRuntimeMetricEquals(metric, new RuntimeMetric(TEST_METRIC_NAME, RuntimeUnit.NONE, 3L, 2L, 2L, 1L));
        this.assertRuntimeMetricEquals(metricCopy, metric);
    }

    @Test
    public void testMergeWith() {
        RuntimeMetric metric1 = new RuntimeMetric(TEST_METRIC_NAME, RuntimeUnit.NONE, 5L, 2L, 4L, 1L);
        RuntimeMetric metric2 = new RuntimeMetric(TEST_METRIC_NAME, RuntimeUnit.NONE, 20L, 2L, 11L, 9L);
        metric1.mergeWith(metric2);
        this.assertRuntimeMetricEquals(metric1, new RuntimeMetric(TEST_METRIC_NAME, RuntimeUnit.NONE, 25L, 4L, 11L, 1L));
        metric2.mergeWith(metric2);
        this.assertRuntimeMetricEquals(metric2, new RuntimeMetric(TEST_METRIC_NAME, RuntimeUnit.NONE, 40L, 4L, 11L, 9L));
        metric2.mergeWith(null);
        this.assertRuntimeMetricEquals(metric2, new RuntimeMetric(TEST_METRIC_NAME, RuntimeUnit.NONE, 40L, 4L, 11L, 9L));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testMergeWithWithConflictUnits() {
        RuntimeMetric metric1 = new RuntimeMetric(TEST_METRIC_NAME, RuntimeUnit.NANO, 5L, 2L, 4L, 1L);
        RuntimeMetric metric2 = new RuntimeMetric(TEST_METRIC_NAME, RuntimeUnit.BYTE, 20L, 2L, 11L, 9L);
        metric1.mergeWith(metric2);
    }

    @Test
    public void testMerge() {
        RuntimeMetric metric1 = new RuntimeMetric(TEST_METRIC_NAME, RuntimeUnit.NONE, 5L, 2L, 4L, 1L);
        RuntimeMetric metric2 = new RuntimeMetric(TEST_METRIC_NAME, RuntimeUnit.NONE, 20L, 2L, 11L, 9L);
        this.assertRuntimeMetricEquals(RuntimeMetric.merge((RuntimeMetric)metric1, (RuntimeMetric)metric2), new RuntimeMetric(TEST_METRIC_NAME, RuntimeUnit.NONE, 25L, 4L, 11L, 1L));
        this.assertRuntimeMetricEquals(metric1, new RuntimeMetric(TEST_METRIC_NAME, RuntimeUnit.NONE, 5L, 2L, 4L, 1L));
        this.assertRuntimeMetricEquals(metric2, new RuntimeMetric(TEST_METRIC_NAME, RuntimeUnit.NONE, 20L, 2L, 11L, 9L));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testMergeWithConflictUnits() {
        RuntimeMetric metric1 = new RuntimeMetric(TEST_METRIC_NAME, RuntimeUnit.NANO, 5L, 2L, 4L, 1L);
        RuntimeMetric metric2 = new RuntimeMetric(TEST_METRIC_NAME, RuntimeUnit.BYTE, 20L, 2L, 11L, 9L);
        RuntimeMetric.merge((RuntimeMetric)metric1, (RuntimeMetric)metric2);
    }

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(RuntimeMetric.class);
        RuntimeMetric metric = new RuntimeMetric(TEST_METRIC_NAME, RuntimeUnit.NANO);
        metric.addValue(101L);
        metric.addValue(202L);
        String json = codec.toJson((Object)metric);
        RuntimeMetric actual = (RuntimeMetric)codec.fromJson(json);
        this.assertRuntimeMetricEquals(actual, metric);
    }

    @Test
    public void testJsonWhenUnitIsUnavailable() {
        RuntimeMetric metric1 = new RuntimeMetric(TEST_METRIC_NAME, RuntimeUnit.NONE);
        metric1.addValue(101L);
        metric1.addValue(202L);
        RuntimeMetric metric2 = new RuntimeMetric(TEST_METRIC_NAME, null);
        metric2.addValue(202L);
        metric2.addValue(101L);
        String json = "{\"name\" : \"test_metric\", \"sum\" : 303, \"count\" : 2, \"max\" : 202, \"min\" : 101}";
        RuntimeMetric actual = (RuntimeMetric)JsonCodec.jsonCodec(RuntimeMetric.class).fromJson(json);
        this.assertRuntimeMetricEquals(actual, metric1);
        this.assertRuntimeMetricEquals(actual, metric2);
    }
}

