/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.DictionaryBlock;
import com.facebook.presto.common.block.TestVariableWidthBlockEncoding;
import com.facebook.presto.common.block.TestingBlockEncodingSerde;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDictionaryBlockEncoding {
    private final BlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde(new BlockEncoding[0]);

    @Test
    public void testRoundTrip() {
        int positionCount = 40;
        BlockBuilder dictionaryBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 4);
        VarcharType.VARCHAR.writeString(dictionaryBuilder, "alice");
        VarcharType.VARCHAR.writeString(dictionaryBuilder, "bob");
        VarcharType.VARCHAR.writeString(dictionaryBuilder, "charlie");
        VarcharType.VARCHAR.writeString(dictionaryBuilder, "dave");
        Block dictionary = dictionaryBuilder.build();
        int[] ids = new int[positionCount];
        for (int i = 0; i < 40; ++i) {
            ids[i] = i % 4;
        }
        DictionaryBlock dictionaryBlock = new DictionaryBlock(dictionary, ids);
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1024);
        this.blockEncodingSerde.writeBlock((SliceOutput)sliceOutput, (Block)dictionaryBlock);
        Block actualBlock = this.blockEncodingSerde.readBlock((SliceInput)sliceOutput.slice().getInput());
        Assert.assertTrue((boolean)(actualBlock instanceof DictionaryBlock));
        DictionaryBlock actualDictionaryBlock = (DictionaryBlock)actualBlock;
        TestDictionaryBlockEncoding.assertBlockEquals((Type)VarcharType.VARCHAR, actualDictionaryBlock.getDictionary(), dictionary);
        for (int position = 0; position < actualDictionaryBlock.getPositionCount(); ++position) {
            Assert.assertEquals((int)actualDictionaryBlock.getId(position), (int)ids[position]);
        }
        Assert.assertEquals((Object)actualDictionaryBlock.getDictionarySourceId(), (Object)dictionaryBlock.getDictionarySourceId());
    }

    private static void assertBlockEquals(Type type, Block actual, Block expected) {
        for (int position = 0; position < actual.getPositionCount(); ++position) {
            Assert.assertEquals((Object)type.getObjectValue(TestVariableWidthBlockEncoding.PROPERTIES, actual, position), (Object)type.getObjectValue(TestVariableWidthBlockEncoding.PROPERTIES, expected, position));
        }
    }
}

