/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.block.ArrayBlockBuilder;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.MethodHandleUtil;
import com.facebook.presto.common.block.SingleArrayBlockWriter;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import io.airlift.slice.Slices;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSingleArrayBlockWriter {
    private static final int ARRAY_POSITIONS = 100;

    @Test
    public void testSizeInBytes() {
        MapType mapType = new MapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR, MethodHandleUtil.methodHandle(TestSingleArrayBlockWriter.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestSingleArrayBlockWriter.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]));
        ArrayBlockBuilder arrayBlockBuilder = new ArrayBlockBuilder((Type)mapType, null, 100);
        for (int i = 0; i < 100; ++i) {
            SingleArrayBlockWriter singleArrayBlockWriter = arrayBlockBuilder.beginBlockEntry();
            int expectedSize = 0;
            for (int j = 0; j < 10; ++j) {
                Assert.assertEquals((long)singleArrayBlockWriter.getSizeInBytes(), (long)expectedSize, (String)("For Index: " + i));
                BlockBuilder innerMapWriter = singleArrayBlockWriter.beginBlockEntry();
                Assert.assertEquals((long)singleArrayBlockWriter.getSizeInBytes(), (long)expectedSize, (String)("For Index: " + i));
                BigintType.BIGINT.writeLong(innerMapWriter, (long)(i * 2));
                VarcharType.VARCHAR.writeSlice(innerMapWriter, Slices.utf8Slice((String)"Value1"));
                Assert.assertEquals((long)singleArrayBlockWriter.getSizeInBytes(), (long)(expectedSize += 28), (String)("For Index: " + i));
                BigintType.BIGINT.writeLong(innerMapWriter, (long)(i * 2 + 1));
                VarcharType.VARCHAR.writeSlice(innerMapWriter, Slices.utf8Slice((String)"Value2"));
                Assert.assertEquals((long)singleArrayBlockWriter.getSizeInBytes(), (long)(expectedSize += 28), (String)("For Index: " + i));
                singleArrayBlockWriter.closeEntry();
                Assert.assertEquals((long)singleArrayBlockWriter.getSizeInBytes(), (long)(expectedSize += 5), (String)("For Index: " + i));
            }
            singleArrayBlockWriter.appendNull();
            Assert.assertEquals((long)singleArrayBlockWriter.getSizeInBytes(), (long)(expectedSize += 5), (String)("For Index: " + i));
            arrayBlockBuilder.closeEntry();
            Assert.assertEquals((long)singleArrayBlockWriter.getSizeInBytes(), (long)expectedSize, (String)("For Index: " + i));
        }
    }

    @Test
    public void testSizeInBytesForNulls() {
        MapType mapType = new MapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR, MethodHandleUtil.methodHandle(TestSingleArrayBlockWriter.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestSingleArrayBlockWriter.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]));
        ArrayBlockBuilder arrayBlockBuilder = new ArrayBlockBuilder((Type)mapType, null, 100);
        for (int i = 0; i < 100; ++i) {
            SingleArrayBlockWriter singleArrayBlockWriter = arrayBlockBuilder.beginBlockEntry();
            int expectedSize = 0;
            for (int j = 0; j < 10; ++j) {
                Assert.assertEquals((long)singleArrayBlockWriter.getSizeInBytes(), (long)expectedSize, (String)("For Index: " + i));
                singleArrayBlockWriter.appendNull();
                Assert.assertEquals((long)singleArrayBlockWriter.getSizeInBytes(), (long)(expectedSize += 5), (String)("For Index: " + i));
            }
            arrayBlockBuilder.closeEntry();
            Assert.assertEquals((long)singleArrayBlockWriter.getSizeInBytes(), (long)expectedSize, (String)("For Index: " + i));
        }
    }

    public static void throwUnsupportedOperation() {
        throw new UnsupportedOperationException();
    }
}

