/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.MapBlockBuilder;
import com.facebook.presto.common.block.MethodHandleUtil;
import com.facebook.presto.common.block.SingleMapBlockWriter;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import io.airlift.slice.Slices;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSingleMapBlockWriter {
    private static final int MAP_POSITIONS = 100;

    @Test
    public void testSizeInBytes() {
        MapType innerMapType = new MapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR, MethodHandleUtil.methodHandle(TestSingleMapBlockWriter.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestSingleMapBlockWriter.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]));
        MapType mapType = new MapType((Type)BigintType.BIGINT, (Type)innerMapType, MethodHandleUtil.methodHandle(TestSingleMapBlockWriter.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestSingleMapBlockWriter.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]));
        MapBlockBuilder mapBlockBuilder = (MapBlockBuilder)mapType.createBlockBuilder(null, 100);
        for (int i = 0; i < 100; ++i) {
            SingleMapBlockWriter singleMapBlockWriter = mapBlockBuilder.beginBlockEntry();
            int expectedSize = 0;
            for (int j = 0; j < 10; ++j) {
                Assert.assertEquals((long)singleMapBlockWriter.getSizeInBytes(), (long)expectedSize, (String)("For Index: " + i));
                BigintType.BIGINT.writeLong((BlockBuilder)singleMapBlockWriter, (long)j);
                Assert.assertEquals((long)singleMapBlockWriter.getSizeInBytes(), (long)(expectedSize += 9), (String)("For Index: " + i));
                BlockBuilder innerMapWriter = singleMapBlockWriter.beginBlockEntry();
                Assert.assertEquals((long)singleMapBlockWriter.getSizeInBytes(), (long)expectedSize, (String)("For Index: " + i));
                BigintType.BIGINT.writeLong(innerMapWriter, (long)(i * 2));
                VarcharType.VARCHAR.writeSlice(innerMapWriter, Slices.utf8Slice((String)"Value1"));
                Assert.assertEquals((long)singleMapBlockWriter.getSizeInBytes(), (long)(expectedSize += 28), (String)("For Index: " + i));
                BigintType.BIGINT.writeLong(innerMapWriter, (long)(i * 2 + 1));
                VarcharType.VARCHAR.writeSlice(innerMapWriter, Slices.utf8Slice((String)"Value2"));
                Assert.assertEquals((long)singleMapBlockWriter.getSizeInBytes(), (long)(expectedSize += 28), (String)("For Index: " + i));
                singleMapBlockWriter.closeEntry();
                Assert.assertEquals((long)singleMapBlockWriter.getSizeInBytes(), (long)(expectedSize += 5), (String)("For Index: " + i));
            }
            mapBlockBuilder.closeEntry();
            Assert.assertEquals((long)singleMapBlockWriter.getSizeInBytes(), (long)expectedSize, (String)("For Index: " + i));
            mapBlockBuilder.appendNull();
        }
    }

    @Test
    public void testSizeInBytesForNulls() {
        MapType innerMapType = new MapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR, MethodHandleUtil.methodHandle(TestSingleMapBlockWriter.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestSingleMapBlockWriter.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]));
        MapType mapType = new MapType((Type)BigintType.BIGINT, (Type)innerMapType, MethodHandleUtil.methodHandle(TestSingleMapBlockWriter.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestSingleMapBlockWriter.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]));
        MapBlockBuilder mapBlockBuilder = (MapBlockBuilder)mapType.createBlockBuilder(null, 100);
        for (int i = 0; i < 100; ++i) {
            SingleMapBlockWriter singleMapBlockWriter = mapBlockBuilder.beginBlockEntry();
            int expectedSize = 0;
            for (int j = 0; j < 10; ++j) {
                Assert.assertEquals((long)singleMapBlockWriter.getSizeInBytes(), (long)expectedSize, (String)("For Index: " + i));
                BigintType.BIGINT.writeLong((BlockBuilder)singleMapBlockWriter, (long)j);
                Assert.assertEquals((long)singleMapBlockWriter.getSizeInBytes(), (long)(expectedSize += 9), (String)("For Index: " + i));
                BlockBuilder innerMapWriter = singleMapBlockWriter.beginBlockEntry();
                Assert.assertEquals((long)singleMapBlockWriter.getSizeInBytes(), (long)expectedSize, (String)("For Index: " + i));
                BigintType.BIGINT.writeLong(innerMapWriter, (long)(i * 2));
                innerMapWriter.appendNull();
                Assert.assertEquals((long)singleMapBlockWriter.getSizeInBytes(), (long)(expectedSize += 22), (String)("For Index: " + i));
                BigintType.BIGINT.writeLong(innerMapWriter, (long)(i * 2 + 1));
                innerMapWriter.appendNull();
                Assert.assertEquals((long)singleMapBlockWriter.getSizeInBytes(), (long)(expectedSize += 22), (String)("For Index: " + i));
                singleMapBlockWriter.closeEntry();
                Assert.assertEquals((long)singleMapBlockWriter.getSizeInBytes(), (long)(expectedSize += 5), (String)("For Index: " + i));
            }
            mapBlockBuilder.closeEntry();
            Assert.assertEquals((long)singleMapBlockWriter.getSizeInBytes(), (long)expectedSize, (String)("For Index: " + i));
        }
    }

    public static void throwUnsupportedOperation() {
        throw new UnsupportedOperationException();
    }
}

