/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.predicate;

import com.facebook.presto.common.predicate.Marker;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.SortedRangeSet;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.testng.annotations.Test;

@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=10)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkSortedRangeSet {
    @Benchmark
    public SortedRangeSet benchmarkBuilder(Data data) {
        SortedRangeSet build = new SortedRangeSet.Builder((Type)BigintType.BIGINT).addAll(data.ranges).build();
        return build;
    }

    @Benchmark
    public List<Boolean> equalsSmall(Data data) {
        return this.benchmarkEquals(data.smallRanges);
    }

    @Benchmark
    public List<Boolean> equalsLarge(Data data) {
        return this.benchmarkEquals(data.largeRanges);
    }

    private List<Boolean> benchmarkEquals(List<SortedRangeSet> dataRanges) {
        ArrayList<Boolean> result = new ArrayList<Boolean>(dataRanges.size() - 1);
        for (int index = 0; index < dataRanges.size() - 1; ++index) {
            result.add(dataRanges.get(index).equals((Object)dataRanges.get(index + 1)));
        }
        return result;
    }

    @Benchmark
    public List<SortedRangeSet> unionSmall(Data data) {
        return this.benchmarkUnion(data.smallRanges);
    }

    @Benchmark
    public List<SortedRangeSet> unionLarge(Data data) {
        return this.benchmarkUnion(data.largeRanges);
    }

    private List<SortedRangeSet> benchmarkUnion(List<SortedRangeSet> dataRanges) {
        ArrayList<SortedRangeSet> result = new ArrayList<SortedRangeSet>(dataRanges.size() - 1);
        for (int index = 0; index < dataRanges.size() - 1; ++index) {
            result.add(dataRanges.get(index).union((ValueSet)dataRanges.get(index + 1)));
        }
        return result;
    }

    @Benchmark
    public List<Boolean> overlapsSmall(Data data) {
        return this.benchmarkOverlaps(data.smallRanges);
    }

    @Benchmark
    public List<Boolean> overlapsLarge(Data data) {
        return this.benchmarkOverlaps(data.largeRanges);
    }

    private List<Boolean> benchmarkOverlaps(List<SortedRangeSet> dataRanges) {
        ArrayList<Boolean> result = new ArrayList<Boolean>(dataRanges.size() - 1);
        for (int index = 0; index < dataRanges.size() - 1; ++index) {
            result.add(dataRanges.get(index).overlaps((ValueSet)dataRanges.get(index + 1)));
        }
        return result;
    }

    @Benchmark
    public long containsValueSmall(Data data) {
        return this.benchmarkContainsValue(data.smallRanges);
    }

    @Benchmark
    public long containsValueLarge(Data data) {
        return this.benchmarkContainsValue(data.largeRanges);
    }

    private long benchmarkContainsValue(List<SortedRangeSet> dataRanges) {
        int totalChecks = 5000000;
        long testedValuesTo = 10000L;
        long checksPerSet = totalChecks / dataRanges.size();
        long step = testedValuesTo / checksPerSet;
        long found = 0L;
        for (SortedRangeSet dataRange : dataRanges) {
            for (long i = 0L; i < testedValuesTo; i += step) {
                boolean contained = dataRange.containsValue((Object)i);
                if (!contained) continue;
                ++found;
            }
        }
        return found;
    }

    @Benchmark
    public List<SortedRangeSet> complementSmall(Data data) {
        return this.benchmarkComplement(data.smallRanges);
    }

    @Benchmark
    public List<SortedRangeSet> complementLarge(Data data) {
        return this.benchmarkComplement(data.largeRanges);
    }

    private List<SortedRangeSet> benchmarkComplement(List<SortedRangeSet> dataRanges) {
        ArrayList<SortedRangeSet> result = new ArrayList<SortedRangeSet>(dataRanges.size());
        for (SortedRangeSet dataRange : dataRanges) {
            result.add(dataRange.complement());
        }
        return result;
    }

    @Benchmark
    public List<Integer> getOrderedRangesSmall(Data data) {
        return this.benchmarkGetOrderedRanges(data.smallRanges);
    }

    @Benchmark
    public List<Integer> getOrderedRangesLarge(Data data) {
        return this.benchmarkGetOrderedRanges(data.largeRanges);
    }

    private List<Integer> benchmarkGetOrderedRanges(List<SortedRangeSet> dataRanges) {
        ArrayList<Integer> result = new ArrayList<Integer>(dataRanges.size());
        for (int index = 0; index < dataRanges.size(); ++index) {
            int hash = 0;
            for (Range orderedRange : dataRanges.get(index).getRanges().getOrderedRanges()) {
                if (!orderedRange.isLowUnbounded()) {
                    hash = hash * 31 + orderedRange.getLowBoundedValue().hashCode();
                }
                if (orderedRange.isHighUnbounded()) continue;
                hash = hash * 31 + orderedRange.getHighBoundedValue().hashCode();
            }
            result.add(hash);
        }
        return result;
    }

    @Test
    public void test() {
        Data data = new Data();
        data.init();
        this.benchmarkBuilder(data);
        this.equalsSmall(data);
        this.equalsLarge(data);
        this.unionSmall(data);
        this.unionLarge(data);
        this.overlapsSmall(data);
        this.overlapsLarge(data);
        this.containsValueSmall(data);
        this.containsValueLarge(data);
        this.complementSmall(data);
        this.complementLarge(data);
        this.getOrderedRangesSmall(data);
        this.getOrderedRangesLarge(data);
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkSortedRangeSet.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class Data {
        public List<Range> ranges;
        public List<SortedRangeSet> smallRanges;
        public List<SortedRangeSet> largeRanges;

        @Setup(value=Level.Iteration)
        public void init() {
            this.ranges = new ArrayList<Range>();
            int factor = 0;
            for (int i = 0; i < 10000; ++i) {
                long from = ThreadLocalRandom.current().nextLong(100L) + (long)(factor * 100);
                long to = ThreadLocalRandom.current().nextLong(100L) + (long)((factor + 1) * 100);
                ++factor;
                this.ranges.add(new Range(Marker.above((Type)BigintType.BIGINT, (Object)from), Marker.below((Type)BigintType.BIGINT, (Object)to)));
            }
            this.smallRanges = this.generateRangeSets(500000, 2);
            this.largeRanges = this.generateRangeSets(5000, 300);
        }

        private List<SortedRangeSet> generateRangeSets(int count, int size) {
            ArrayList<SortedRangeSet> sortedRangeSets = new ArrayList<SortedRangeSet>();
            for (int i = 0; i < count; ++i) {
                sortedRangeSets.add(this.generateRangeSet(size));
            }
            return sortedRangeSets;
        }

        private SortedRangeSet generateRangeSet(int size) {
            ArrayList<Range> selectedRanges = new ArrayList<Range>();
            for (int i = 0; i < size; ++i) {
                selectedRanges.add(this.ranges.get(ThreadLocalRandom.current().nextInt(this.ranges.size())));
            }
            return SortedRangeSet.copyOf((Type)BigintType.BIGINT, selectedRanges);
        }
    }
}

