/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.predicate;

import com.facebook.presto.common.predicate.TupleDomainFilter;
import com.facebook.presto.common.type.Decimals;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.math.BigDecimal;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTupleDomainFilter {
    @Test
    public void testBigintRange() {
        TupleDomainFilter.BigintRange filter = TupleDomainFilter.BigintRange.of((long)1L, (long)1L, (boolean)false);
        Assert.assertTrue((boolean)filter.testLong(1L));
        Assert.assertFalse((boolean)filter.testNull());
        Assert.assertFalse((boolean)filter.testLong(0L));
        Assert.assertFalse((boolean)filter.testLong(11L));
        filter = TupleDomainFilter.BigintRange.of((long)1L, (long)10L, (boolean)false);
        Assert.assertTrue((boolean)filter.testLong(1L));
        Assert.assertTrue((boolean)filter.testLong(10L));
        Assert.assertFalse((boolean)filter.testNull());
        Assert.assertFalse((boolean)filter.testLong(0L));
        Assert.assertFalse((boolean)filter.testLong(11L));
    }

    @Test
    public void testBigintValuesUsingHashTable() {
        TupleDomainFilter.BigintValuesUsingHashTable filter = TupleDomainFilter.BigintValuesUsingHashTable.of((long)1L, (long)1000L, (long[])new long[]{1L, 10L, 100L, 1000L}, (boolean)false);
        Assert.assertTrue((boolean)filter.testLong(1L));
        Assert.assertTrue((boolean)filter.testLong(10L));
        Assert.assertTrue((boolean)filter.testLong(100L));
        Assert.assertTrue((boolean)filter.testLong(1000L));
        Assert.assertFalse((boolean)filter.testNull());
        Assert.assertFalse((boolean)filter.testLong(-1L));
        Assert.assertFalse((boolean)filter.testLong(2L));
        Assert.assertFalse((boolean)filter.testLong(102L));
        Assert.assertFalse((boolean)filter.testLong(Long.MAX_VALUE));
    }

    @Test
    public void testBigintValuesUsingBitmask() {
        TupleDomainFilter.BigintValuesUsingBitmask filter = TupleDomainFilter.BigintValuesUsingBitmask.of((long)1L, (long)1000L, (long[])new long[]{1L, 10L, 100L, 1000L}, (boolean)false);
        Assert.assertTrue((boolean)filter.testLong(1L));
        Assert.assertTrue((boolean)filter.testLong(10L));
        Assert.assertTrue((boolean)filter.testLong(100L));
        Assert.assertTrue((boolean)filter.testLong(1000L));
        Assert.assertFalse((boolean)filter.testNull());
        Assert.assertFalse((boolean)filter.testLong(-1L));
        Assert.assertFalse((boolean)filter.testLong(2L));
        Assert.assertFalse((boolean)filter.testLong(102L));
        Assert.assertFalse((boolean)filter.testLong(Long.MAX_VALUE));
    }

    @Test
    public void testBigintMultiRange() {
        TupleDomainFilter.BigintMultiRange filter = TupleDomainFilter.BigintMultiRange.of((List)ImmutableList.of((Object)TupleDomainFilter.BigintRange.of((long)1L, (long)10L, (boolean)false), (Object)TupleDomainFilter.BigintRange.of((long)100L, (long)120L, (boolean)false)), (boolean)false);
        Assert.assertTrue((boolean)filter.testLong(1L));
        Assert.assertTrue((boolean)filter.testLong(5L));
        Assert.assertTrue((boolean)filter.testLong(10L));
        Assert.assertTrue((boolean)filter.testLong(100L));
        Assert.assertTrue((boolean)filter.testLong(110L));
        Assert.assertTrue((boolean)filter.testLong(120L));
        Assert.assertFalse((boolean)filter.testNull());
        Assert.assertFalse((boolean)filter.testLong(0L));
        Assert.assertFalse((boolean)filter.testLong(50L));
        Assert.assertFalse((boolean)filter.testLong(150L));
    }

    @Test
    public void testBooleanValue() {
        TupleDomainFilter.BooleanValue filter = TupleDomainFilter.BooleanValue.of((boolean)true, (boolean)false);
        Assert.assertTrue((boolean)filter.testBoolean(true));
        Assert.assertFalse((boolean)filter.testNull());
        Assert.assertFalse((boolean)filter.testBoolean(false));
        filter = TupleDomainFilter.BooleanValue.of((boolean)false, (boolean)false);
        Assert.assertTrue((boolean)filter.testBoolean(false));
        Assert.assertFalse((boolean)filter.testNull());
        Assert.assertFalse((boolean)filter.testBoolean(true));
    }

    @Test
    public void testDoubleRange() {
        TupleDomainFilter.DoubleRange filter = TupleDomainFilter.DoubleRange.of((double)1.2, (boolean)false, (boolean)false, (double)1.2, (boolean)false, (boolean)false, (boolean)false);
        Assert.assertTrue((boolean)filter.testDouble(1.2));
        Assert.assertFalse((boolean)filter.testNull());
        Assert.assertFalse((boolean)filter.testDouble(1.3));
        filter = TupleDomainFilter.DoubleRange.of((double)Double.MIN_VALUE, (boolean)true, (boolean)true, (double)1.2, (boolean)false, (boolean)false, (boolean)false);
        Assert.assertTrue((boolean)filter.testDouble(1.2));
        Assert.assertTrue((boolean)filter.testDouble(1.1));
        Assert.assertFalse((boolean)filter.testNull());
        Assert.assertFalse((boolean)filter.testDouble(1.3));
        filter = TupleDomainFilter.DoubleRange.of((double)1.2, (boolean)false, (boolean)true, (double)Double.MAX_VALUE, (boolean)true, (boolean)true, (boolean)false);
        Assert.assertTrue((boolean)filter.testDouble(1.3));
        Assert.assertTrue((boolean)filter.testDouble(5.6));
        Assert.assertFalse((boolean)filter.testNull());
        Assert.assertFalse((boolean)filter.testDouble(1.2));
        Assert.assertFalse((boolean)filter.testDouble(-19.267));
        filter = TupleDomainFilter.DoubleRange.of((double)1.2, (boolean)false, (boolean)false, (double)3.4, (boolean)false, (boolean)false, (boolean)false);
        Assert.assertTrue((boolean)filter.testDouble(1.2));
        Assert.assertTrue((boolean)filter.testDouble(1.5));
        Assert.assertTrue((boolean)filter.testDouble(3.4));
        Assert.assertFalse((boolean)filter.testNull());
        Assert.assertFalse((boolean)filter.testDouble(-0.3));
        Assert.assertFalse((boolean)filter.testDouble(55.6));
        Assert.assertFalse((boolean)filter.testDouble(Double.NaN));
        try {
            TupleDomainFilter.DoubleRange.of((double)Double.NaN, (boolean)false, (boolean)false, (double)Double.NaN, (boolean)false, (boolean)false, (boolean)false);
            Assert.fail((String)"able to create a DoubleRange with NaN");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testFloatRange() {
        TupleDomainFilter.FloatRange filter = TupleDomainFilter.FloatRange.of((float)1.2f, (boolean)false, (boolean)false, (float)1.2f, (boolean)false, (boolean)false, (boolean)false);
        Assert.assertTrue((boolean)filter.testFloat(1.2f));
        Assert.assertFalse((boolean)filter.testNull());
        Assert.assertFalse((boolean)filter.testFloat(1.1f));
        filter = TupleDomainFilter.FloatRange.of((float)Float.MIN_VALUE, (boolean)true, (boolean)true, (float)1.2f, (boolean)false, (boolean)true, (boolean)false);
        Assert.assertTrue((boolean)filter.testFloat(1.1f));
        Assert.assertFalse((boolean)filter.testNull());
        Assert.assertFalse((boolean)filter.testFloat(1.2f));
        Assert.assertFalse((boolean)filter.testFloat(15.632f));
        filter = TupleDomainFilter.FloatRange.of((float)1.2f, (boolean)false, (boolean)false, (float)3.4f, (boolean)false, (boolean)false, (boolean)false);
        Assert.assertTrue((boolean)filter.testFloat(1.2f));
        Assert.assertTrue((boolean)filter.testFloat(2.3f));
        Assert.assertTrue((boolean)filter.testFloat(3.4f));
        Assert.assertFalse((boolean)filter.testNull());
        Assert.assertFalse((boolean)filter.testFloat(1.1f));
        Assert.assertFalse((boolean)filter.testFloat(15.632f));
        Assert.assertFalse((boolean)filter.testFloat(Float.NaN));
        try {
            TupleDomainFilter.FloatRange.of((float)Float.NaN, (boolean)false, (boolean)false, (float)Float.NaN, (boolean)false, (boolean)false, (boolean)false);
            Assert.fail((String)"able to create a FloatRange with NaN");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testLongDecimalRange() {
        Slice decimal = TestTupleDomainFilter.decimal("123.45");
        TupleDomainFilter.LongDecimalRange filter = TupleDomainFilter.LongDecimalRange.of((long)decimal.getLong(0), (long)decimal.getLong(8), (boolean)false, (boolean)false, (long)decimal.getLong(0), (long)decimal.getLong(8), (boolean)false, (boolean)false, (boolean)false);
        Assert.assertTrue((boolean)filter.testDecimal(decimal.getLong(0), decimal.getLong(8)));
        Assert.assertFalse((boolean)filter.testNull());
        Assert.assertFalse((boolean)filter.testDecimal(TestTupleDomainFilter.decimal("12.34").getLong(0), TestTupleDomainFilter.decimal("12.34").getLong(8)));
        filter = TupleDomainFilter.LongDecimalRange.of((long)Long.MIN_VALUE, (long)Long.MIN_VALUE, (boolean)true, (boolean)true, (long)decimal.getLong(0), (long)decimal.getLong(8), (boolean)false, (boolean)false, (boolean)false);
        Assert.assertTrue((boolean)filter.testDecimal(decimal.getLong(0), decimal.getLong(8)));
        Assert.assertTrue((boolean)filter.testDecimal(TestTupleDomainFilter.decimal("12.34").getLong(0), TestTupleDomainFilter.decimal("12.34").getLong(8)));
        Assert.assertFalse((boolean)filter.testNull());
        Assert.assertFalse((boolean)filter.testDecimal(TestTupleDomainFilter.decimal("1234.56").getLong(0), TestTupleDomainFilter.decimal("1234.56").getLong(8)));
    }

    private static Slice decimal(String value) {
        return Decimals.encodeScaledValue((BigDecimal)new BigDecimal(value));
    }

    @Test
    public void testBytesRange() {
        TupleDomainFilter.BytesRange filter = TupleDomainFilter.BytesRange.of((byte[])TestTupleDomainFilter.toBytes("abc"), (boolean)false, (byte[])TestTupleDomainFilter.toBytes("abc"), (boolean)false, (boolean)false);
        Assert.assertTrue((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("abc"), 0, 3));
        Assert.assertFalse((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("acb"), 0, 3));
        Assert.assertTrue((boolean)filter.testLength(3));
        Assert.assertFalse((boolean)filter.testNull());
        Assert.assertFalse((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("apple"), 0, 5));
        Assert.assertFalse((boolean)filter.testLength(4));
        String theBestOfTimes = "It was the best of times, it was the worst of times, it was the age of wisdom, it was the age of foolishness, it was the epoch of belief, it was the epoch of incredulity,...";
        filter = TupleDomainFilter.BytesRange.of(null, (boolean)true, (byte[])TestTupleDomainFilter.toBytes(theBestOfTimes), (boolean)false, (boolean)false);
        Assert.assertTrue((boolean)filter.testBytes(TestTupleDomainFilter.toBytes(theBestOfTimes), 0, theBestOfTimes.length()));
        Assert.assertTrue((boolean)filter.testBytes(TestTupleDomainFilter.toBytes(theBestOfTimes), 0, 5));
        Assert.assertTrue((boolean)filter.testBytes(TestTupleDomainFilter.toBytes(theBestOfTimes), 0, 50));
        Assert.assertTrue((boolean)filter.testBytes(TestTupleDomainFilter.toBytes(theBestOfTimes), 0, 100));
        Assert.assertTrue((boolean)filter.testLength(1));
        Assert.assertTrue((boolean)filter.testLength(1000));
        Assert.assertFalse((boolean)filter.testNull());
        Assert.assertFalse((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("Zzz"), 0, 3));
        Assert.assertFalse((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("It was the best of times, zzz"), 0, 30));
        filter = TupleDomainFilter.BytesRange.of((byte[])TestTupleDomainFilter.toBytes("abc"), (boolean)false, null, (boolean)true, (boolean)false);
        Assert.assertTrue((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("abc"), 0, 3));
        Assert.assertTrue((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("ad"), 0, 2));
        Assert.assertTrue((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("apple"), 0, 5));
        Assert.assertTrue((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("banana"), 0, 6));
        Assert.assertFalse((boolean)filter.testNull());
        Assert.assertFalse((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("ab"), 0, 2));
        Assert.assertFalse((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("_abc"), 0, 4));
        filter = TupleDomainFilter.BytesRange.of((byte[])TestTupleDomainFilter.toBytes("apple"), (boolean)false, (byte[])TestTupleDomainFilter.toBytes("banana"), (boolean)false, (boolean)false);
        Assert.assertTrue((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("apple"), 0, 5));
        Assert.assertTrue((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("banana"), 0, 6));
        Assert.assertTrue((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("avocado"), 0, 7));
        Assert.assertFalse((boolean)filter.testNull());
        Assert.assertFalse((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("camel"), 0, 5));
        Assert.assertFalse((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("_abc"), 0, 4));
        filter = TupleDomainFilter.BytesRange.of((byte[])TestTupleDomainFilter.toBytes("apple"), (boolean)true, (byte[])TestTupleDomainFilter.toBytes("banana"), (boolean)false, (boolean)false);
        Assert.assertTrue((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("banana"), 0, 6));
        Assert.assertTrue((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("avocado"), 0, 7));
        Assert.assertFalse((boolean)filter.testNull());
        Assert.assertFalse((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("apple"), 0, 5));
        Assert.assertFalse((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("camel"), 0, 5));
        Assert.assertFalse((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("_abc"), 0, 4));
        filter = TupleDomainFilter.BytesRange.of((byte[])TestTupleDomainFilter.toBytes("apple"), (boolean)true, (byte[])TestTupleDomainFilter.toBytes("banana"), (boolean)true, (boolean)false);
        Assert.assertTrue((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("avocado"), 0, 7));
        Assert.assertFalse((boolean)filter.testNull());
        Assert.assertFalse((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("apple"), 0, 5));
        Assert.assertFalse((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("banana"), 0, 6));
        Assert.assertFalse((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("camel"), 0, 5));
        Assert.assertFalse((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("_abc"), 0, 4));
    }

    @Test
    public void testBytesValues() {
        int i;
        TupleDomainFilter.BytesValues filter = TupleDomainFilter.BytesValues.of((byte[][])new byte[][]{TestTupleDomainFilter.toBytes("Igne"), TestTupleDomainFilter.toBytes("natura"), TestTupleDomainFilter.toBytes("renovitur"), TestTupleDomainFilter.toBytes("integra.")}, (boolean)false);
        Assert.assertTrue((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("Igne"), 0, 4));
        Assert.assertTrue((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("natura"), 0, 6));
        Assert.assertTrue((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("renovitur"), 0, 9));
        Assert.assertTrue((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("integra."), 0, 8));
        Assert.assertFalse((boolean)filter.testNull());
        Assert.assertFalse((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("natura"), 0, 5));
        Assert.assertFalse((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("apple"), 0, 5));
        byte[][] testValues = new byte[1000][];
        byte[][] filterValues = new byte[testValues.length / 9 + 1][];
        byte base = 0;
        int numFilterValues = 0;
        for (i = 0; i < testValues.length; ++i) {
            testValues[i] = TestTupleDomainFilter.sequentialBytes(base, i);
            base = (byte)(base + i);
            if (i % 9 != 0) continue;
            filterValues[numFilterValues++] = testValues[i];
        }
        filter = TupleDomainFilter.BytesValues.of((byte[][])filterValues, (boolean)false);
        Assert.assertFalse((boolean)filter.testLength(10000));
        for (i = 0; i < testValues.length; ++i) {
            Assert.assertEquals((boolean)filter.testLength(i), (i % 9 == 0 ? 1 : 0) != 0);
            Assert.assertEquals((i % 9 == 0 ? 1 : 0) != 0, (boolean)filter.testBytes(testValues[i], 0, testValues[i].length));
        }
    }

    @Test
    public void testBytesValuesExclusive() {
        TupleDomainFilter.BytesValuesExclusive filter = TupleDomainFilter.BytesValuesExclusive.of((byte[][])new byte[][]{TestTupleDomainFilter.toBytes("Igne"), TestTupleDomainFilter.toBytes("natura"), TestTupleDomainFilter.toBytes("renovitur"), TestTupleDomainFilter.toBytes("integra.")}, (boolean)false);
        Assert.assertFalse((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("Igne"), 0, 4));
        Assert.assertFalse((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("natura"), 0, 6));
        Assert.assertFalse((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("renovitur"), 0, 9));
        Assert.assertFalse((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("integra."), 0, 8));
        Assert.assertFalse((boolean)filter.testNull());
        Assert.assertTrue((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("natura"), 0, 5));
        Assert.assertTrue((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("apple"), 0, 5));
    }

    private static byte[] sequentialBytes(byte base, int length) {
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)(base + i);
        }
        return bytes;
    }

    private static byte[] toBytes(String value) {
        return Slices.utf8Slice((String)value).getBytes();
    }

    @Test
    public void testMultiRange() {
        TupleDomainFilter.MultiRange filter = TupleDomainFilter.MultiRange.of((List)ImmutableList.of((Object)TupleDomainFilter.BytesRange.of((byte[])TestTupleDomainFilter.toBytes("abc"), (boolean)false, (byte[])TestTupleDomainFilter.toBytes("abc"), (boolean)false, (boolean)false), (Object)TupleDomainFilter.BytesRange.of((byte[])TestTupleDomainFilter.toBytes("dragon"), (boolean)false, null, (boolean)true, (boolean)false)), (boolean)false, (boolean)false);
        Assert.assertTrue((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("abc"), 0, 3));
        Assert.assertTrue((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("dragon"), 0, 6));
        Assert.assertTrue((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("dragonfly"), 0, 9));
        Assert.assertTrue((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("drought"), 0, 7));
        Assert.assertFalse((boolean)filter.testNull());
        Assert.assertFalse((boolean)filter.testBytes(TestTupleDomainFilter.toBytes("apple"), 0, 5));
        filter = TupleDomainFilter.MultiRange.of((List)ImmutableList.of((Object)TupleDomainFilter.DoubleRange.of((double)Double.MIN_VALUE, (boolean)true, (boolean)true, (double)1.2, (boolean)false, (boolean)true, (boolean)false), (Object)TupleDomainFilter.DoubleRange.of((double)1.2, (boolean)false, (boolean)true, (double)Double.MAX_VALUE, (boolean)true, (boolean)true, (boolean)false)), (boolean)false, (boolean)false);
        Assert.assertTrue((boolean)filter.testDouble(1.1));
        Assert.assertTrue((boolean)filter.testDouble(1.3));
        Assert.assertFalse((boolean)filter.testNull());
        Assert.assertFalse((boolean)filter.testDouble(Double.NaN));
        Assert.assertFalse((boolean)filter.testDouble(1.2));
        Slice decimal = TestTupleDomainFilter.decimal("123.45");
        filter = TupleDomainFilter.MultiRange.of((List)ImmutableList.of((Object)TupleDomainFilter.LongDecimalRange.of((long)Long.MIN_VALUE, (long)Long.MIN_VALUE, (boolean)true, (boolean)true, (long)decimal.getLong(0), (long)decimal.getLong(8), (boolean)false, (boolean)true, (boolean)false), (Object)TupleDomainFilter.LongDecimalRange.of((long)decimal.getLong(0), (long)decimal.getLong(8), (boolean)false, (boolean)true, (long)Long.MAX_VALUE, (long)Long.MAX_VALUE, (boolean)true, (boolean)true, (boolean)false)), (boolean)false, (boolean)false);
        Assert.assertTrue((boolean)filter.testDecimal(TestTupleDomainFilter.decimal("1.23").getLong(0), TestTupleDomainFilter.decimal("1.23").getLong(8)));
        Assert.assertTrue((boolean)filter.testDecimal(TestTupleDomainFilter.decimal("12.34").getLong(0), TestTupleDomainFilter.decimal("12.34").getLong(8)));
        Assert.assertFalse((boolean)filter.testNull());
        Assert.assertFalse((boolean)filter.testFloat(Float.NaN));
        Assert.assertFalse((boolean)filter.testDecimal(decimal.getLong(0), decimal.getLong(8)));
        filter = TupleDomainFilter.MultiRange.of((List)ImmutableList.of((Object)TupleDomainFilter.FloatRange.of((float)Float.MIN_VALUE, (boolean)true, (boolean)true, (float)1.2f, (boolean)false, (boolean)true, (boolean)false), (Object)TupleDomainFilter.FloatRange.of((float)1.2f, (boolean)false, (boolean)true, (float)Float.MAX_VALUE, (boolean)true, (boolean)true, (boolean)false)), (boolean)false, (boolean)false);
        Assert.assertTrue((boolean)filter.testFloat(1.1f));
        Assert.assertTrue((boolean)filter.testFloat(1.3f));
        Assert.assertFalse((boolean)filter.testNull());
        Assert.assertFalse((boolean)filter.testFloat(1.2f));
    }

    @Test
    public void testMultiRangeWithNaNs() {
        TupleDomainFilter.MultiRange filter = TupleDomainFilter.MultiRange.of((List)ImmutableList.of((Object)TupleDomainFilter.FloatRange.of((float)Float.MIN_VALUE, (boolean)true, (boolean)true, (float)1.2f, (boolean)false, (boolean)true, (boolean)false), (Object)TupleDomainFilter.FloatRange.of((float)1.2f, (boolean)false, (boolean)true, (float)Float.MAX_VALUE, (boolean)true, (boolean)true, (boolean)false)), (boolean)false, (boolean)true);
        Assert.assertTrue((boolean)filter.testFloat(Float.NaN));
        Assert.assertFalse((boolean)filter.testFloat(1.2f));
        Assert.assertTrue((boolean)filter.testFloat(1.1f));
        filter = TupleDomainFilter.MultiRange.of((List)ImmutableList.of((Object)TupleDomainFilter.DoubleRange.of((double)Double.MIN_VALUE, (boolean)true, (boolean)true, (double)1.2, (boolean)false, (boolean)true, (boolean)false), (Object)TupleDomainFilter.DoubleRange.of((double)1.2, (boolean)false, (boolean)true, (double)Double.MAX_VALUE, (boolean)true, (boolean)true, (boolean)false)), (boolean)false, (boolean)true);
        Assert.assertTrue((boolean)filter.testDouble(Double.NaN));
        Assert.assertFalse((boolean)filter.testDouble(1.2));
        Assert.assertTrue((boolean)filter.testDouble(1.1));
        filter = TupleDomainFilter.MultiRange.of((List)ImmutableList.of((Object)TupleDomainFilter.FloatRange.of((float)Float.MIN_VALUE, (boolean)true, (boolean)true, (float)1.2f, (boolean)false, (boolean)true, (boolean)false), (Object)TupleDomainFilter.FloatRange.of((float)1.2f, (boolean)false, (boolean)true, (float)Float.MAX_VALUE, (boolean)true, (boolean)true, (boolean)false)), (boolean)false, (boolean)false);
        Assert.assertFalse((boolean)filter.testFloat(Float.NaN));
        Assert.assertTrue((boolean)filter.testFloat(1.0f));
        filter = TupleDomainFilter.MultiRange.of((List)ImmutableList.of((Object)TupleDomainFilter.DoubleRange.of((double)Double.MIN_VALUE, (boolean)true, (boolean)true, (double)1.2, (boolean)false, (boolean)true, (boolean)false), (Object)TupleDomainFilter.DoubleRange.of((double)1.2, (boolean)false, (boolean)true, (double)Double.MAX_VALUE, (boolean)true, (boolean)true, (boolean)false)), (boolean)false, (boolean)false);
        Assert.assertFalse((boolean)filter.testDouble(Double.NaN));
        Assert.assertTrue((boolean)filter.testDouble(1.4));
        filter = TupleDomainFilter.MultiRange.of((List)ImmutableList.of((Object)TupleDomainFilter.FloatRange.of((float)Float.MIN_VALUE, (boolean)true, (boolean)true, (float)1.2f, (boolean)false, (boolean)true, (boolean)false), (Object)TupleDomainFilter.FloatRange.of((float)1.2f, (boolean)false, (boolean)true, (float)1.3f, (boolean)false, (boolean)true, (boolean)false), (Object)TupleDomainFilter.FloatRange.of((float)1.3f, (boolean)false, (boolean)true, (float)Float.MAX_VALUE, (boolean)true, (boolean)true, (boolean)false)), (boolean)false, (boolean)true);
        Assert.assertTrue((boolean)filter.testFloat(Float.NaN));
        Assert.assertFalse((boolean)filter.testFloat(1.2f));
        Assert.assertFalse((boolean)filter.testFloat(1.3f));
        Assert.assertTrue((boolean)filter.testFloat(1.4f));
        Assert.assertTrue((boolean)filter.testFloat(1.1f));
        filter = TupleDomainFilter.MultiRange.of((List)ImmutableList.of((Object)TupleDomainFilter.DoubleRange.of((double)Double.MIN_VALUE, (boolean)true, (boolean)true, (double)1.2, (boolean)false, (boolean)true, (boolean)false), (Object)TupleDomainFilter.DoubleRange.of((double)1.2, (boolean)false, (boolean)true, (double)1.3, (boolean)false, (boolean)true, (boolean)false), (Object)TupleDomainFilter.DoubleRange.of((double)1.3, (boolean)false, (boolean)true, (double)Double.MAX_VALUE, (boolean)true, (boolean)true, (boolean)false)), (boolean)false, (boolean)true);
        Assert.assertTrue((boolean)filter.testDouble(Double.NaN));
        Assert.assertFalse((boolean)filter.testDouble(1.2));
        Assert.assertFalse((boolean)filter.testDouble(1.3));
        Assert.assertTrue((boolean)filter.testDouble(1.4));
        Assert.assertTrue((boolean)filter.testDouble(1.1));
        filter = TupleDomainFilter.MultiRange.of((List)ImmutableList.of((Object)TupleDomainFilter.FloatRange.of((float)Float.MIN_VALUE, (boolean)true, (boolean)true, (float)1.2f, (boolean)false, (boolean)true, (boolean)false), (Object)TupleDomainFilter.FloatRange.of((float)1.2f, (boolean)false, (boolean)true, (float)Float.MAX_VALUE, (boolean)true, (boolean)true, (boolean)false)), (boolean)false, (boolean)false);
        Assert.assertFalse((boolean)filter.testFloat(Float.NaN));
        Assert.assertFalse((boolean)filter.testFloat(1.2f));
        Assert.assertTrue((boolean)filter.testFloat(1.3f));
        filter = TupleDomainFilter.MultiRange.of((List)ImmutableList.of((Object)TupleDomainFilter.DoubleRange.of((double)Double.MIN_VALUE, (boolean)true, (boolean)true, (double)1.2, (boolean)false, (boolean)true, (boolean)false), (Object)TupleDomainFilter.DoubleRange.of((double)1.2, (boolean)false, (boolean)true, (double)Double.MAX_VALUE, (boolean)true, (boolean)true, (boolean)false)), (boolean)false, (boolean)false);
        Assert.assertFalse((boolean)filter.testDouble(Double.NaN));
        Assert.assertFalse((boolean)filter.testDouble(1.2));
        Assert.assertTrue((boolean)filter.testDouble(1.3));
    }
}

