/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.type;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.JsonCodecFactory;
import com.facebook.airlift.json.JsonObjectMapperProvider;
import com.facebook.presto.common.type.ParameterKind;
import javax.inject.Provider;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestParameterKind {
    public static final JsonCodec<ParameterKind> PARAMETER_KIND_CODEC;

    @Test
    public void testSerialize() {
        Assert.assertEquals((String)PARAMETER_KIND_CODEC.toJson((Object)ParameterKind.TYPE), (String)"\"TYPE_SIGNATURE\"");
        Assert.assertEquals((String)PARAMETER_KIND_CODEC.toJson((Object)ParameterKind.NAMED_TYPE), (String)"\"NAMED_TYPE_SIGNATURE\"");
        Assert.assertEquals((String)PARAMETER_KIND_CODEC.toJson((Object)ParameterKind.LONG), (String)"\"LONG_LITERAL\"");
        Assert.assertEquals((String)PARAMETER_KIND_CODEC.toJson((Object)ParameterKind.VARIABLE), (String)"\"VARIABLE\"");
    }

    @Test
    public void testDeserializeFromOldFormat() {
        Assert.assertEquals((Object)PARAMETER_KIND_CODEC.fromJson("\"TYPE_SIGNATURE\""), (Object)ParameterKind.TYPE);
        Assert.assertEquals((Object)PARAMETER_KIND_CODEC.fromJson("\"NAMED_TYPE_SIGNATURE\""), (Object)ParameterKind.NAMED_TYPE);
        Assert.assertEquals((Object)PARAMETER_KIND_CODEC.fromJson("\"LONG_LITERAL\""), (Object)ParameterKind.LONG);
        Assert.assertEquals((Object)PARAMETER_KIND_CODEC.fromJson("\"VARIABLE\""), (Object)ParameterKind.VARIABLE);
    }

    @Test
    public void testDeserializeFromNewFormat() {
        Assert.assertEquals((Object)PARAMETER_KIND_CODEC.fromJson("\"TYPE\""), (Object)ParameterKind.TYPE);
        Assert.assertEquals((Object)PARAMETER_KIND_CODEC.fromJson("\"NAMED_TYPE\""), (Object)ParameterKind.NAMED_TYPE);
        Assert.assertEquals((Object)PARAMETER_KIND_CODEC.fromJson("\"LONG\""), (Object)ParameterKind.LONG);
        Assert.assertEquals((Object)PARAMETER_KIND_CODEC.fromJson("\"VARIABLE\""), (Object)ParameterKind.VARIABLE);
    }

    static {
        JsonObjectMapperProvider provider = new JsonObjectMapperProvider();
        JsonCodecFactory codecFactory = new JsonCodecFactory((Provider)provider);
        PARAMETER_KIND_CODEC = codecFactory.jsonCodec(ParameterKind.class);
    }
}

